/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security;

import com.google.gson.JsonParseException;
import java.util.HashMap;
import java.util.Map;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.restheart.configuration.ConfigurationException;
import org.restheart.exchange.Request;
import org.restheart.plugins.ConfigurablePlugin;
import org.restheart.security.BaseAclPermission;
import org.restheart.utils.BsonUtils;

public class MongoPermissions {
    private final boolean allowManagementRequests;
    private final boolean allowBulkPatch;
    private final boolean allowBulkDelete;
    private final boolean allowWriteMode;
    private final BsonDocument mergeRequest;
    private final BsonDocument projectResponse;
    private final BsonDocument readFilter;
    private final BsonDocument writeFilter;
    public static final MongoPermissions ALLOW_ALL_MONGO_PERMISSIONS = new MongoPermissions(null, null, true, true, true, true, null, null);

    public MongoPermissions() {
        this.allowManagementRequests = false;
        this.allowBulkPatch = false;
        this.allowBulkDelete = false;
        this.allowWriteMode = false;
        this.readFilter = null;
        this.writeFilter = null;
        this.mergeRequest = null;
        this.projectResponse = null;
    }

    MongoPermissions(BsonDocument readFilter, BsonDocument writeFilter, boolean allowManagementRequests, boolean allowBulkPatch, boolean allowBulkDelete, boolean allowWriteMode, BsonDocument mergeRequest, BsonDocument projectResponse) {
        BsonDocument bsonDocument = readFilter == null ? null : (this.readFilter = readFilter.isNull() ? null : BsonUtils.escapeKeys((BsonValue)readFilter.asDocument(), true).asDocument());
        this.writeFilter = writeFilter == null ? null : (writeFilter.isNull() ? null : BsonUtils.escapeKeys((BsonValue)writeFilter.asDocument(), true).asDocument());
        this.allowManagementRequests = allowManagementRequests;
        this.allowBulkPatch = allowBulkPatch;
        this.allowBulkDelete = allowBulkDelete;
        this.allowWriteMode = allowWriteMode;
        this.mergeRequest = mergeRequest;
        this.projectResponse = projectResponse;
    }

    public static MongoPermissions of(Request<?> request) throws ConfigurationException, IllegalArgumentException {
        return MongoPermissions.from(BaseAclPermission.getRaw(request));
    }

    public static MongoPermissions from(BaseAclPermission p) throws ConfigurationException, IllegalArgumentException {
        return MongoPermissions.from(p.getRaw());
    }

    public static MongoPermissions from(Object raw) throws ConfigurationException, IllegalArgumentException {
        if (raw == null) {
            return new MongoPermissions();
        }
        if (raw instanceof BsonDocument) {
            return MongoPermissions.from((BsonDocument)raw);
        }
        if (raw instanceof Map) {
            return MongoPermissions.from((Map)raw);
        }
        throw new IllegalArgumentException("MongoPemissions cannot be built from " + raw.getClass().getSimpleName());
    }

    public static MongoPermissions from(BsonDocument args) throws ConfigurationException {
        BsonDocument projectResponse;
        if (args == null || args.isEmpty() || !args.containsKey((Object)"mongo") || !args.get((Object)"mongo").isDocument()) {
            return new MongoPermissions();
        }
        BsonValue _readFilter = (args = args.get((Object)"mongo").asDocument()).get((Object)"readFilter");
        if (_readFilter != null && !_readFilter.isNull() && !_readFilter.isDocument()) {
            throw new ConfigurationException("Wrong permission: readFilter must be a JSON object or null");
        }
        BsonDocument readFilter = _readFilter == null ? null : (_readFilter.isNull() ? null : BsonUtils.escapeKeys((BsonValue)_readFilter.asDocument(), true).asDocument());
        BsonValue _writeFilter = args.get((Object)"writeFilter");
        if (_writeFilter != null && !_writeFilter.isNull() && !_writeFilter.isDocument()) {
            throw new ConfigurationException("Wrong permission: writeFilter must be a JSON object or null");
        }
        BsonDocument writeFilter = _writeFilter == null ? null : (_writeFilter.isNull() ? null : BsonUtils.escapeKeys((BsonValue)_writeFilter.asDocument(), true).asDocument());
        BsonValue _mergeRequest = args.get((Object)"mergeRequest");
        if (_mergeRequest != null && !_mergeRequest.isNull() && !_mergeRequest.isDocument()) {
            throw new ConfigurationException("Wrong permission: mergeRequest must be a JSON object or null");
        }
        BsonDocument mergeRequest = _mergeRequest == null ? null : (_mergeRequest.isNull() ? null : _mergeRequest.asDocument());
        BsonValue _projectResponse = args.get((Object)"projectResponse");
        if (_projectResponse != null && !_projectResponse.isNull() && !_projectResponse.isDocument()) {
            throw new ConfigurationException("Wrong permission: _projectResponse must be a JSON object or null");
        }
        BsonDocument bsonDocument = _projectResponse == null ? null : (projectResponse = _projectResponse.isNull() ? null : _projectResponse.asDocument());
        if (projectResponse != null && projectResponse.isDocument()) {
            boolean zeros = false;
            boolean ones = false;
            for (String key : projectResponse.keySet()) {
                if (projectResponse.get((Object)key).isInt32()) {
                    if (projectResponse.get((Object)key).asInt32().getValue() == 0) {
                        if (ones) {
                            throw new ConfigurationException("Wrong permission: the projectResponse contains invalid projection options, cannot have a mix of inclusion and exclusion");
                        }
                        zeros = true;
                        continue;
                    }
                    if (projectResponse.get((Object)key).asInt32().getValue() == 1) {
                        if (zeros) {
                            throw new ConfigurationException("Wrong permission: the projectResponse contains invalid projection options, cannot have a mix of inclusion and exclusion");
                        }
                        ones = true;
                        continue;
                    }
                    throw new ConfigurationException("Wrong permission: the projectResponse contains invalid projection options, valid values are 0 and 1");
                }
                throw new ConfigurationException("Wrong permission: the projectResponse contains invalid projection options, valid values are 0 and 1");
            }
        } else {
            projectResponse = null;
        }
        return new MongoPermissions(readFilter, writeFilter, MongoPermissions.parseBooleanArg(args, "allowManagementRequests"), MongoPermissions.parseBooleanArg(args, "allowBulkPatch"), MongoPermissions.parseBooleanArg(args, "allowBulkDelete"), MongoPermissions.parseBooleanArg(args, "allowWriteMode"), mergeRequest, projectResponse);
    }

    public BsonDocument asBson() {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("allowManagementRequests", this.allowManagementRequests);
        map.put("allowBulkPatch", this.allowBulkPatch);
        map.put("allowBulkDelete", this.allowBulkDelete);
        map.put("allowWriteMode", this.allowWriteMode);
        map.put("readFilter", (Boolean)this.readFilter);
        map.put("writeFilter", (Boolean)this.writeFilter);
        return BsonUtils.toBsonDocument(map);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MongoPermissions from(Map<String, Object> args) throws ConfigurationException {
        if (args == null || args.isEmpty() || !args.containsKey("mongo") || !(args.get("mongo") instanceof Map)) {
            return new MongoPermissions();
        }
        args = (Map)args.get("mongo");
        BsonDocument readFilter = null;
        BsonDocument writeFilter = null;
        if (args.containsKey("readFilter")) {
            try {
                String __readFilter = (String)ConfigurablePlugin.argValue(args, "readFilter");
                BsonDocument _readFilter = BsonDocument.parse((String)__readFilter);
                if (_readFilter != null && !_readFilter.isNull() && !_readFilter.isDocument()) {
                    throw new IllegalArgumentException("Wrong permission: readFilter must be a JSON object or null");
                }
                readFilter = _readFilter == null ? null : (_readFilter.isNull() ? null : BsonUtils.escapeKeys((BsonValue)_readFilter.asDocument(), true).asDocument());
            }
            catch (JsonParseException | ClassCastException jpe) {
                throw new ConfigurationException("Wrong permission: the readFilter is not a string containing a JSON Object", jpe);
            }
        } else {
            readFilter = null;
        }
        if (args.containsKey("writeFilter")) {
            try {
                String __writeFilter = (String)ConfigurablePlugin.argValue(args, "writeFilter");
                BsonDocument _writeFilter = BsonDocument.parse((String)__writeFilter);
                if (_writeFilter != null && !_writeFilter.isNull() && !_writeFilter.isDocument()) {
                    throw new ConfigurationException("writeFilter must be a JSON object or null");
                }
                writeFilter = _writeFilter == null ? null : (_writeFilter.isNull() ? null : BsonUtils.escapeKeys((BsonValue)_writeFilter.asDocument(), true).asDocument());
            }
            catch (JsonParseException | ClassCastException jpe) {
                throw new ConfigurationException("Wrong permission: the writeFilter is not a string defining a JSON Object", jpe);
            }
        } else {
            writeFilter = null;
        }
        BsonDocument mergeRequest = null;
        if (args.containsKey("mergeRequest")) {
            try {
                String __mergeRequest = (String)ConfigurablePlugin.argValue(args, "mergeRequest");
                BsonDocument _mergeRequest = BsonDocument.parse((String)__mergeRequest);
                if (_mergeRequest != null && !_mergeRequest.isNull() && !_mergeRequest.isDocument()) {
                    throw new ConfigurationException("mergeRequest must be a JSON object or null");
                }
                mergeRequest = _mergeRequest == null ? null : (_mergeRequest.isNull() ? null : _mergeRequest.asDocument());
            }
            catch (JsonParseException | ClassCastException jpe) {
                throw new ConfigurationException("Wrong permission: the mergeRequest is not a string defining a JSON Object", jpe);
            }
        } else {
            mergeRequest = null;
        }
        BsonDocument projectResponse = null;
        if (args.containsKey("projectResponse")) {
            try {
                String __projectResponse = (String)ConfigurablePlugin.argValue(args, "projectResponse");
                BsonDocument _projectResponse = BsonDocument.parse((String)__projectResponse);
                if (_projectResponse != null && !_projectResponse.isNull() && !_projectResponse.isDocument()) {
                    throw new ConfigurationException("projectResponse must be a JSON object or null");
                }
                BsonDocument bsonDocument = _projectResponse == null ? null : (_projectResponse = _projectResponse.isNull() ? null : _projectResponse.asDocument());
                if (_projectResponse == null || !_projectResponse.isDocument()) return new MongoPermissions(readFilter, writeFilter, MongoPermissions.parseBooleanArg(args, "allowManagementRequests"), MongoPermissions.parseBooleanArg(args, "allowBulkPatch"), MongoPermissions.parseBooleanArg(args, "allowBulkDelete"), MongoPermissions.parseBooleanArg(args, "allowWriteMode"), mergeRequest, projectResponse);
                boolean zeros = false;
                boolean ones = false;
                for (String key : _projectResponse.keySet()) {
                    if (!_projectResponse.get((Object)key).isInt32()) throw new ConfigurationException("Wrong permission: the projectResponse contains invalid projection options, valid values are 0 and 1");
                    if (_projectResponse.get((Object)key).asInt32().getValue() == 0) {
                        if (ones) {
                            throw new ConfigurationException("Wrong permission: the projectResponse contains invalid projection options, cannot have a mix of inclusion and exclusion");
                        }
                        zeros = true;
                        continue;
                    }
                    if (_projectResponse.get((Object)key).asInt32().getValue() != 1) throw new ConfigurationException("Wrong permission: the projectResponse contains invalid projection options, valid values are 0 and 1");
                    if (zeros) {
                        throw new ConfigurationException("Wrong permission: the projectResponse contains invalid projection options, cannot have a mix of inclusion and exclusion");
                    }
                    ones = true;
                }
                projectResponse = _projectResponse.asDocument();
                return new MongoPermissions(readFilter, writeFilter, MongoPermissions.parseBooleanArg(args, "allowManagementRequests"), MongoPermissions.parseBooleanArg(args, "allowBulkPatch"), MongoPermissions.parseBooleanArg(args, "allowBulkDelete"), MongoPermissions.parseBooleanArg(args, "allowWriteMode"), mergeRequest, projectResponse);
            }
            catch (JsonParseException | ClassCastException jpe) {
                throw new ConfigurationException("Wrong permission: the projectResponse is not a string defining a JSON Object", jpe);
            }
        } else {
            projectResponse = null;
        }
        return new MongoPermissions(readFilter, writeFilter, MongoPermissions.parseBooleanArg(args, "allowManagementRequests"), MongoPermissions.parseBooleanArg(args, "allowBulkPatch"), MongoPermissions.parseBooleanArg(args, "allowBulkDelete"), MongoPermissions.parseBooleanArg(args, "allowWriteMode"), mergeRequest, projectResponse);
    }

    private static boolean parseBooleanArg(Map<String, Object> args, String key) throws ConfigurationException {
        if (args.containsKey(key)) {
            Object _value = ConfigurablePlugin.argValue(args, key);
            if (_value != null && _value instanceof Boolean) {
                return (Boolean)_value;
            }
            throw new ConfigurationException("Wrong permission: mongo." + key + " must be a boolean");
        }
        return false;
    }

    private static boolean parseBooleanArg(BsonDocument args, String key) throws ConfigurationException {
        if (args.containsKey((Object)key)) {
            BsonValue _value = args.get((Object)key);
            if (_value != null && _value.isBoolean()) {
                return _value.asBoolean().getValue();
            }
            throw new ConfigurationException("Wrong permission: mongo." + key + " must be a boolean");
        }
        return false;
    }

    public BsonDocument getReadFilter() {
        return this.readFilter == null || this.readFilter.isNull() ? null : BsonUtils.unescapeKeys((BsonValue)this.readFilter).asDocument();
    }

    public BsonDocument getWriteFilter() {
        return this.writeFilter == null || this.writeFilter.isNull() ? this.writeFilter : BsonUtils.unescapeKeys((BsonValue)this.writeFilter).asDocument();
    }

    public BsonDocument getMergeRequest() {
        return this.mergeRequest;
    }

    public BsonDocument getProjectResponse() {
        return this.projectResponse;
    }

    public boolean getAllowManagementRequests() {
        return this.allowManagementRequests;
    }

    public boolean isAllowManagementRequests() {
        return this.allowManagementRequests;
    }

    public boolean getAllowBulkPatch() {
        return this.allowBulkPatch;
    }

    public boolean isAllowBulkPatch() {
        return this.allowBulkPatch;
    }

    public boolean getAllowBulkDelete() {
        return this.allowBulkDelete;
    }

    public boolean isAllowBulkDelete() {
        return this.allowBulkDelete;
    }

    public boolean getAllowWriteMode() {
        return this.allowWriteMode;
    }

    public boolean isAllowWriteMode() {
        return this.allowWriteMode;
    }
}

