/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.security;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.restheart.security.PwdCredentialAccount;
import org.restheart.security.WithProperties;
import org.restheart.utils.BsonUtils;

public class MongoRealmAccount
extends PwdCredentialAccount
implements WithProperties<BsonDocument> {
    private static final long serialVersionUID = -5840534832968478775L;
    private final BsonDocument properties;
    private static Gson GSON = new GsonBuilder().serializeNulls().create();

    public MongoRealmAccount(String name, char[] password, Set<String> roles, BsonDocument properties) {
        super(name, password, roles);
        if (password == null) {
            throw new IllegalArgumentException("argument password cannot be null");
        }
        this.properties = properties;
    }

    @Override
    public BsonDocument properties() {
        return this.properties;
    }

    @Override
    public Map<String, ? super Object> propertiesAsMap() {
        if (this.properties == null) {
            return null;
        }
        return (Map)GSON.fromJson(BsonUtils.toJson((BsonValue)this.properties), HashMap.class);
    }
}

