/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.utils;

import com.google.common.collect.Sets;
import com.mongodb.MongoClientSettings;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.jxpath.JXPathContext;
import org.bson.BsonArray;
import org.bson.BsonBoolean;
import org.bson.BsonDateTime;
import org.bson.BsonDecimal128;
import org.bson.BsonDocument;
import org.bson.BsonDocumentReader;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonInvalidOperationException;
import org.bson.BsonJavaScript;
import org.bson.BsonMaxKey;
import org.bson.BsonMinKey;
import org.bson.BsonNull;
import org.bson.BsonObjectId;
import org.bson.BsonReader;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.codecs.BsonArrayCodec;
import org.bson.codecs.BsonValueCodecProvider;
import org.bson.codecs.DecoderContext;
import org.bson.codecs.DocumentCodec;
import org.bson.codecs.configuration.CodecProvider;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.json.JsonMode;
import org.bson.json.JsonParseException;
import org.bson.json.JsonReader;
import org.bson.json.JsonWriterSettings;
import org.bson.types.Decimal128;
import org.bson.types.ObjectId;
import org.restheart.utils.JsonUnflattener;
import org.restheart.utils.Minify;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BsonUtils {
    static final Logger LOGGER = LoggerFactory.getLogger(BsonUtils.class);
    private static final BsonArrayCodec BSON_ARRAY_CODEC = new BsonArrayCodec(CodecRegistries.fromProviders((CodecProvider[])new CodecProvider[]{new BsonValueCodecProvider()}));
    private static final String ESCAPED_DOLLAR = "_$";
    private static final String ESCAPED_DOT = "::";
    private static final String DOLLAR = "$";
    public static final CodecRegistry DEFAULT_CODEC_REGISTRY = MongoClientSettings.getDefaultCodecRegistry();
    private static final String[] _UPDATE_OPERATORS = new String[]{"$inc", "$mul", "$rename", "$setOnInsert", "$set", "$unset", "$min", "$max", "$currentDate", "$", "$[]", "$addToSet", "$pop", "$pullAll", "$pull", "$pushAll", "$push", "$each", "$position", "$slice", "$sort", "$bit", "$isolated"};
    private static final List<String> UPDATE_OPERATORS = Collections.unmodifiableList(Arrays.asList(_UPDATE_OPERATORS));
    private static final DocumentCodec codec = new DocumentCodec();

    public static BsonValue unescapeKeys(BsonValue json) {
        if (json == null) {
            return null;
        }
        if (json.isDocument()) {
            BsonDocument ret = new BsonDocument();
            json.asDocument().keySet().stream().forEach(k -> {
                String newKey = k.startsWith(ESCAPED_DOLLAR) ? k.substring(1) : k;
                newKey = newKey.replaceAll(ESCAPED_DOT, ".");
                BsonValue value = json.asDocument().get(k);
                if (value.isDocument()) {
                    ret.put(newKey, BsonUtils.unescapeKeys(value));
                } else if (value.isArray()) {
                    BsonArray newList = new BsonArray();
                    value.asArray().stream().forEach(v -> newList.add(BsonUtils.unescapeKeys(v)));
                    ret.put(newKey, (BsonValue)newList);
                } else {
                    ret.put(newKey, BsonUtils.unescapeKeys(value));
                }
            });
            return ret;
        }
        if (json.isArray()) {
            BsonArray ret = new BsonArray();
            json.asArray().stream().forEach(value -> {
                if (value.isDocument()) {
                    ret.add(BsonUtils.unescapeKeys(value));
                } else if (value.isArray()) {
                    BsonArray newList = new BsonArray();
                    value.asArray().stream().forEach(v -> newList.add(BsonUtils.unescapeKeys(v)));
                    ret.add((BsonValue)newList);
                } else {
                    ret.add(BsonUtils.unescapeKeys(value));
                }
            });
            return ret;
        }
        if (json.isString()) {
            return json.asString().getValue().startsWith(ESCAPED_DOLLAR) ? new BsonString(json.asString().getValue().substring(1)) : json;
        }
        return json;
    }

    public static BsonValue escapeKeys(BsonValue json, boolean escapeDots) {
        return BsonUtils.escapeKeys(json, escapeDots, false);
    }

    public static BsonValue escapeKeys(BsonValue json, boolean escapeDots, boolean dontEscapeDotsInRootKeys) {
        if (json == null) {
            return null;
        }
        if (json.isDocument()) {
            BsonDocument ret = new BsonDocument();
            boolean[] root = new boolean[]{true};
            json.asDocument().keySet().stream().forEach(k -> {
                Object newKey;
                Object object = newKey = k.startsWith(DOLLAR) ? "_" + k : k;
                if (!(!escapeDots || dontEscapeDotsInRootKeys && root[0])) {
                    newKey = ((String)newKey).replaceAll("\\.", ESCAPED_DOT);
                }
                root[0] = false;
                BsonValue value = json.asDocument().get(k);
                if (value.isDocument()) {
                    ret.put((String)newKey, BsonUtils.escapeKeys(value, escapeDots, false));
                } else if (value.isArray()) {
                    BsonArray newList = new BsonArray();
                    value.asArray().stream().forEach(v -> newList.add(BsonUtils.escapeKeys(v, escapeDots, false)));
                    ret.put((String)newKey, (BsonValue)newList);
                } else {
                    ret.put((String)newKey, value);
                }
            });
            return ret;
        }
        if (json.isArray()) {
            ArrayBuilder ret = BsonUtils.array();
            json.asArray().stream().forEach(value -> {
                if (value.isDocument()) {
                    ret.add(BsonUtils.escapeKeys(value, escapeDots, dontEscapeDotsInRootKeys));
                } else if (value.isArray()) {
                    BsonArray newList = new BsonArray();
                    value.asArray().stream().forEach(v -> newList.add(BsonUtils.escapeKeys(v, escapeDots, false)));
                    ret.add(new BsonValue[]{newList});
                } else {
                    ret.add((BsonValue)value);
                }
            });
            return ret.get();
        }
        if (json.isString()) {
            return json.asString().getValue().startsWith(DOLLAR) ? new BsonString("_" + json.asString().getValue()) : json;
        }
        return json;
    }

    public static List<Optional<BsonValue>> getPropsFromPath(BsonValue root, String path) throws IllegalArgumentException {
        String[] pathTokens = path.split(Pattern.quote("."));
        if (pathTokens == null || pathTokens.length == 0 || !pathTokens[0].equals(DOLLAR)) {
            throw new IllegalArgumentException("wrong path. it must use the . notation and start with $");
        }
        if (!(root instanceof BsonDocument)) {
            throw new IllegalArgumentException("wrong json. it must be an object");
        }
        return BsonUtils._getPropsFromPath(root, pathTokens, pathTokens.length);
    }

    public static Optional<BsonValue> get(BsonDocument doc, String path) {
        String xpath = BsonUtils.dotNotationToXPath(path);
        if (path == null) {
            return Optional.empty();
        }
        if (doc.containsKey((Object)path)) {
            return Optional.of(doc.get((Object)path));
        }
        JXPathContext ctx = JXPathContext.newContext((Object)doc);
        try {
            return Optional.of((BsonValue)ctx.getValue(xpath));
        }
        catch (Throwable t) {
            return Optional.empty();
        }
    }

    private static String dotNotationToXPath(String dn) {
        if (dn == null) {
            return null;
        }
        dn = dn.replaceAll("\\.(?!.*'\\])", "/");
        dn = dn.replaceAll("\\['", "/");
        if ((dn = dn.replaceAll("'\\]", "/")).endsWith("/")) {
            dn = dn.substring(0, dn.length() - 1);
        }
        dn = Pattern.compile("\\[(?<idx>\\d*)\\]").matcher(dn).replaceAll(mr -> BsonUtils.inc(mr.group()));
        return "/".concat(dn);
    }

    private static String inc(String n) {
        String _n = n.replaceAll("\\[", "").replaceAll("\\]", "");
        try {
            return "[" + (Integer.parseInt(_n) + 1) + "]";
        }
        catch (NumberFormatException nfe) {
            return n;
        }
    }

    private static List<Optional<BsonValue>> _getPropsFromPath(BsonValue json, String[] pathTokens, int totalTokensLength) throws IllegalArgumentException {
        String pathToken;
        if (pathTokens == null) {
            throw new IllegalArgumentException("pathTokens argument cannot be null");
        }
        if (pathTokens.length > 0) {
            if (json == null) {
                return null;
            }
            pathToken = pathTokens[0];
            if ("".equals(pathToken)) {
                throw new IllegalArgumentException("wrong path " + Arrays.toString(pathTokens) + " path tokens cannot be empty strings");
            }
        } else {
            if (json.isNull()) {
                ArrayList<Optional<BsonValue>> ret = new ArrayList<Optional<BsonValue>>();
                ret.add(Optional.empty());
                return ret;
            }
            ArrayList<Optional<BsonValue>> ret = new ArrayList<Optional<BsonValue>>();
            ret.add(Optional.ofNullable(json));
            return ret;
        }
        switch (pathToken) {
            case "$": {
                if (!json.isDocument()) {
                    throw new IllegalArgumentException("wrong path " + Arrays.toString(pathTokens) + " at token " + pathToken + "; it should be an object but found " + json.toString());
                }
                if (pathTokens.length != totalTokensLength) {
                    throw new IllegalArgumentException("wrong path " + Arrays.toString(pathTokens) + " at token " + pathToken + "; $ can only start the expression");
                }
                return BsonUtils._getPropsFromPath(json, BsonUtils.subpath(pathTokens), totalTokensLength);
            }
            case "*": {
                if (!json.isDocument()) {
                    return null;
                }
                ArrayList<Optional<BsonValue>> ret = new ArrayList<Optional<BsonValue>>();
                for (String key : json.asDocument().keySet()) {
                    List<Optional<BsonValue>> nested = BsonUtils._getPropsFromPath(json.asDocument().get((Object)key), BsonUtils.subpath(pathTokens), totalTokensLength);
                    if (nested == null && pathTokens.length == 2) {
                        ret.add(null);
                        continue;
                    }
                    if (nested == null) continue;
                    ret.addAll(nested);
                }
                return ret;
            }
            case "[*]": {
                if (!json.isArray()) {
                    boolean allNumbericKeys;
                    if (json.isDocument() && (allNumbericKeys = json.asDocument().keySet().stream().allMatch(k -> {
                        try {
                            Integer.valueOf(k);
                            return true;
                        }
                        catch (NumberFormatException nfe) {
                            return false;
                        }
                    }))) {
                        ArrayList<Optional<BsonValue>> ret = new ArrayList<Optional<BsonValue>>();
                        for (String key : json.asDocument().keySet()) {
                            List<Optional<BsonValue>> nested = BsonUtils._getPropsFromPath(json.asDocument().get((Object)key), BsonUtils.subpath(pathTokens), totalTokensLength);
                            if (nested == null && pathTokens.length == 2) {
                                ret.add(null);
                                continue;
                            }
                            if (nested == null) continue;
                            ret.addAll(nested);
                        }
                        return ret;
                    }
                    return null;
                }
                ArrayList<Optional<BsonValue>> ret = new ArrayList<Optional<BsonValue>>();
                if (!json.asArray().isEmpty()) {
                    for (int index = 0; index < json.asArray().size(); ++index) {
                        List<Optional<BsonValue>> nested = BsonUtils._getPropsFromPath(json.asArray().get(index), BsonUtils.subpath(pathTokens), totalTokensLength);
                        if (nested == null && pathTokens.length == 2) {
                            ret.add(null);
                            continue;
                        }
                        if (nested == null) continue;
                        ret.addAll(nested);
                    }
                }
                return ret;
            }
        }
        if (json.isArray()) {
            throw new IllegalArgumentException("wrong path " + BsonUtils.pathFromTokens(pathTokens) + " at token " + pathToken + "; it should be '[*]'");
        }
        if (json.isDocument()) {
            if (json.asDocument().containsKey((Object)pathToken)) {
                return BsonUtils._getPropsFromPath(json.asDocument().get((Object)pathToken), BsonUtils.subpath(pathTokens), totalTokensLength);
            }
            return null;
        }
        return null;
    }

    public static boolean isAncestorPath(String left, String right) {
        if (left == null || !left.startsWith(DOLLAR)) {
            throw new IllegalArgumentException("wrong left path: " + left);
        }
        if (right == null || !right.startsWith(DOLLAR)) {
            throw new IllegalArgumentException("wrong right path: " + right);
        }
        boolean ret = true;
        if (!right.startsWith(left)) {
            String[] rightPathTokens;
            String[] leftPathTokens = left.split(Pattern.quote("."));
            if (leftPathTokens.length > (rightPathTokens = right.split(Pattern.quote("."))).length) {
                ret = false;
            } else {
                block10: for (int cont = 0; cont < leftPathTokens.length; ++cont) {
                    String lt = leftPathTokens[cont];
                    String rt = rightPathTokens[cont];
                    switch (lt) {
                        case "*": {
                            continue block10;
                        }
                        case "[*]": {
                            try {
                                Integer.valueOf(rt);
                                continue block10;
                            }
                            catch (NumberFormatException nfe) {
                                ret = false;
                                break block10;
                            }
                        }
                        default: {
                            ret = rt.equals(lt);
                            if (!ret) break block10;
                        }
                    }
                }
            }
        }
        LOGGER.trace("isAncestorPath: {} -> {} -> {}", new Object[]{left, right, ret});
        return ret;
    }

    public static Integer countPropsFromPath(BsonValue root, String path) throws IllegalArgumentException {
        List<Optional<BsonValue>> items = BsonUtils.getPropsFromPath(root, path);
        if (items == null) {
            return null;
        }
        return items.size();
    }

    private static String pathFromTokens(String[] pathTokens) {
        if (pathTokens == null) {
            return null;
        }
        StringBuilder ret = new StringBuilder();
        for (int cont = 1; cont < pathTokens.length; ++cont) {
            ret = ret.append(pathTokens[cont]);
            if (cont >= pathTokens.length - 1) continue;
            ret = ret.append(".");
        }
        return ret.toString();
    }

    private static String[] subpath(String[] pathTokens) {
        ArrayList<String> subpath = new ArrayList<String>();
        for (int cont = 1; cont < pathTokens.length; ++cont) {
            subpath.add(pathTokens[cont]);
        }
        return (String[])subpath.toArray(String[]::new);
    }

    public static boolean checkType(Optional<BsonValue> o, String type) {
        if (!(o.isPresent() || "null".equals(type) || "notnull".equals(type))) {
            return false;
        }
        return switch (type.toLowerCase().strip()) {
            case "null" -> {
                if (!o.isPresent()) {
                    yield true;
                }
                yield false;
            }
            case "notnull" -> o.isPresent();
            case "object" -> o.get().isDocument();
            case "array" -> o.get().isArray();
            case "string" -> o.get().isString();
            case "number" -> o.get().isNumber();
            case "boolean" -> o.get().isBoolean();
            case "objectid" -> o.get().isObjectId();
            case "objectidstring" -> {
                if (o.get().isString() && ObjectId.isValid((String)o.get().asString().getValue())) {
                    yield true;
                }
                yield false;
            }
            case "date" -> o.get().isDateTime();
            case "timestamp" -> o.get().isTimestamp();
            case "maxkey" -> o.get() instanceof BsonMaxKey;
            case "minkey" -> o.get() instanceof BsonMinKey;
            case "symbol" -> o.get().isSymbol();
            case "code" -> o.get() instanceof BsonJavaScript;
            default -> false;
        };
    }

    public static StringBuilder minify(String jsonString) {
        return new Minify().minify(jsonString);
    }

    public static BsonValue parse(String json) throws JsonParseException {
        BsonValue bsonValue;
        if (json == null) {
            return null;
        }
        char fnws = BsonUtils.firstNonWhitespace(json);
        switch (fnws) {
            case '\u0000': {
                BsonValue bsonValue2;
                bsonValue = bsonValue2 = null;
                break;
            }
            case '{': {
                try {
                    BsonDocument bsonDocument = BsonDocument.parse((String)json);
                    bsonValue = bsonDocument;
                }
                catch (BsonInvalidOperationException ex) {
                    BsonValue bsonValue3;
                    bsonValue = bsonValue3 = BsonUtils.getBsonValue(json);
                }
                break;
            }
            case '[': {
                try (JsonReader jr = new JsonReader(json);){
                    BsonArray bsonArray = BSON_ARRAY_CODEC.decode((BsonReader)jr, DecoderContext.builder().build());
                    bsonValue = bsonArray;
                    break;
                }
            }
            default: {
                BsonValue bsonValue4;
                bsonValue = bsonValue4 = BsonUtils.getBsonValue(json);
            }
        }
        return bsonValue;
    }

    static char firstNonWhitespace(String s) {
        if (s == null || s.isBlank()) {
            return '\u0000';
        }
        Optional<Character> f = s.chars().filter(c -> !Character.isWhitespace(c)).mapToObj(c -> Character.valueOf((char)c)).findFirst();
        return f.isPresent() ? f.get().charValue() : (char)'\u0000';
    }

    private static BsonValue getBsonValue(String json) {
        return BsonDocument.parse((String)"{'x':".concat(json).concat("}")).get((Object)"x");
    }

    public static String toJson(BsonValue bson) {
        return BsonUtils.toJson(bson, null);
    }

    public static String toJson(BsonValue bson, JsonMode mode) {
        JsonWriterSettings settings;
        if (bson == null) {
            return null;
        }
        JsonWriterSettings jsonWriterSettings = settings = mode != null ? JsonWriterSettings.builder().outputMode(mode).indent(false).build() : JsonWriterSettings.builder().indent(false).dateTimeConverter((t, writer) -> writer.writeRaw("{\"$date\": " + t + " }")).build();
        if (bson.isDocument()) {
            return bson.asDocument().toJson(settings);
        }
        if (bson.isArray()) {
            BsonDocument wrappedArray = new BsonDocument("w", (BsonValue)bson.asArray());
            String json = wrappedArray.toJson(settings);
            return json.substring(6, json.length() - 1);
        }
        String ret = new BsonDocument("x", bson).toJson(settings);
        ret = ret.replaceFirst("\\{", "");
        ret = ret.replaceFirst("\"x\"", "");
        ret = ret.replaceFirst(":", "");
        int index = ret.lastIndexOf(125);
        ret = ret.substring(0, index);
        return ret;
    }

    public static String getIdAsString(BsonValue id, boolean quote) {
        if (id == null) {
            return null;
        }
        if (id.isString()) {
            return quote ? "'" + id.asString().getValue() + "'" : id.asString().getValue();
        }
        if (id.isObjectId()) {
            return id.asObjectId().getValue().toString();
        }
        return BsonUtils.minify(BsonUtils.toJson(id).replace("\"", "'")).toString();
    }

    public static BsonDocument toBsonDocument(Map<String, ? super Object> map) {
        if (map == null) {
            return null;
        }
        return new Document(map).toBsonDocument(BsonDocument.class, DEFAULT_CODEC_REGISTRY);
    }

    public static boolean isUpdateOperator(String key) {
        return UPDATE_OPERATORS.contains(key);
    }

    public static boolean containsUpdateOperators(BsonValue json) {
        return BsonUtils.containsUpdateOperators(json, false);
    }

    public static boolean containsUpdateOperators(BsonValue json, boolean ignoreCurrentDate) {
        if (json == null) {
            return false;
        }
        if (json.isDocument()) {
            return BsonUtils._containsUpdateOperators(json.asDocument(), ignoreCurrentDate);
        }
        if (json.isArray()) {
            return json.asArray().stream().filter(el -> el.isDocument()).anyMatch(element -> BsonUtils._containsUpdateOperators(element.asDocument(), ignoreCurrentDate));
        }
        return false;
    }

    private static boolean _containsUpdateOperators(BsonDocument json, boolean ignoreCurrentDate) {
        if (json == null) {
            return false;
        }
        return json.asDocument().keySet().stream().filter(key -> !ignoreCurrentDate || !key.equals("$currentDate")).anyMatch(key -> BsonUtils.isUpdateOperator(key));
    }

    public static BsonValue unflatten(BsonValue json) throws IllegalArgumentException {
        return new JsonUnflattener(json).unflatten();
    }

    public static BsonDocument flatten(BsonDocument json, boolean ignoreUpdateOperators) {
        List keys = json.keySet().stream().filter(key -> !ignoreUpdateOperators || !BsonUtils.isUpdateOperator(key)).collect(Collectors.toList());
        if (keys != null && !keys.isEmpty()) {
            BsonDocument ret = new BsonDocument();
            json.keySet().stream().filter(key -> BsonUtils.isUpdateOperator(key)).forEach(key -> ret.put(key, json.get(key)));
            keys.stream().forEach(key -> BsonUtils.flatten(null, key, json, ret));
            return ret;
        }
        return json;
    }

    private static void flatten(String prefix, String key, BsonDocument data, BsonDocument set) {
        String newPrefix = prefix == null ? key : prefix + "." + key;
        BsonValue value = data.get((Object)key);
        if (value.isDocument()) {
            value.asDocument().keySet().forEach(childKey -> BsonUtils.flatten(newPrefix, childKey, value.asDocument(), set));
        } else {
            set.append(newPrefix, value);
        }
    }

    public static boolean containsKeys(BsonValue docOrArray, Set<String> keys, boolean all) {
        if (docOrArray == null) {
            return false;
        }
        if (docOrArray.isArray()) {
            BsonArray array = docOrArray.asArray();
            if (array.isEmpty()) {
                return false;
            }
            return all ? array.stream().allMatch(doc -> BsonUtils.containsKeys(doc, keys, all)) : array.stream().anyMatch(doc -> BsonUtils.containsKeys(doc, keys, all));
        }
        if (docOrArray.isDocument()) {
            return BsonUtils._containsKeys(docOrArray.asDocument(), keys, all);
        }
        return false;
    }

    private static boolean _containsKeys(BsonDocument doc, Set<String> keys, boolean all) {
        BsonDocument ufdoc = BsonUtils.unflatten((BsonValue)doc).asDocument();
        return all ? keys.stream().allMatch(key -> BsonUtils._containsKeys(ufdoc, key, all)) : keys.stream().anyMatch(key -> BsonUtils._containsKeys(ufdoc, key, all));
    }

    private static boolean _containsKeys(BsonDocument doc, String key, boolean all) {
        List updateOperators;
        boolean checkInUO;
        if (BsonUtils.containsUpdateOperators((BsonValue)doc) && (checkInUO = (updateOperators = doc.keySet().stream().filter(k -> k.startsWith(DOLLAR)).collect(Collectors.toList())).stream().anyMatch(uo -> BsonUtils._containsKeys(BsonUtils.unflatten(doc.get(uo)).asDocument(), key, all)))) {
            return true;
        }
        if (key.contains(".")) {
            String first = key.substring(0, key.indexOf("."));
            if (first.length() > 0 && doc.containsKey((Object)first) && doc.get((Object)first).isDocument()) {
                String remaining = key.substring(key.indexOf(".") + 1);
                return BsonUtils._containsKeys(doc.get((Object)first).asDocument(), remaining, all);
            }
            if (first.length() > 0 && doc.containsKey((Object)first) && doc.get((Object)first).isArray()) {
                String remaining = key.substring(key.indexOf(".") + 1);
                return BsonUtils.containsKeys((BsonValue)doc.get((Object)first).asArray(), Sets.newHashSet((Object[])new String[]{remaining}), all);
            }
            return false;
        }
        return key.length() > 0 && doc.containsKey((Object)key);
    }

    public static Document bsonToDocument(BsonDocument bsonDocument) {
        DecoderContext decoderContext = DecoderContext.builder().build();
        return codec.decode((BsonReader)new BsonDocumentReader(bsonDocument), decoderContext);
    }

    public static DocumentBuilder document() {
        return DocumentBuilder.builder();
    }

    public static DocumentBuilder document(BsonDocument doc) {
        return DocumentBuilder.builder(doc);
    }

    public static ArrayBuilder array() {
        return ArrayBuilder.builder();
    }

    public static ArrayBuilder array(BsonArray array) {
        return ArrayBuilder.builder(array);
    }

    public static class ArrayBuilder {
        private final BsonArray array;

        public static ArrayBuilder builder() {
            return new ArrayBuilder();
        }

        public static ArrayBuilder builder(BsonArray array) {
            return new ArrayBuilder(array);
        }

        private ArrayBuilder() {
            this.array = new BsonArray();
        }

        private ArrayBuilder(BsonArray array) {
            this.array = array;
        }

        public String toString() {
            return this.toJson();
        }

        public String toJson() {
            return BsonUtils.toJson((BsonValue)this.get());
        }

        public String toJson(JsonMode jsonMode) {
            return BsonUtils.toJson((BsonValue)this.get(), jsonMode);
        }

        public String toJson(String jsonMode) {
            return BsonUtils.toJson((BsonValue)this.get(), JsonMode.valueOf((String)jsonMode));
        }

        public ArrayBuilder add(BsonValue ... values) {
            Arrays.stream(values).map(value -> value == null ? BsonNull.VALUE : value).forEach(arg_0 -> ((BsonArray)this.array).add(arg_0));
            return this;
        }

        public ArrayBuilder add(String ... values) {
            Arrays.stream(values).map(v -> v == null ? BsonNull.VALUE : new BsonString(v)).forEach(arg_0 -> ((BsonArray)this.array).add(arg_0));
            return this;
        }

        public ArrayBuilder add(Integer ... values) {
            Arrays.stream(values).map(v -> v == null ? BsonNull.VALUE : new BsonInt32(v.intValue())).forEach(arg_0 -> ((BsonArray)this.array).add(arg_0));
            return this;
        }

        public ArrayBuilder add(Long ... values) {
            Arrays.stream(values).map(v -> v == null ? BsonNull.VALUE : new BsonInt64(v.longValue())).forEach(arg_0 -> ((BsonArray)this.array).add(arg_0));
            return this;
        }

        public ArrayBuilder add(Float ... values) {
            Arrays.stream(values).map(v -> v == null ? BsonNull.VALUE : new BsonDouble((double)v.floatValue())).forEach(arg_0 -> ((BsonArray)this.array).add(arg_0));
            return this;
        }

        public ArrayBuilder add(Decimal128 ... values) {
            Arrays.stream(values).map(v -> v == null ? BsonNull.VALUE : new BsonDecimal128(v)).forEach(arg_0 -> ((BsonArray)this.array).add(arg_0));
            return this;
        }

        public ArrayBuilder add(Boolean ... values) {
            Arrays.stream(values).map(v -> v == null ? BsonNull.VALUE : new BsonBoolean(v.booleanValue())).forEach(arg_0 -> ((BsonArray)this.array).add(arg_0));
            return this;
        }

        public ArrayBuilder add(Instant ... values) {
            Arrays.stream(values).map(v -> v == null ? BsonNull.VALUE : new BsonDateTime(v.getEpochSecond() * 1000L)).forEach(arg_0 -> ((BsonArray)this.array).add(arg_0));
            return this;
        }

        public ArrayBuilder add(Date ... values) {
            Arrays.stream(values).map(v -> v == null ? BsonNull.VALUE : new BsonDateTime(v.getTime())).forEach(arg_0 -> ((BsonArray)this.array).add(arg_0));
            return this;
        }

        public ArrayBuilder add(ObjectId ... values) {
            Arrays.stream(values).map(v -> v == null ? BsonNull.VALUE : new BsonObjectId(v)).forEach(arg_0 -> ((BsonArray)this.array).add(arg_0));
            return this;
        }

        public ArrayBuilder addNull() {
            this.array.add((BsonValue)BsonNull.VALUE);
            return this;
        }

        public ArrayBuilder add(DocumentBuilder ... builders) {
            Arrays.stream(builders).filter(b -> b != null).map(DocumentBuilder::get).forEach(arg_0 -> ((BsonArray)this.array).add(arg_0));
            return this;
        }

        public ArrayBuilder add(ArrayBuilder ... builders) {
            Arrays.stream(builders).filter(b -> b != null).map(ArrayBuilder::get).forEach(arg_0 -> ((BsonArray)this.array).add(arg_0));
            return this;
        }

        public BsonArray get() {
            return this.array;
        }
    }

    public static class DocumentBuilder {
        private final BsonDocument doc;

        public static DocumentBuilder builder() {
            return new DocumentBuilder();
        }

        private DocumentBuilder() {
            this.doc = new BsonDocument();
        }

        public static DocumentBuilder builder(BsonDocument doc) {
            return new DocumentBuilder(doc);
        }

        private DocumentBuilder(BsonDocument doc) {
            this.doc = doc;
        }

        public String toString() {
            return this.toJson();
        }

        public String toJson() {
            return BsonUtils.toJson((BsonValue)this.get());
        }

        public String toJson(JsonMode jsonMode) {
            return BsonUtils.toJson((BsonValue)this.get(), jsonMode);
        }

        public String toJson(String jsonMode) {
            return BsonUtils.toJson((BsonValue)this.get(), JsonMode.valueOf((String)jsonMode));
        }

        public DocumentBuilder put(String key, BsonValue value) {
            if (key == null) {
                throw new IllegalArgumentException("argument key cannot be null");
            }
            Objects.nonNull(value);
            if (value == null) {
                this.putNull(key);
            } else {
                this.doc.put(key, value);
            }
            return this;
        }

        public DocumentBuilder putAll(BsonDocument other) {
            if (other != null) {
                this.doc.putAll((Map)other);
            }
            return this;
        }

        public DocumentBuilder put(String key, Integer value) {
            if (key == null) {
                throw new IllegalArgumentException("argument key cannot be null");
            }
            if (value == null) {
                this.putNull(key);
            } else {
                this.doc.put(key, (BsonValue)new BsonInt32(value.intValue()));
            }
            return this;
        }

        public DocumentBuilder put(String key, Long value) {
            if (key == null) {
                throw new IllegalArgumentException("argument key cannot be null");
            }
            if (value == null) {
                this.putNull(key);
            } else {
                this.doc.put(key, (BsonValue)new BsonInt64(value.longValue()));
            }
            return this;
        }

        public DocumentBuilder put(String key, Float value) {
            if (key == null) {
                throw new IllegalArgumentException("argument key cannot be null");
            }
            if (value == null) {
                this.putNull(key);
            } else {
                this.doc.put(key, (BsonValue)new BsonDouble((double)value.floatValue()));
            }
            return this;
        }

        public DocumentBuilder put(String key, Decimal128 value) {
            if (key == null) {
                throw new IllegalArgumentException("argument key cannot be null");
            }
            if (value == null) {
                this.putNull(key);
            } else {
                this.doc.put(key, (BsonValue)new BsonDecimal128(value));
            }
            return this;
        }

        public DocumentBuilder put(String key, Boolean value) {
            if (key == null) {
                throw new IllegalArgumentException("argument key cannot be null");
            }
            if (value == null) {
                this.putNull(key);
            } else {
                this.doc.put(key, (BsonValue)new BsonBoolean(value.booleanValue()));
            }
            return this;
        }

        public DocumentBuilder put(String key, String value) {
            if (key == null) {
                throw new IllegalArgumentException("argument key cannot be null");
            }
            if (value == null) {
                this.putNull(key);
            } else {
                this.doc.put(key, (BsonValue)new BsonString(value));
            }
            return this;
        }

        public DocumentBuilder put(String key, Instant value) {
            if (key == null) {
                throw new IllegalArgumentException("argument key cannot be null");
            }
            if (value == null) {
                this.putNull(key);
            } else {
                this.doc.put(key, (BsonValue)new BsonDateTime(value.getEpochSecond() * 1000L));
            }
            return this;
        }

        public DocumentBuilder put(String key, Date value) {
            if (key == null) {
                throw new IllegalArgumentException("argument key cannot be null");
            }
            if (value == null) {
                this.putNull(key);
            } else {
                this.doc.put(key, (BsonValue)new BsonDateTime(value.getTime()));
            }
            return this;
        }

        public DocumentBuilder put(String key, ObjectId value) {
            if (key == null) {
                throw new IllegalArgumentException("argument key cannot be null");
            }
            if (value == null) {
                this.putNull(key);
            } else {
                this.doc.put(key, (BsonValue)new BsonObjectId(value));
            }
            return this;
        }

        public DocumentBuilder putNull(String key) {
            if (key == null) {
                throw new IllegalArgumentException("argument key cannot be null");
            }
            this.doc.put(key, (BsonValue)BsonNull.VALUE);
            return this;
        }

        public DocumentBuilder put(String key, DocumentBuilder builder) {
            if (key == null) {
                throw new IllegalArgumentException("argument key cannot be null");
            }
            if (builder != null) {
                this.doc.put(key, (BsonValue)builder.get());
            }
            return this;
        }

        public DocumentBuilder put(String key, ArrayBuilder builder) {
            if (key == null) {
                throw new IllegalArgumentException("argument key cannot be null");
            }
            if (builder != null) {
                this.doc.put(key, (BsonValue)builder.get());
            }
            return this;
        }

        public BsonDocument get() {
            return this.doc;
        }
    }
}

