/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.utils;

import io.undertow.connector.PooledByteBuffer;
import io.undertow.server.HttpServerExchange;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnio.Buffers;

public class BuffersUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(BuffersUtils.class);

    public static ByteBuffer toByteBuffer(PooledByteBuffer[] srcs) throws IOException {
        if (srcs == null) {
            return null;
        }
        ByteBuffer dst = ByteBuffer.allocate(0x1000000);
        for (int i = 0; i < srcs.length; ++i) {
            PooledByteBuffer src = srcs[i];
            if (src == null) continue;
            ByteBuffer srcBuffer = src.getBuffer();
            if (srcBuffer.remaining() > dst.remaining()) {
                LOGGER.error("Request content exceeeded {} bytes limit", (Object)0x1000000);
                throw new IOException("Request content exceeeded 16777216 bytes limit");
            }
            if (!srcBuffer.hasRemaining()) continue;
            Buffers.copy((ByteBuffer)dst, (ByteBuffer)srcBuffer);
            srcBuffer.flip();
        }
        return dst.flip();
    }

    public static byte[] toByteArray(PooledByteBuffer[] srcs) throws IOException {
        ByteBuffer content = BuffersUtils.toByteBuffer(srcs);
        byte[] ret = new byte[content.limit()];
        content.get(ret);
        return ret;
    }

    public static String toString(PooledByteBuffer[] srcs, Charset cs) throws IOException {
        return new String(BuffersUtils.toByteArray(srcs), cs);
    }

    public static String toString(byte[] src, Charset cs) throws IOException {
        return new String(src, cs);
    }

    public static int transfer(ByteBuffer src, PooledByteBuffer[] dest, HttpServerExchange exchange) {
        int pidx;
        int copied = 0;
        for (pidx = 0; src.hasRemaining() && pidx < dest.length; ++pidx) {
            ByteBuffer _dest;
            if (dest[pidx] == null) {
                dest[pidx] = exchange.getConnection().getByteBufferPool().allocate();
                _dest = dest[pidx].getBuffer();
            } else {
                _dest = dest[pidx].getBuffer();
                _dest.clear();
            }
            copied += Buffers.copy((ByteBuffer)_dest, (ByteBuffer)src);
            _dest.flip();
        }
        while (pidx < dest.length) {
            dest[pidx] = null;
            ++pidx;
        }
        return copied;
    }

    public static void dump(String msg, PooledByteBuffer[] data) {
        int nbuf = 0;
        for (PooledByteBuffer dest : data) {
            if (dest != null) {
                ByteBuffer src = dest.getBuffer();
                StringBuilder sb = new StringBuilder();
                try {
                    Buffers.dump((ByteBuffer)src, (Appendable)sb, (int)2, (int)2);
                    LOGGER.debug("{} buffer #{}:\n{}", new Object[]{msg, nbuf, sb});
                }
                catch (IOException ie) {
                    LOGGER.debug("failed to dump buffered content", (Throwable)ie);
                }
            }
            ++nbuf;
        }
    }

    public static int append(ByteBuffer src, PooledByteBuffer[] dest, HttpServerExchange exchange) {
        int pidx;
        int copied = 0;
        src.rewind();
        for (pidx = 0; src.hasRemaining() && pidx < dest.length; ++pidx) {
            ByteBuffer _dest;
            if (dest[pidx] == null) {
                dest[pidx] = exchange.getConnection().getByteBufferPool().allocate();
                _dest = dest[pidx].getBuffer();
            } else {
                _dest = dest[pidx].getBuffer();
                _dest.position(_dest.limit());
            }
            copied += Buffers.copy((ByteBuffer)_dest, (ByteBuffer)src);
            _dest.flip();
        }
        while (pidx < dest.length) {
            dest[pidx] = null;
            ++pidx;
        }
        return copied;
    }

    public static int transfer(PooledByteBuffer[] src, PooledByteBuffer[] dest, HttpServerExchange exchange) {
        int idx;
        int copied = 0;
        for (idx = 0; idx < src.length && idx < dest.length; ++idx) {
            if (src[idx] == null) continue;
            if (dest[idx] == null) {
                dest[idx] = exchange.getConnection().getByteBufferPool().allocate();
            }
            ByteBuffer _dest = dest[idx].getBuffer();
            ByteBuffer _src = src[idx].getBuffer();
            copied += Buffers.copy((ByteBuffer)_dest, (ByteBuffer)_src);
            _dest.flip();
            _src.flip();
        }
        while (idx < dest.length) {
            dest[idx] = null;
            ++idx;
        }
        return copied;
    }
}

