/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.utils;

import io.undertow.connector.PooledByteBuffer;
import io.undertow.server.HttpServerExchange;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.xnio.channels.Channels;
import org.xnio.channels.StreamSourceChannel;

public class ChannelReader {
    static final Charset CHARSET = StandardCharsets.UTF_8;
    static final int CAPACITY = 1024;

    public static String readString(HttpServerExchange exchange) throws IOException {
        return new String(ChannelReader.readBytes(exchange), CHARSET);
    }

    public static byte[] readBytes(HttpServerExchange exchange) throws IOException {
        StreamSourceChannel channel = exchange.getRequestChannel();
        if (channel == null) {
            return null;
        }
        try (ByteArrayOutputStream os = new ByteArrayOutputStream(1024);){
            PooledByteBuffer pooledByteBuffer = exchange.getConnection().getByteBufferPool().getArrayBackedPool().allocate();
            ByteBuffer buffer = pooledByteBuffer.getBuffer();
            while (Channels.readBlocking((ReadableByteChannel)channel, (ByteBuffer)buffer) != -1) {
                buffer.flip();
                os.write(buffer.array(), 0, buffer.remaining());
                buffer.clear();
            }
            byte[] byArray = os.toByteArray();
            return byArray;
        }
    }
}

