/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.utils;

import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonValue;
import org.restheart.exchange.MongoRequest;
import org.restheart.utils.BsonUtils;

public class CheckersUtils {
    public static boolean isBulkRequest(MongoRequest request) {
        return request.isBulkDocuments() || request.getContent().isArray();
    }

    public static boolean doesRequestUseUpdateOperators(BsonValue content) {
        if (content.isDocument()) {
            return BsonUtils.containsUpdateOperators((BsonValue)content.asDocument());
        }
        if (content.isArray()) {
            BsonArray objs = content.asArray();
            return objs.stream().allMatch(obj -> {
                if (obj.isDocument()) {
                    return CheckersUtils.doesRequestUseUpdateOperators(obj);
                }
                return true;
            });
        }
        return true;
    }

    public static boolean doesRequestUseDotNotation(BsonValue content) {
        if (content.isDocument()) {
            BsonDocument obj2 = content.asDocument();
            return obj2.keySet().stream().anyMatch(key -> key.contains("."));
        }
        if (content.isArray()) {
            BsonArray objs = content.asArray();
            return objs.stream().anyMatch(obj -> {
                if (obj.isDocument()) {
                    return CheckersUtils.doesRequestUseDotNotation(obj);
                }
                return true;
            });
        }
        return true;
    }
}

