/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bson.BsonArray;
import org.bson.BsonDocument;
import org.bson.BsonNull;
import org.bson.BsonValue;

public final class JsonUnflattener {
    private final BsonValue root;
    private static final Character separator = Character.valueOf('.');
    private static final Character leftBracket = Character.valueOf('[');
    private static final Character rightBracket = Character.valueOf(']');
    private static final String objectComplexKey = Pattern.quote(leftBracket.toString()) + "\\s*\".+?\"\\s*" + Pattern.quote(rightBracket.toString());
    private static final Pattern keyPartPattern = Pattern.compile("^$|[^" + Pattern.quote(separator.toString()) + "]+");

    public static BsonValue unflatten(BsonValue json) {
        return new JsonUnflattener(json).unflatten();
    }

    public JsonUnflattener(BsonValue json) {
        this.root = json;
    }

    public BsonValue unflatten() {
        if (this.root.isArray()) {
            return this.unflattenArray(this.root.asArray());
        }
        if (this.root.isDocument()) {
            return this.unflatten(this.root.asDocument());
        }
        return this.root;
    }

    private BsonDocument unflatten(BsonDocument flattened) {
        if (flattened.keySet().isEmpty()) {
            return new BsonDocument();
        }
        BsonDocument unflattened = new BsonDocument();
        flattened.keySet().stream().filter(key -> keyPartPattern.matcher((CharSequence)key).matches()).forEach(key -> unflattened.asDocument().put(key, flattened.get(key)));
        flattened.keySet().stream().filter(key -> !keyPartPattern.matcher((CharSequence)key).matches()).forEach(key -> {
            BsonDocument currentVal = unflattened;
            String objKey = null;
            Integer aryIdx = null;
            Matcher matcher = keyPartPattern.matcher((CharSequence)key);
            while (matcher.find()) {
                String keyPart = matcher.group();
                boolean firstKey = matcher.start() == 0;
                if (objKey != null ^ aryIdx != null) {
                    if (this.isJsonArray(firstKey, keyPart)) {
                        currentVal = this.findOrCreateJsonArray((BsonValue)currentVal, objKey, aryIdx);
                        objKey = null;
                        aryIdx = this.extractIndex(keyPart);
                    } else {
                        if (flattened.get(key).isArray()) {
                            flattened.put(key, (BsonValue)this.unflattenArray(flattened.get(key).asArray()));
                        }
                        currentVal = this.findOrCreateJsonObject((BsonValue)currentVal, objKey, aryIdx);
                        objKey = this.extractKey(keyPart);
                        aryIdx = null;
                    }
                }
                if (objKey != null || aryIdx != null) continue;
                if (this.isJsonArray(firstKey, keyPart)) {
                    aryIdx = this.extractIndex(keyPart);
                    if (currentVal != null) continue;
                    currentVal = new BsonArray();
                    continue;
                }
                objKey = this.extractKey(keyPart);
                if (currentVal != null) continue;
                currentVal = new BsonDocument();
            }
            this.setUnflattenedValue(flattened, (String)key, (BsonValue)currentVal, objKey, aryIdx);
        });
        return unflattened;
    }

    private BsonArray unflattenArray(BsonArray array) {
        BsonArray unflattenArray = new BsonArray();
        array.forEach(value -> {
            if (value.isArray()) {
                unflattenArray.add((BsonValue)this.unflattenArray(value.asArray()));
            } else if (value.isDocument()) {
                unflattenArray.add(new JsonUnflattener((BsonValue)value.asDocument()).unflatten());
            } else {
                unflattenArray.add(value);
            }
        });
        return unflattenArray;
    }

    private String extractKey(String keyPart) {
        if (keyPart.matches(objectComplexKey)) {
            keyPart = keyPart.replaceAll("^" + Pattern.quote(leftBracket.toString()) + "\\s*\"", "");
            keyPart = keyPart.replaceAll("\"\\s*" + Pattern.quote(rightBracket.toString()) + "$", "");
        }
        return keyPart;
    }

    private Integer extractIndex(String keyPart) {
        return Integer.valueOf(keyPart);
    }

    private boolean isJsonArray(boolean firstPart, String keyPart) {
        return !firstPart && keyPart.matches("\\d+");
    }

    private BsonValue findOrCreateJsonArray(BsonValue currentVal, String objKey, Integer aryIdx) {
        if (objKey != null) {
            BsonDocument currentDocumentVal = currentVal.asDocument();
            if (!currentDocumentVal.containsKey((Object)objKey)) {
                BsonArray ary = new BsonArray();
                currentDocumentVal.put(objKey, (BsonValue)ary);
                return ary;
            }
            BsonValue ret = currentDocumentVal.get((Object)objKey);
            if (!ret.isArray()) {
                throw new IllegalArgumentException("a field key using the dot notation points to a non-array value");
            }
            return ret;
        }
        BsonArray jsonAry = currentVal.asArray();
        if (jsonAry.size() <= aryIdx || jsonAry.get(aryIdx.intValue()).equals(BsonNull.VALUE)) {
            BsonArray ary = new BsonArray();
            this.assureJsonArraySize(jsonAry, aryIdx);
            jsonAry.set(aryIdx.intValue(), (BsonValue)ary);
            return ary;
        }
        return jsonAry.get(aryIdx.intValue());
    }

    private BsonValue findOrCreateJsonObject(BsonValue currentVal, String objKey, Integer aryIdx) {
        if (objKey != null) {
            BsonDocument jsonObj = currentVal.asDocument();
            if (jsonObj.get((Object)objKey) == null) {
                BsonDocument obj = new BsonDocument();
                jsonObj.put(objKey, (BsonValue)obj);
                return obj;
            }
            return jsonObj.get((Object)objKey);
        }
        BsonArray jsonAry = currentVal.asArray();
        if (jsonAry.size() <= aryIdx || jsonAry.get(aryIdx.intValue()).equals(BsonNull.VALUE)) {
            BsonDocument obj = new BsonDocument();
            this.assureJsonArraySize(jsonAry, aryIdx);
            jsonAry.set(aryIdx.intValue(), (BsonValue)obj);
            return obj;
        }
        return jsonAry.get(aryIdx.intValue());
    }

    private void setUnflattenedValue(BsonDocument flattened, String key, BsonValue currentVal, String objKey, Integer aryIdx) {
        BsonValue val = flattened.get((Object)key);
        if (objKey != null) {
            if (val.isArray()) {
                BsonArray jsonArray = new BsonArray();
                val.asArray().forEach(arrayVal -> jsonArray.asArray().add(this.newJsonUnflattener((BsonValue)arrayVal).unflatten()));
                currentVal.asDocument().put(objKey, (BsonValue)jsonArray);
            } else {
                currentVal.asDocument().put(objKey, val);
            }
        } else if (aryIdx != null) {
            this.assureJsonArraySize(currentVal.asArray(), aryIdx);
            currentVal.asArray().set(aryIdx.intValue(), val);
        }
    }

    private JsonUnflattener newJsonUnflattener(BsonValue json) {
        JsonUnflattener jf = new JsonUnflattener(json);
        return jf;
    }

    private void assureJsonArraySize(BsonArray jsonArray, Integer index) {
        while (index >= jsonArray.size()) {
            jsonArray.add((BsonValue)BsonNull.VALUE);
        }
    }

    public int hashCode() {
        int result = 27;
        result = 31 * result + this.root.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JsonUnflattener)) {
            return false;
        }
        return this.root.equals(((JsonUnflattener)o).root);
    }

    public String toString() {
        return "JsonUnflattener{root=" + this.root + "}";
    }
}

