/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.utils;

import org.fusesource.jansi.Ansi;
import org.slf4j.Logger;

public class LogUtils {
    public static void log(Logger logger, Level level, String format, Object ... argArray) {
        if (logger != null && level != null) {
            switch (level) {
                case TRACE: {
                    logger.trace(format, argArray);
                    break;
                }
                case DEBUG: {
                    logger.debug(format, argArray);
                    break;
                }
                case INFO: {
                    logger.info(format, argArray);
                    break;
                }
                case WARN: {
                    logger.warn(format, argArray);
                    break;
                }
                case ERROR: {
                    logger.error(format, argArray);
                }
            }
        }
    }

    public static void boxedError(Logger LOGGER, String ... rows) {
        LogUtils.boxedMessage(LOGGER, Level.ERROR, Ansi.Color.RED, Ansi.Color.GREEN, rows);
    }

    public static void boxedWarn(Logger LOGGER, String ... rows) {
        LogUtils.boxedMessage(LOGGER, Level.WARN, Ansi.Color.RED, Ansi.Color.GREEN, rows);
    }

    public static void boxedInfo(Logger LOGGER, String ... rows) {
        LogUtils.boxedMessage(LOGGER, Level.INFO, Ansi.Color.GREEN, Ansi.Color.GREEN, rows);
    }

    public static void boxedMessage(Logger LOGGER, Level level, Ansi.Color firstRowColor, Ansi.Color rowsColor, String ... rows) {
        Ansi msg = LogUtils.header();
        boolean first = true;
        for (String row : rows) {
            msg.a((Object)LogUtils.sr()).fg(first ? firstRowColor : rowsColor).a(LogUtils.pad(row, 66)).a((Object)LogUtils.er()).reset();
            first = false;
        }
        msg.a((Object)LogUtils.footer());
        LogUtils.log(LOGGER, level, msg.toString(), null);
    }

    private static Ansi sr() {
        return Ansi.ansi().fg(Ansi.Color.GREEN).a("| ").reset();
    }

    private static Ansi er() {
        return Ansi.ansi().fg(Ansi.Color.GREEN).a("|\n").reset();
    }

    private static Ansi header() {
        return Ansi.ansi().a("\n").fg(Ansi.Color.GREEN).a("*-------------------------------------------------------------------*\n|                                                                   |\n").reset();
    }

    private static Ansi footer() {
        return Ansi.ansi().fg(Ansi.Color.GREEN).a("|                                                                   |\n*-------------------------------------------------------------------*\n").reset();
    }

    private static String pad(String s, int length) {
        while (s.length() < length) {
            s = s.concat(" ");
        }
        return s;
    }

    public static enum Level {
        TRACE,
        DEBUG,
        INFO,
        WARN,
        ERROR;

    }
}

