/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.nio.charset.StandardCharsets;

public class Minify {
    private static final int EOF = -1;
    private PushbackInputStream in = null;
    private OutputStream out = null;
    private int currChar;
    private int nextChar;
    private int line;
    private int column;

    public StringBuilder minify(String json) {
        StringBuilder ret = new StringBuilder();
        ByteArrayInputStream ins = new ByteArrayInputStream(json.getBytes(StandardCharsets.UTF_8));
        StringBufferOutputStream bout = new StringBufferOutputStream(ret);
        try {
            this.minify(ins, bout);
        }
        catch (Exception e) {
            return null;
        }
        return ret;
    }

    public void minify(InputStream in, OutputStream out) throws IOException, UnterminatedRegExpLiteralException, UnterminatedCommentException, UnterminatedStringLiteralException {
        this.in = new PushbackInputStream(in);
        this.out = out;
        this.line = 0;
        this.column = 0;
        boolean onFirstChar = true;
        this.currChar = 10;
        this.action(Action.DELETE_NEXT);
        block15: while (this.currChar != -1) {
            switch (this.currChar) {
                case 32: {
                    if (this.isAlphanum(this.nextChar)) {
                        this.action(Action.OUTPUT_CURR);
                        continue block15;
                    }
                    this.action(Action.DELETE_CURR);
                    continue block15;
                }
                case 10: {
                    switch (this.nextChar) {
                        case 40: 
                        case 43: 
                        case 45: 
                        case 91: 
                        case 123: {
                            if (!onFirstChar) {
                                this.action(Action.OUTPUT_CURR);
                                continue block15;
                            }
                            this.action(Action.DELETE_CURR);
                            onFirstChar = false;
                            continue block15;
                        }
                        case 32: {
                            this.action(Action.DELETE_NEXT);
                            continue block15;
                        }
                    }
                    if (this.isAlphanum(this.nextChar)) {
                        if (!onFirstChar) {
                            this.action(Action.OUTPUT_CURR);
                            continue block15;
                        }
                        this.action(Action.DELETE_CURR);
                        onFirstChar = false;
                        continue block15;
                    }
                    this.action(Action.DELETE_CURR);
                    onFirstChar = false;
                    continue block15;
                }
            }
            switch (this.nextChar) {
                case 32: {
                    if (this.isAlphanum(this.currChar)) {
                        this.action(Action.OUTPUT_CURR);
                        continue block15;
                    }
                    this.action(Action.DELETE_NEXT);
                    continue block15;
                }
                case 10: {
                    switch (this.currChar) {
                        case 34: 
                        case 39: 
                        case 41: 
                        case 43: 
                        case 45: 
                        case 93: 
                        case 125: {
                            this.action(Action.OUTPUT_CURR);
                            continue block15;
                        }
                    }
                    if (this.isAlphanum(this.currChar)) {
                        this.action(Action.OUTPUT_CURR);
                        continue block15;
                    }
                    this.action(Action.DELETE_NEXT);
                    continue block15;
                }
            }
            this.action(Action.OUTPUT_CURR);
        }
        out.flush();
    }

    private void action(Action action) throws IOException, UnterminatedRegExpLiteralException, UnterminatedCommentException, UnterminatedStringLiteralException {
        switch (action) {
            case OUTPUT_CURR: {
                this.out.write(this.currChar);
            }
            case DELETE_CURR: {
                this.currChar = this.nextChar;
                if (this.currChar == 39 || this.currChar == 34) {
                    while (true) {
                        this.out.write(this.currChar);
                        this.currChar = this.get();
                        if (this.currChar == this.nextChar) break;
                        if (this.currChar <= 10) {
                            throw new UnterminatedStringLiteralException(this.line, this.column);
                        }
                        if (this.currChar != 92) continue;
                        this.out.write(this.currChar);
                        this.currChar = this.get();
                    }
                }
            }
            case DELETE_NEXT: {
                this.nextChar = this.next();
                if (this.nextChar != 47 || this.currChar != 40 && this.currChar != 44 && this.currChar != 61 && this.currChar != 58) break;
                this.out.write(this.currChar);
                this.out.write(this.nextChar);
                while (true) {
                    this.currChar = this.get();
                    if (this.currChar == 47) break;
                    if (this.currChar == 92) {
                        this.out.write(this.currChar);
                        this.currChar = this.get();
                    } else if (this.currChar <= 10) {
                        throw new UnterminatedRegExpLiteralException(this.line, this.column);
                    }
                    this.out.write(this.currChar);
                }
                this.nextChar = this.next();
            }
        }
    }

    private boolean isAlphanum(int c) {
        return c >= 97 && c <= 122 || c >= 48 && c <= 57 || c >= 65 && c <= 90 || c == 95 || c == 36 || c == 92 || c > 126;
    }

    private int get() throws IOException {
        int c = this.in.read();
        if (c == 10) {
            ++this.line;
            this.column = 0;
        } else {
            ++this.column;
        }
        if (c >= 32 || c == 10 || c == -1) {
            return c;
        }
        if (c == 13) {
            this.column = 0;
            return 10;
        }
        return 32;
    }

    private int peek() throws IOException {
        int lookaheadChar = this.in.read();
        this.in.unread(lookaheadChar);
        return lookaheadChar;
    }

    private int next() throws IOException, UnterminatedCommentException {
        int c = this.get();
        if (c == 47) {
            switch (this.peek()) {
                case 47: {
                    while ((c = this.get()) > 10) {
                    }
                    return c;
                }
                case 42: {
                    this.get();
                    while (true) {
                        switch (this.get()) {
                            case 42: {
                                if (this.peek() != 47) break;
                                this.get();
                                return 32;
                            }
                            case -1: {
                                throw new UnterminatedCommentException(this.line, this.column);
                            }
                        }
                    }
                }
            }
            return c;
        }
        return c;
    }

    private static class StringBufferOutputStream
    extends OutputStream {
        protected StringBuilder sb;

        public StringBufferOutputStream(StringBuilder sb) {
            this.sb = sb;
        }

        @Override
        public void write(int ch) throws IOException {
            this.sb.append((char)ch);
        }
    }

    public static enum Action {
        OUTPUT_CURR,
        DELETE_CURR,
        DELETE_NEXT;

    }

    public static class UnterminatedStringLiteralException
    extends Exception {
        private static final long serialVersionUID = 4074245780159866501L;

        public UnterminatedStringLiteralException(int line, int column) {
            super("Unterminated string literal at line " + line + " and column " + column);
        }
    }

    public static class UnterminatedRegExpLiteralException
    extends Exception {
        private static final long serialVersionUID = -3296214957230186243L;

        public UnterminatedRegExpLiteralException(int line, int column) {
            super("Unterminated regular expression at line " + line + " and column " + column);
        }
    }

    public static class UnterminatedCommentException
    extends Exception {
        private static final long serialVersionUID = -6883462093707704791L;

        public UnterminatedCommentException(int line, int column) {
            super("Unterminated comment at line " + line + " and column " + column);
        }
    }
}

