/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.utils;

import io.undertow.server.HttpServerExchange;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Optional;
import org.restheart.cache.CacheFactory;
import org.restheart.cache.LoadingCache;
import org.restheart.exchange.PipelineInfo;
import org.restheart.exchange.Request;
import org.restheart.exchange.Response;
import org.restheart.plugins.ExchangeTypeResolver;
import org.restheart.plugins.InitPoint;
import org.restheart.plugins.Initializer;
import org.restheart.plugins.InterceptPoint;
import org.restheart.plugins.Interceptor;
import org.restheart.plugins.Plugin;
import org.restheart.plugins.PluginRecord;
import org.restheart.plugins.PluginsRegistry;
import org.restheart.plugins.RegisterPlugin;
import org.restheart.plugins.Service;
import org.restheart.plugins.security.Authorizer;

public class PluginUtils {
    private static LoadingCache<ExchangeTypeResolver, Type> RC = CacheFactory.createHashMapLoadingCache(plugin -> plugin.requestType());
    private static LoadingCache<ExchangeTypeResolver, Type> SC = CacheFactory.createHashMapLoadingCache(plugin -> plugin.responseType());

    public static InterceptPoint interceptPoint(Interceptor interceptor) {
        RegisterPlugin a = interceptor.getClass().getDeclaredAnnotation(RegisterPlugin.class);
        if (a == null) {
            return PluginUtils.findInterceptPointField(interceptor.getClass(), interceptor);
        }
        return a.interceptPoint();
    }

    private static InterceptPoint findInterceptPointField(Class<?> clazz, Object o) {
        try {
            Field field = clazz.getDeclaredField("interceptPoint");
            field.setAccessible(true);
            Object value = field.get(o);
            if (value instanceof InterceptPoint) {
                return (InterceptPoint)((Object)value);
            }
            return null;
        }
        catch (NoSuchFieldException nfe) {
            if (clazz.getSuperclass() != null) {
                return PluginUtils.findInterceptPointField(clazz.getSuperclass(), o);
            }
            return null;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static InitPoint initPoint(Initializer initializer) {
        RegisterPlugin a = initializer.getClass().getDeclaredAnnotation(RegisterPlugin.class);
        if (a == null) {
            return null;
        }
        return a.initPoint();
    }

    public static boolean requiresContent(Interceptor<? extends Request<?>, ? extends Response<?>> interceptor) {
        RegisterPlugin a = interceptor.getClass().getDeclaredAnnotation(RegisterPlugin.class);
        if (a == null) {
            return false;
        }
        return a.requiresContent();
    }

    public static String name(Plugin plugin) {
        RegisterPlugin a = plugin.getClass().getDeclaredAnnotation(RegisterPlugin.class);
        if (a == null) {
            return PluginUtils.findNameField(plugin.getClass(), plugin);
        }
        return a.name();
    }

    private static String findNameField(Class<?> clazz, Object o) {
        try {
            Field field = clazz.getDeclaredField("name");
            field.setAccessible(true);
            Object value = field.get(o);
            if (value instanceof String) {
                return (String)value;
            }
            return null;
        }
        catch (NoSuchFieldException nfe) {
            if (clazz.getSuperclass() != null) {
                return PluginUtils.findNameField(clazz.getSuperclass(), o);
            }
            return null;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static String defaultURI(Service service) {
        RegisterPlugin a = service.getClass().getDeclaredAnnotation(RegisterPlugin.class);
        return a == null ? null : (a.defaultURI() == null || "".equals(a.defaultURI()) ? "/".concat(a.name()) : a.defaultURI());
    }

    public static RegisterPlugin.MATCH_POLICY uriMatchPolicy(Service service) {
        return service.getClass().getDeclaredAnnotation(RegisterPlugin.class).uriMatchPolicy();
    }

    public static <P extends Service> String defaultURI(Class<P> serviceClass) {
        RegisterPlugin a = serviceClass.getDeclaredAnnotation(RegisterPlugin.class);
        return a == null ? null : (a.defaultURI() == null || "".equals(a.defaultURI()) ? "/".concat(a.name()) : a.defaultURI());
    }

    public static <P extends Service> String actualUri(Map<String, Object> conf, Class<P> serviceClass) {
        if (conf != null && conf.get("uri") != null && conf.get("uri") instanceof String) {
            return (String)conf.get("uri");
        }
        return PluginUtils.defaultURI(serviceClass);
    }

    public static InterceptPoint[] dontIntercept(Service service) {
        if (service == null) {
            return null;
        }
        RegisterPlugin a = service.getClass().getDeclaredAnnotation(RegisterPlugin.class);
        if (a == null) {
            return new InterceptPoint[0];
        }
        return a.dontIntercept();
    }

    public static Authorizer.TYPE authorizerType(Authorizer authorizer) {
        if (authorizer == null) {
            return Authorizer.TYPE.ALLOWER;
        }
        RegisterPlugin a = authorizer.getClass().getDeclaredAnnotation(RegisterPlugin.class);
        if (a == null) {
            return Authorizer.TYPE.ALLOWER;
        }
        return a.authorizerType();
    }

    public static boolean blocking(Service<?, ?> service) {
        if (service == null) {
            return true;
        }
        RegisterPlugin a = service.getClass().getDeclaredAnnotation(RegisterPlugin.class);
        if (a == null) {
            return true;
        }
        return a.blocking();
    }

    public static Service<?, ?> handlingService(PluginsRegistry registry, HttpServerExchange exchange) {
        PluginRecord<Service<?, ?>> pr = PluginUtils.handlingServicePluginRecord(registry, exchange);
        return pr == null ? null : pr.getInstance();
    }

    public static PluginRecord<Service<?, ?>> handlingServicePluginRecord(PluginsRegistry registry, HttpServerExchange exchange) {
        Optional<PluginRecord> _s;
        String srvName;
        PipelineInfo pi = Request.getPipelineInfo(exchange);
        if (pi != null && pi.getType() == PipelineInfo.PIPELINE_TYPE.SERVICE && (srvName = pi.getName()) != null && (_s = registry.getServices().stream().filter(s -> srvName.equals(s.getName())).findAny()).isPresent()) {
            return _s.get();
        }
        return null;
    }

    public static InterceptPoint[] dontIntercept(PluginsRegistry registry, HttpServerExchange exchange) {
        Service<?, ?> hs = PluginUtils.handlingService(registry, exchange);
        return hs == null ? new InterceptPoint[]{} : PluginUtils.dontIntercept(hs);
    }

    public static Type cachedRequestType(ExchangeTypeResolver plugin) {
        return RC.getLoading(plugin).get();
    }

    public static Type cachedResponseType(ExchangeTypeResolver plugin) {
        return SC.getLoading(plugin).get();
    }
}

