/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.utils;

import io.undertow.server.HttpServerExchange;
import java.util.Date;
import java.util.TreeMap;
import org.bson.BsonBoolean;
import org.bson.BsonDateTime;
import org.bson.BsonDouble;
import org.bson.BsonInt32;
import org.bson.BsonInt64;
import org.bson.BsonMaxKey;
import org.bson.BsonMinKey;
import org.bson.BsonNull;
import org.bson.BsonNumber;
import org.bson.BsonObjectId;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.types.MaxKey;
import org.bson.types.MinKey;
import org.bson.types.ObjectId;
import org.restheart.exchange.ExchangeKeys;
import org.restheart.exchange.IllegalQueryParamenterException;
import org.restheart.exchange.MongoRequest;
import org.restheart.exchange.MongoResponse;
import org.restheart.exchange.UnsupportedDocumentIdException;
import org.restheart.utils.URLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepresentationUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(RepresentationUtils.class);

    public static TreeMap<String, String> getPaginationLinks(HttpServerExchange exchange, long size) throws IllegalQueryParamenterException {
        MongoRequest request = MongoRequest.of(exchange);
        String requestPath = URLUtils.removeTrailingSlashes(exchange.getRequestPath());
        String queryString = URLUtils.decodeQueryString(exchange.getQueryString());
        int page = request.getPage();
        int pagesize = request.getPagesize();
        long totalPages = 0L;
        if (size >= 0L) {
            float _size = (float)size + 0.0f;
            float _pagesize = (float)pagesize + 0.0f;
            totalPages = Math.max(1L, Math.round(Math.ceil(_size / _pagesize)));
        }
        TreeMap<String, String> links = new TreeMap<String, String>();
        if (queryString == null || queryString.isEmpty()) {
            if (totalPages > 0L && (long)page < totalPages) {
                links.put("next", requestPath + "?page=" + (page + 1) + "&pagesize=" + pagesize);
            }
        } else {
            String queryStringNoPagingProps = URLUtils.decodeQueryString(URLUtils.getQueryStringRemovingParams(exchange, "page", "pagesize"));
            if (queryStringNoPagingProps == null || queryStringNoPagingProps.isEmpty()) {
                links.put("first", requestPath + "?pagesize=" + pagesize);
                links.put("next", requestPath + "?page=" + (page + 1) + "&pagesize=" + pagesize);
                if (totalPages > 0L) {
                    if ((long)page < totalPages) {
                        links.put("last", requestPath + (String)(totalPages != 1L ? "?page=" + totalPages : "") + "&pagesize=" + pagesize);
                        links.put("next", requestPath + "?page=" + (page + 1) + "&pagesize=" + pagesize + "&" + queryStringNoPagingProps);
                    } else {
                        links.put("last", requestPath + (String)(totalPages != 1L ? "?page=" + totalPages : "") + "&pagesize=" + pagesize);
                    }
                }
                if (page > 1) {
                    links.put("previous", requestPath + "?page=" + (page - 1) + "&pagesize=" + pagesize);
                }
            } else {
                links.put("first", requestPath + "?pagesize=" + pagesize + "&" + queryStringNoPagingProps);
                if (totalPages <= 0L) {
                    links.put("next", requestPath + "?page=" + (page + 1) + "&pagesize=" + pagesize + "&" + queryStringNoPagingProps);
                }
                if (totalPages > 0L) {
                    if ((long)page < totalPages) {
                        links.put("last", requestPath + (String)(totalPages != 1L ? "?page=" + totalPages : "") + (totalPages == 1L ? "?pagesize=" : "&pagesize=") + pagesize + "&" + queryStringNoPagingProps);
                        links.put("next", requestPath + "?page=" + (page + 1) + "&pagesize=" + pagesize + "&" + queryStringNoPagingProps);
                    } else {
                        links.put("last", requestPath + (String)(totalPages != 1L ? "?page=" + totalPages : "") + (totalPages == 1L ? "?pagesize=" : "&pagesize=") + pagesize + "&" + queryStringNoPagingProps);
                    }
                }
                if (page > 1) {
                    links.put("previous", requestPath + "?page=" + (page - 1) + "&pagesize=" + pagesize + "&" + queryStringNoPagingProps);
                }
            }
        }
        return links;
    }

    public static String getReferenceLink(MongoResponse response, String parentUrl, BsonValue docId) {
        if (response == null || parentUrl == null) {
            LOGGER.error("error creating URI, null arguments: response = {}, parentUrl = {}, docId = {}", new Object[]{response, parentUrl, docId});
            return "";
        }
        String uri = "#";
        if (docId == null) {
            uri = URLUtils.removeTrailingSlashes(parentUrl).concat("/").concat("_null");
        } else if (docId.isString() && ObjectId.isValid((String)docId.asString().getValue())) {
            uri = URLUtils.removeTrailingSlashes(parentUrl).concat("/").concat(docId.asString().getValue()).concat("?").concat("id_type").concat("=").concat(ExchangeKeys.DOC_ID_TYPE.STRING.name());
        } else if (docId.isString()) {
            uri = URLUtils.removeTrailingSlashes(parentUrl).concat("/").concat(docId.asString().getValue());
        } else if (docId.isObjectId()) {
            uri = URLUtils.removeTrailingSlashes(parentUrl).concat("/").concat(docId.asObjectId().getValue().toString());
        } else if (docId.isBoolean()) {
            uri = URLUtils.removeTrailingSlashes(parentUrl).concat("/").concat("_" + docId.asBoolean().getValue());
        } else if (docId.isInt32()) {
            uri = URLUtils.removeTrailingSlashes(parentUrl).concat("/").concat("" + docId.asInt32().getValue()).concat("?").concat("id_type").concat("=").concat(ExchangeKeys.DOC_ID_TYPE.NUMBER.name());
        } else if (docId.isInt64()) {
            uri = URLUtils.removeTrailingSlashes(parentUrl).concat("/").concat("" + docId.asInt64().getValue()).concat("?").concat("id_type").concat("=").concat(ExchangeKeys.DOC_ID_TYPE.NUMBER.name());
        } else if (docId.isDouble()) {
            uri = URLUtils.removeTrailingSlashes(parentUrl).concat("/").concat("" + docId.asDouble().getValue()).concat("?").concat("id_type").concat("=").concat(ExchangeKeys.DOC_ID_TYPE.NUMBER.name());
        } else if (docId.isNull()) {
            uri = URLUtils.removeTrailingSlashes(parentUrl).concat("/_null");
        } else if (docId instanceof BsonMaxKey) {
            uri = URLUtils.removeTrailingSlashes(parentUrl).concat("/_MaxKey");
        } else if (docId instanceof BsonMinKey) {
            uri = URLUtils.removeTrailingSlashes(parentUrl).concat("/_MinKey");
        } else if (docId.isDateTime()) {
            uri = URLUtils.removeTrailingSlashes(parentUrl).concat("/").concat("" + docId.asDateTime().getValue()).concat("?").concat("id_type").concat("=").concat(ExchangeKeys.DOC_ID_TYPE.DATE.name());
        } else {
            String _id;
            try {
                _id = URLUtils.getIdString(docId);
            }
            catch (UnsupportedDocumentIdException uie) {
                _id = docId.toString();
            }
            response.addWarning("resource with _id: " + _id + " does not have an URI since the _id is of type " + docId.getClass().getSimpleName());
        }
        return uri;
    }

    public static String getReferenceLink(String parentUrl, Object docId) {
        if (parentUrl == null) {
            LOGGER.error("error creating URI, null arguments: parentUrl = {}, docId = {}", (Object)parentUrl, docId);
            return "";
        }
        String uri = docId == null ? URLUtils.removeTrailingSlashes(parentUrl).concat("/").concat("_null") : (docId instanceof String && ObjectId.isValid((String)((String)docId)) ? URLUtils.removeTrailingSlashes(parentUrl).concat("/").concat(docId.toString()).concat("?").concat("id_type").concat("=").concat(ExchangeKeys.DOC_ID_TYPE.STRING.name()) : (docId instanceof String || docId instanceof ObjectId ? URLUtils.removeTrailingSlashes(parentUrl).concat("/").concat(docId.toString()) : (docId instanceof BsonObjectId ? URLUtils.removeTrailingSlashes(parentUrl).concat("/").concat(((BsonObjectId)docId).getValue().toString()) : (docId instanceof BsonString ? URLUtils.removeTrailingSlashes(parentUrl).concat("/").concat(((BsonString)docId).getValue()) : (docId instanceof BsonBoolean ? URLUtils.removeTrailingSlashes(parentUrl).concat("/").concat("_" + ((BsonBoolean)docId).getValue()) : (docId instanceof BsonInt32 ? URLUtils.removeTrailingSlashes(parentUrl).concat("/").concat("" + ((BsonNumber)docId).asInt32().getValue()).concat("?").concat("id_type").concat("=").concat(ExchangeKeys.DOC_ID_TYPE.NUMBER.name()) : (docId instanceof BsonInt64 ? URLUtils.removeTrailingSlashes(parentUrl).concat("/").concat("" + ((BsonNumber)docId).asInt64().getValue()).concat("?").concat("id_type").concat("=").concat(ExchangeKeys.DOC_ID_TYPE.NUMBER.name()) : (docId instanceof BsonDouble ? URLUtils.removeTrailingSlashes(parentUrl).concat("/").concat("" + ((BsonDouble)docId).asDouble().getValue()).concat("?").concat("id_type").concat("=").concat(ExchangeKeys.DOC_ID_TYPE.NUMBER.name()) : (docId instanceof BsonNull ? URLUtils.removeTrailingSlashes(parentUrl).concat("/_null") : (docId instanceof BsonMaxKey ? URLUtils.removeTrailingSlashes(parentUrl).concat("/_MaxKey") : (docId instanceof BsonMinKey ? URLUtils.removeTrailingSlashes(parentUrl).concat("/_MinKey") : (docId instanceof BsonDateTime ? URLUtils.removeTrailingSlashes(parentUrl).concat("/").concat("" + ((BsonDateTime)docId).getValue()).concat("?").concat("id_type").concat("=").concat(ExchangeKeys.DOC_ID_TYPE.DATE.name()) : (docId instanceof Integer ? URLUtils.removeTrailingSlashes(parentUrl).concat("/").concat(docId.toString()).concat("?").concat("id_type").concat("=").concat(ExchangeKeys.DOC_ID_TYPE.NUMBER.name()) : (docId instanceof Long ? URLUtils.removeTrailingSlashes(parentUrl).concat("/").concat(docId.toString()).concat("?").concat("id_type").concat("=").concat(ExchangeKeys.DOC_ID_TYPE.NUMBER.name()) : (docId instanceof Float ? URLUtils.removeTrailingSlashes(parentUrl).concat("/").concat(docId.toString()).concat("?").concat("id_type").concat("=").concat(ExchangeKeys.DOC_ID_TYPE.NUMBER.name()) : (docId instanceof Double ? URLUtils.removeTrailingSlashes(parentUrl).concat("/").concat(docId.toString()).concat("?").concat("id_type").concat("=").concat(ExchangeKeys.DOC_ID_TYPE.NUMBER.name()) : (docId instanceof MinKey ? URLUtils.removeTrailingSlashes(parentUrl).concat("/").concat("_MinKey") : (docId instanceof MaxKey ? URLUtils.removeTrailingSlashes(parentUrl).concat("/").concat("_MaxKey") : (docId instanceof Date ? URLUtils.removeTrailingSlashes(parentUrl).concat("/").concat("" + ((Date)docId).getTime()).concat("?").concat("id_type").concat("=").concat(ExchangeKeys.DOC_ID_TYPE.DATE.name()) : (docId instanceof Boolean ? URLUtils.removeTrailingSlashes(parentUrl).concat("/").concat("_" + (Boolean)docId) : URLUtils.removeTrailingSlashes(parentUrl).concat("/").concat("_? (unsuppored _id type)")))))))))))))))))))));
        return uri;
    }
}

