/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.utils;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourcesExtractor {
    private static final Logger LOG = LoggerFactory.getLogger(ResourcesExtractor.class);

    public static boolean isResourceInJar(Class clazz, String resourcePath) throws URISyntaxException {
        return ResourcesExtractor.getClassLoader(clazz).getResource(resourcePath).toURI().toString().startsWith("jar:");
    }

    public static void deleteTempDir(Class clazz, String resourcePath, File tempDir) throws URISyntaxException, IOException {
        if (ResourcesExtractor.isResourceInJar(clazz, resourcePath) && tempDir.exists()) {
            ResourcesExtractor.delete(tempDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File extract(Class clazz, final String resourcePath) throws IOException, URISyntaxException, IllegalStateException {
        if (ResourcesExtractor.getClassLoader(clazz).getResource(resourcePath) == null) {
            LOG.warn("no resource to extract from path  {}", (Object)resourcePath);
            throw new IllegalStateException("no resource to extract from path " + resourcePath);
        }
        URI uri = ResourcesExtractor.getClassLoader(clazz).getResource(resourcePath).toURI();
        if (ResourcesExtractor.isResourceInJar(clazz, resourcePath)) {
            File ret = null;
            try (FileSystem fs = null;){
                final Path destinationDir = Files.createTempDirectory("restheart-", new FileAttribute[0]);
                ret = destinationDir.toFile();
                HashMap<String, String> env = new HashMap<String, String>();
                env.put("create", "false");
                fs = FileSystems.newFileSystem(uri, env);
                final Path sourceDir = fs.getPath(resourcePath, new String[0]);
                Files.walkFileTree(sourceDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        return this.copy(file);
                    }

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        return this.copy(dir);
                    }

                    private FileVisitResult copy(Path fileOrDir) throws IOException {
                        if (fileOrDir.equals(sourceDir)) {
                            return FileVisitResult.CONTINUE;
                        }
                        Path destination = Paths.get(destinationDir.toString(), fileOrDir.toString().replaceAll(resourcePath + "/", ""));
                        Files.copy(fileOrDir, destination, StandardCopyOption.REPLACE_EXISTING);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            return ret;
        }
        return new File(uri);
    }

    private static void delete(File file) throws IOException {
        if (file.isDirectory()) {
            if (file.list().length == 0) {
                boolean deleted = file.delete();
                if (!deleted) {
                    LOG.warn("failted to delete directory " + file.getPath());
                }
            } else {
                boolean deleted;
                String[] files;
                for (String temp : files = file.list()) {
                    File fileDelete = new File(file, temp);
                    ResourcesExtractor.delete(fileDelete);
                }
                if (file.list().length == 0 && !(deleted = file.delete())) {
                    LOG.warn("failted to delete file " + file.getPath());
                }
            }
        } else {
            boolean deleted = file.delete();
            if (!deleted) {
                LOG.warn("failted to delete file " + file.getPath());
            }
        }
    }

    private static ClassLoader getClassLoader(Class clazz) {
        return clazz.getClassLoader();
    }
}

