/*
 * Decompiled with CFR 0.152.
 */
package org.restheart.utils;

import io.undertow.server.HttpServerExchange;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Deque;
import org.bson.BsonValue;
import org.restheart.exchange.UnsupportedDocumentIdException;
import org.restheart.utils.BsonUtils;

public class URLUtils {
    public static String removeTrailingSlashes(String s) {
        if (s == null) {
            return null;
        }
        if ((s = s.strip()).length() < 2) {
            return s;
        }
        if (s.charAt(s.length() - 1) == '/') {
            return URLUtils.removeTrailingSlashes(s.substring(0, s.length() - 1));
        }
        return s;
    }

    public static String decodeQueryString(String qs) {
        try {
            return URLDecoder.decode(qs.replace("+", "%2B"), "UTF-8").replace("%2B", "+");
        }
        catch (UnsupportedEncodingException ex) {
            return null;
        }
    }

    public static String getParentPath(String path) {
        if (path == null || path.isEmpty() || path.equals("/")) {
            return path;
        }
        int lastSlashPos = path.lastIndexOf(47);
        if (lastSlashPos > 0) {
            return path.substring(0, lastSlashPos);
        }
        if (lastSlashPos == 0) {
            return "/";
        }
        return "";
    }

    public static String getPrefixUrl(HttpServerExchange exchange) {
        return exchange.getRequestURL().replaceAll(exchange.getRelativePath(), "");
    }

    public static String getQueryStringRemovingParams(HttpServerExchange exchange, String ... paramsToRemove) {
        String ret = exchange.getQueryString();
        if (ret == null || ret.isEmpty() || paramsToRemove == null) {
            return ret;
        }
        for (String key : paramsToRemove) {
            Deque values = (Deque)exchange.getQueryParameters().get(key);
            if (values == null) continue;
            for (String value : values) {
                ret = ret.replaceAll(key + "=" + value + "&", "");
                ret = ret.replaceAll(key + "=" + value + "$", "");
            }
        }
        return ret;
    }

    public static String getIdString(BsonValue id) throws UnsupportedDocumentIdException {
        if (id == null) {
            return null;
        }
        if (id.isString()) {
            return "'" + id.asString().getValue() + "'";
        }
        return BsonUtils.minify(BsonUtils.toJson(id).replace("\"", "'")).toString();
    }
}

