/*
 * Decompiled with CFR 0.152.
 */
package org.resthub.common.model;

import org.springframework.util.ObjectUtils;

public class RestError {
    private final String status;
    private final int code;
    private final String message;
    private final String developerMessage;
    private final String moreInfoUrl;
    private final Throwable throwable;

    public RestError(String status, int code, String message, String developerMessage, String moreInfoUrl, Throwable throwable) {
        if (status == null) {
            throw new NullPointerException("HttpStatus argument cannot be null.");
        }
        this.status = status;
        this.code = code;
        this.message = message;
        this.developerMessage = developerMessage;
        this.moreInfoUrl = moreInfoUrl;
        this.throwable = throwable;
    }

    public String getStatus() {
        return this.status;
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String getDeveloperMessage() {
        return this.developerMessage;
    }

    public String getMoreInfoUrl() {
        return this.moreInfoUrl;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof RestError) {
            RestError re = (RestError)o;
            return ObjectUtils.nullSafeEquals((Object)this.getStatus(), (Object)re.getStatus()) && this.getCode() == re.getCode() && ObjectUtils.nullSafeEquals((Object)this.getMessage(), (Object)re.getMessage()) && ObjectUtils.nullSafeEquals((Object)this.getDeveloperMessage(), (Object)re.getDeveloperMessage()) && ObjectUtils.nullSafeEquals((Object)this.getMoreInfoUrl(), (Object)re.getMoreInfoUrl()) && ObjectUtils.nullSafeEquals((Object)this.getThrowable(), (Object)re.getThrowable());
        }
        return false;
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode((Object[])new Object[]{this.getStatus(), this.getCode(), this.getMessage(), this.getDeveloperMessage(), this.getMoreInfoUrl(), this.getThrowable()});
    }

    public String toString() {
        return this.getCode() + " (" + this.getStatus() + " )";
    }

    public static class Builder {
        private String status;
        private int code;
        private String message;
        private String developerMessage;
        private String moreInfoUrl;
        private Throwable throwable;

        public Builder setStatus(String status) {
            this.status = status;
            return this;
        }

        public Builder setCode(int code) {
            this.code = code;
            return this;
        }

        public Builder setMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder setDeveloperMessage(String developerMessage) {
            this.developerMessage = developerMessage;
            return this;
        }

        public Builder setMoreInfoUrl(String moreInfoUrl) {
            this.moreInfoUrl = moreInfoUrl;
            return this;
        }

        public Builder setThrowable(Throwable throwable) {
            this.throwable = throwable;
            return this;
        }

        public RestError build() {
            if (this.status == null) {
                this.status = "Internal Server Error";
            }
            return new RestError(this.status, this.code, this.message, this.developerMessage, this.moreInfoUrl, this.throwable);
        }
    }
}

