/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.standalone;

import gnu.getopt.Getopt;
import gnu.getopt.LongOpt;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.jboss.dmr.ModelNode;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleSpec;
import org.revapi.API;
import org.revapi.AnalysisContext;
import org.revapi.AnalysisResult;
import org.revapi.PipelineConfiguration;
import org.revapi.Revapi;
import org.revapi.maven.utils.ArtifactResolver;
import org.revapi.simple.FileArchive;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pw.krejci.modules.maven.MavenBootstrap;
import pw.krejci.modules.maven.ModuleSpecController;
import pw.krejci.modules.maven.ProjectModule;

public final class Main {
    private static final Logger LOG = LoggerFactory.getLogger(Main.class);

    private static void usage(@Nullable String progName) {
        if (progName == null) {
            progName = "revapi.(sh|bat)";
        }
        String pad = "";
        for (int i = 0; i < progName.length(); ++i) {
            pad = pad + " ";
        }
        System.out.println(progName + " [-u|-h] -e <GAV>[,<GAV>]* -o <FILE>[,<FILE>]* -n <FILE>[,<FILE>]* [-s <FILE>[,<FILE>]*] [-t <FILE>[,<FILE>]*] [-D<CONFIG_OPTION>=<VALUE>]* [-c <FILE>[,<FILE>]*] [-r <DIR>]");
        System.out.println();
        System.out.println(pad + " -u");
        System.out.println(pad + " -h");
        System.out.println(pad + " --usage");
        System.out.println(pad + " --help");
        System.out.println(pad + "     Prints this message and exits.");
        System.out.println(pad + " -e");
        System.out.println(pad + " --extensions=<GAV>[,<GAV>]*");
        System.out.println(pad + "     Comma-separated list of maven GAVs of revapi extensions.");
        System.out.println(pad + " -o");
        System.out.println(pad + " --old=<FILE>[,<FILE>]*");
        System.out.println(pad + "    Comma-separated list of files of the old version of API");
        System.out.println(pad + " -a");
        System.out.println(pad + " --old-gavs=<FILE>[,<FILE>]*");
        System.out.println(pad + "    Comma-separated list of GAVs of the old version of API");
        System.out.println(pad + " -s");
        System.out.println(pad + " --old-supplementary=<FILE>[,<FILE>]*");
        System.out.println(pad + "    Comma-separated list of files that supplement the old version of API");
        System.out.println(pad + " -n");
        System.out.println(pad + " --new=<FILE>[,<FILE>]*");
        System.out.println(pad + "    Comma-separated list of files of the new version of API");
        System.out.println(pad + " -b");
        System.out.println(pad + " --new-gavs=<FILE>[,<FILE>]*");
        System.out.println(pad + "    Comma-separated list of GAVs of the new version of API");
        System.out.println(pad + " -t");
        System.out.println(pad + " --new-supplementary=<FILE>[,<FILE>]*");
        System.out.println(pad + "    Comma-separated list of files that supplement the new version of API");
        System.out.println(pad + " -D");
        System.out.println(pad + "    A key-value pair representing a single configuration option of revapi or one of the loaded extensions");
        System.out.println(pad + " -c");
        System.out.println(pad + " --config-files=<FILE>[,<FILE>]*");
        System.out.println(pad + "    Comma-separated list of configuration files in JSON format.");
        System.out.println(pad + " -d");
        System.out.println(pad + " --cache-dir=<DIR>");
        System.out.println(pad + "    The location of local cache of extensions to use to locate artifacts. Defaults to 'extensions' directory under revapi installation dir.");
        System.out.println(pad + " -r");
        System.out.println(pad + " --remote-repositories=<URL>[,<URL>]*");
        System.out.println(pad + "    The url of the remote Maven repository to use for artifact resolution. Defaults to Maven Central (http://repo.maven.apache.org/maven2/).");
        System.out.println();
        System.out.println("You can specify the old API either using -o and -s where you specify the filesystem paths to the archives and supplementary archives respectively or you can use -a to specify the GAVs of the old API archives and the supplementary archives (i.e. their transitive dependencies) will be determined automatically using Maven. But you cannot do both obviously.");
        System.out.println();
        System.out.println("Of course you can do the same for the new version of the API by using -n and -t for file paths or -b for GAVs.");
    }

    public static void main(String[] args) throws Exception {
        ArchivesAndSupplementaryArchives res;
        int c;
        if (args.length < 2) {
            Main.usage(null);
            System.exit(1);
        }
        String scriptFileName = args[0];
        String baseDir = args[1];
        String[] realArgs = new String[args.length - 2];
        System.arraycopy(args, 2, realArgs, 0, realArgs.length);
        String[] extensionGAVs = null;
        String[] oldArchivePaths = null;
        String[] oldGavs = null;
        String[] newArchivePaths = null;
        String[] newGavs = null;
        String[] oldSupplementaryArchivePaths = null;
        String[] newSupplementaryArchivePaths = null;
        HashMap<String, String> additionalConfigOptions = new HashMap<String, String>();
        String[] configFiles = null;
        File cacheDir = new File(baseDir, "cache");
        String[] remoteRepositoryUrls = null;
        LongOpt[] longOpts = new LongOpt[]{new LongOpt("usage", 0, null, 117), new LongOpt("help", 0, null, 104), new LongOpt("extensions", 1, null, 101), new LongOpt("old", 1, null, 111), new LongOpt("new", 1, null, 110), new LongOpt("old-supplementary", 1, null, 115), new LongOpt("new-supplementary", 1, null, 116), new LongOpt("D", 1, null, 68), new LongOpt("config-files", 1, null, 99), new LongOpt("cache-dir", 1, null, 100), new LongOpt("old-gavs", 1, null, 97), new LongOpt("new-gavs", 1, null, 98), new LongOpt("remote-repositories", 1, null, 114)};
        Getopt opts = new Getopt(scriptFileName, realArgs, "uhe:o:n:s:t:D:c:d:a:b:r:", longOpts);
        block18: while ((c = opts.getopt()) != -1) {
            switch (c) {
                case 104: 
                case 117: {
                    Main.usage(scriptFileName);
                    System.exit(0);
                }
                case 101: {
                    extensionGAVs = opts.getOptarg().split(",");
                    continue block18;
                }
                case 111: {
                    oldArchivePaths = opts.getOptarg().split(",");
                    continue block18;
                }
                case 110: {
                    newArchivePaths = opts.getOptarg().split(",");
                    continue block18;
                }
                case 115: {
                    oldSupplementaryArchivePaths = opts.getOptarg().split(",");
                    continue block18;
                }
                case 116: {
                    newSupplementaryArchivePaths = opts.getOptarg().split(",");
                    continue block18;
                }
                case 99: {
                    configFiles = opts.getOptarg().split(",");
                    continue block18;
                }
                case 68: {
                    String[] keyValue = opts.getOptarg().split("=");
                    additionalConfigOptions.put(keyValue[0], keyValue.length > 1 ? keyValue[1] : null);
                    continue block18;
                }
                case 100: {
                    cacheDir = new File(opts.getOptarg());
                    continue block18;
                }
                case 97: {
                    oldGavs = opts.getOptarg().split(",");
                    continue block18;
                }
                case 98: {
                    newGavs = opts.getOptarg().split(",");
                    continue block18;
                }
                case 114: {
                    remoteRepositoryUrls = opts.getOptarg().split(",");
                    continue block18;
                }
                case 58: {
                    System.err.println("Argument required for option " + (char)opts.getOptopt());
                    continue block18;
                }
                case 63: {
                    System.err.println("The option '" + (char)opts.getOptopt() + "' is not valid");
                    System.exit(1);
                    continue block18;
                }
            }
            System.err.println("getopt() returned " + c);
            System.exit(1);
        }
        if (extensionGAVs == null || oldArchivePaths == null && oldGavs == null || newArchivePaths == null && newGavs == null) {
            Main.usage(scriptFileName);
            System.exit(1);
        }
        List<RemoteRepository> remoteRepositories = Collections.unmodifiableList(Main.remoteRepositories(remoteRepositoryUrls == null ? new String[]{} : remoteRepositoryUrls));
        List<FileArchive> oldArchives = null;
        List<FileArchive> newArchives = null;
        List<FileArchive> oldSupplementaryArchives = null;
        List<FileArchive> newSupplementaryArchives = null;
        LOG.info("Downloading checked archives");
        if (oldArchivePaths == null) {
            res = Main.convertGavs(oldGavs, "Old API Maven artifact", cacheDir, remoteRepositories);
            oldArchives = res.archives;
            oldSupplementaryArchives = res.supplementaryArchives;
        } else {
            oldArchives = Main.convertPaths(oldArchivePaths, "Old API files");
            List<Object> list = oldSupplementaryArchives = oldSupplementaryArchivePaths == null ? Collections.emptyList() : Main.convertPaths(oldSupplementaryArchivePaths, "Old API supplementary files");
        }
        if (newArchivePaths == null) {
            res = Main.convertGavs(newGavs, "New API Maven artifact", cacheDir, remoteRepositories);
            newArchives = res.archives;
            newSupplementaryArchives = res.supplementaryArchives;
        } else {
            newArchives = Main.convertPaths(newArchivePaths, "New API files");
            newSupplementaryArchives = newSupplementaryArchivePaths == null ? Collections.emptyList() : Main.convertPaths(newSupplementaryArchivePaths, "New API supplementary files");
        }
        try {
            Main.run(cacheDir, extensionGAVs, oldArchives, oldSupplementaryArchives, newArchives, newSupplementaryArchives, configFiles, additionalConfigOptions, remoteRepositories);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void run(File cacheDir, String[] extensionGAVs, List<FileArchive> oldArchives, List<FileArchive> oldSupplementaryArchives, List<FileArchive> newArchives, List<FileArchive> newSupplementaryArchives, String[] configFiles, Map<String, String> additionalConfig, List<RemoteRepository> remoteRepositories) throws Exception {
        ProjectModule.Builder bld = ProjectModule.build();
        bld.localRepository(cacheDir);
        remoteRepositories.forEach(arg_0 -> ((ProjectModule.Builder)bld).addRemoteRepository(arg_0));
        if (extensionGAVs != null) {
            for (String gav : extensionGAVs) {
                bld.addDependency(gav);
            }
        }
        Properties libraryVersionsProps = new Properties();
        libraryVersionsProps.load(Main.class.getResourceAsStream("/library.versions"));
        final Set globalArtifacts = libraryVersionsProps.stringPropertyNames().stream().map(p -> {
            String gav = p + ':' + libraryVersionsProps.get(p);
            return new DefaultArtifact(gav);
        }).collect(Collectors.toSet());
        bld.moduleSpecController(new ModuleSpecController(){
            private boolean override;
            private String currentModuleName;

            public void start(String moduleName) {
                this.currentModuleName = moduleName;
            }

            public DependencySpec modifyDependency(String dependencyName, DependencySpec original) {
                boolean overrideThis = false;
                DefaultArtifact a = new DefaultArtifact(dependencyName);
                for (Artifact ga : globalArtifacts) {
                    if (!ga.getGroupId().equals(a.getGroupId()) || !ga.getArtifactId().equals(a.getArtifactId()) || ga.getVersion().equals(a.getVersion())) continue;
                    LOG.warn("Detected version conflict in dependencies of extension " + this.currentModuleName + ". The extension depends on " + a + " while the CLI has " + ga + " on global classpath. This will likely cause problems.");
                }
                this.override = this.override || overrideThis;
                return overrideThis ? null : original;
            }

            public void modify(ModuleSpec.Builder bld) {
                if (this.override) {
                    HashSet<String> revapiPaths = new HashSet<String>(Arrays.asList("org/revapi", "org/revapi/configuration", "org/revapi/query", "org/revapi/simple"));
                    bld.addDependency(DependencySpec.createSystemDependencySpec(revapiPaths));
                    this.override = false;
                }
            }

            public void end(String moduleName) {
                this.currentModuleName = null;
            }
        });
        LOG.info("Downloading extensions");
        Module project = bld.create();
        Revapi revapi = new Revapi(PipelineConfiguration.builder().withAllExtensionsFrom((ClassLoader)project.getClassLoader()).withAllExtensionsFromThreadContextClassLoader().build());
        AnalysisContext.Builder ctxBld = AnalysisContext.builder((Revapi)revapi).withOldAPI(API.of(oldArchives).supportedBy(oldSupplementaryArchives).build()).withNewAPI(API.of(newArchives).supportedBy(newSupplementaryArchives).build());
        if (configFiles != null) {
            for (String cf : configFiles) {
                File f = new File(cf);
                Main.checkCanRead(f, "Configuration file");
                try (FileInputStream is = new FileInputStream(f);){
                    ctxBld.mergeConfigurationFromJSONStream((InputStream)is);
                }
            }
        }
        for (Map.Entry entry : additionalConfig.entrySet()) {
            String[] keyPath = ((String)entry.getKey()).split("\\.");
            ModelNode additionalNode = new ModelNode();
            ModelNode key = additionalNode.get(keyPath);
            String value = (String)entry.getValue();
            if (value.startsWith("[") && value.endsWith("]")) {
                String[] values;
                for (String v : values = value.substring(1, value.length() - 1).split("\\s*,\\s*")) {
                    key.add(v);
                }
            } else {
                key.set(value);
            }
            ctxBld.mergeConfiguration(additionalNode);
        }
        LOG.info("Starting analysis");
        long time = System.currentTimeMillis();
        try (AnalysisResult result = revapi.analyze(ctxBld.build());){
            if (!result.isSuccess()) {
                throw result.getFailure();
            }
        }
        finally {
            LOG.info("Analysis took " + (System.currentTimeMillis() - time) + "ms.");
        }
    }

    private static List<FileArchive> convertPaths(String[] paths, String errorMessagePrefix) {
        ArrayList<FileArchive> archives = new ArrayList<FileArchive>(paths.length);
        for (String path : paths) {
            File f = new File(path);
            Main.checkCanRead(f, errorMessagePrefix);
            archives.add(new FileArchive(f));
        }
        return archives;
    }

    private static ArchivesAndSupplementaryArchives convertGavs(String[] gavs, String errorMessagePrefix, File localRepo, List<RemoteRepository> remoteRepositories) {
        RepositorySystem repositorySystem = MavenBootstrap.newRepositorySystem();
        DefaultRepositorySystemSession session = MavenBootstrap.newRepositorySystemSession((RepositorySystem)repositorySystem, (LocalRepository)new LocalRepository(localRepo));
        session.setDependencySelector(ArtifactResolver.getRevapiDependencySelector((boolean)true, (boolean)false));
        session.setDependencyTraverser(ArtifactResolver.getRevapiDependencyTraverser((boolean)true, (boolean)false));
        ArtifactResolver resolver = new ArtifactResolver(repositorySystem, (RepositorySystemSession)session, remoteRepositories);
        ArrayList<FileArchive> archives = new ArrayList<FileArchive>();
        ArrayList<FileArchive> supplementaryArchives = new ArrayList<FileArchive>();
        for (String gav : gavs) {
            try {
                archives.add(new FileArchive(resolver.resolveArtifact(gav).getFile()));
                ArtifactResolver.CollectionResult res = resolver.collectTransitiveDeps(new String[]{gav});
                res.getResolvedArtifacts().forEach(a -> supplementaryArchives.add(new FileArchive(a.getFile())));
                if (res.getFailures().isEmpty()) continue;
                LOG.warn("Failed to resolve some transitive dependencies: " + res.getFailures().toString());
            }
            catch (RepositoryException e) {
                throw new IllegalArgumentException(errorMessagePrefix + " " + e.getMessage());
            }
        }
        return new ArchivesAndSupplementaryArchives(archives, supplementaryArchives);
    }

    private static List<RemoteRepository> remoteRepositories(String[] customRepositoryUrls) {
        ArrayList<RemoteRepository> remoteRepositories = new ArrayList<RemoteRepository>();
        for (int i = 0; i < customRepositoryUrls.length; ++i) {
            String repositoryId = "custom-remote-repository-" + i;
            remoteRepositories.add(new RemoteRepository.Builder(repositoryId, "default", customRepositoryUrls[i]).build());
        }
        if (remoteRepositories.isEmpty()) {
            remoteRepositories.add(new RemoteRepository.Builder("maven-central", "default", "https://repo.maven.apache.org/maven2/").build());
        }
        File localMaven = new File(new File(System.getProperties().getProperty("user.home"), ".m2"), "repository");
        RemoteRepository mavenCache = new RemoteRepository.Builder("~/.m2/repository", "default", localMaven.toURI().toString()).setPolicy(new RepositoryPolicy(true, "never", "ignore")).build();
        remoteRepositories.add(mavenCache);
        return remoteRepositories;
    }

    private static void checkCanRead(File f, String errorMessagePrefix) throws IllegalArgumentException {
        if (!f.exists()) {
            throw new IllegalArgumentException(errorMessagePrefix + " '" + f.getAbsolutePath() + "' does not exist.");
        }
        if (!f.isFile() || !f.canRead()) {
            throw new IllegalArgumentException(errorMessagePrefix + " '" + f.getAbsolutePath() + "' is not a file or cannot be read.");
        }
    }

    private static class ArchivesAndSupplementaryArchives {
        final List<FileArchive> archives;
        final List<FileArchive> supplementaryArchives;

        public ArchivesAndSupplementaryArchives(List<FileArchive> archives, List<FileArchive> supplementaryArchives) {
            this.archives = archives;
            this.supplementaryArchives = supplementaryArchives;
        }
    }
}

