/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.basic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.revapi.AnalysisContext;
import org.revapi.Difference;
import org.revapi.DifferenceTransform;
import org.revapi.Element;
import org.revapi.basic.DifferenceMatchRecipe;

public abstract class AbstractDifferenceReferringTransform
implements DifferenceTransform<Element> {
    private final String extensionId;
    private Collection<DifferenceMatchRecipe> configuredRecipes;
    private Pattern[] codes;
    protected AnalysisContext analysisContext;

    protected AbstractDifferenceReferringTransform(@Nonnull String extensionId) {
        this.extensionId = extensionId;
    }

    @Nullable
    public String getExtensionId() {
        return this.extensionId;
    }

    @Nonnull
    public Pattern[] getDifferenceCodePatterns() {
        return this.codes;
    }

    protected ModelNode getRecipesConfigurationAndInitialize() {
        return this.analysisContext.getConfiguration();
    }

    protected abstract DifferenceMatchRecipe newRecipe(ModelNode var1) throws IllegalArgumentException;

    public final void initialize(@Nonnull AnalysisContext analysisContext) {
        this.analysisContext = analysisContext;
        this.configuredRecipes = new ArrayList<DifferenceMatchRecipe>();
        ModelNode myNode = this.getRecipesConfigurationAndInitialize();
        if (myNode.getType() != ModelType.LIST) {
            this.codes = new Pattern[0];
            return;
        }
        ArrayList<Pattern> codes = new ArrayList<Pattern>();
        for (ModelNode config : myNode.asList()) {
            DifferenceMatchRecipe recipe = this.newRecipe(config);
            codes.add(recipe.codeRegex == null ? Pattern.compile("^" + Pattern.quote(recipe.code) + "$") : recipe.codeRegex);
            this.configuredRecipes.add(recipe);
        }
        this.codes = codes.toArray(new Pattern[0]);
    }

    @Nullable
    public final Difference transform(@Nullable Element oldElement, @Nullable Element newElement, @Nonnull Difference difference) {
        if (this.configuredRecipes == null) {
            return difference;
        }
        for (DifferenceMatchRecipe r : this.configuredRecipes) {
            if (!r.matches(difference, oldElement, newElement)) continue;
            return r.transformMatching(difference, oldElement, newElement);
        }
        return difference;
    }
}

