/*
 * Decompiled with CFR 0.152.
 */
package pw.krejci.modules.maven;

import java.io.File;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.RepositoryPolicy;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleFinder;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;
import pw.krejci.modules.maven.ImportEverythingExportServices;
import pw.krejci.modules.maven.MavenBootstrap;
import pw.krejci.modules.maven.MavenModuleFinder;
import pw.krejci.modules.maven.ModuleSpecController;

public final class ProjectModule {
    private ProjectModule() {
        throw new AssertionError();
    }

    public static Builder build() {
        return ProjectModule.build("#");
    }

    public static Builder build(String projectName) {
        return new Builder(projectName);
    }

    public static final class Builder {
        private final String projectName;
        private final Set<String> deps;
        private LocalRepository localRepo;
        private final Set<RemoteRepository> remoteRepositories;
        private ModuleSpecController moduleSpecController = ModuleSpecController.NOOP;

        private Builder(String projectName) {
            this.projectName = projectName;
            this.deps = new HashSet<String>(8);
            this.localRepo = MavenBootstrap.homeM2Repository();
            this.remoteRepositories = new LinkedHashSet<RemoteRepository>();
            this.remoteRepositories.add(MavenBootstrap.mavenCentral());
        }

        public Builder addDependency(String gav) {
            this.deps.add(new DefaultArtifact(gav).toString());
            return this;
        }

        public Builder localRepository(File root) {
            this.localRepo = new LocalRepository(root);
            return this;
        }

        public Builder localRepository(String rootPath) {
            return this.localRepository(new File(rootPath));
        }

        public Builder addRemoteRepository(String name, String url) {
            this.remoteRepositories.add(new RemoteRepository.Builder(name, "default", url).build());
            return this;
        }

        public Builder addRemoteRepository(String name, String url, RepositoryPolicy policy) {
            this.remoteRepositories.add(new RemoteRepository.Builder(name, "default", url).setPolicy(policy).build());
            return this;
        }

        public Builder addRemoteRepository(RemoteRepository repository) {
            this.remoteRepositories.add(repository);
            return this;
        }

        public Builder moduleSpecController(ModuleSpecController controller) {
            this.moduleSpecController = controller;
            return this;
        }

        public Module create() {
            ModuleFinder projectFinder = new ModuleFinder(){

                public ModuleSpec findModule(String name, ModuleLoader delegateLoader) throws ModuleLoadException {
                    if (!name.equals(projectName)) {
                        return null;
                    }
                    moduleSpecController.start(projectName);
                    ModuleSpec.Builder bld = ModuleSpec.build((String)projectName);
                    for (String dep : deps) {
                        DependencySpec spec = ImportEverythingExportServices.spec(dep);
                        spec = moduleSpecController.modifyDependency(dep, spec);
                        if (spec == null) continue;
                        bld.addDependency(spec);
                    }
                    moduleSpecController.modify(bld);
                    moduleSpecController.end(projectName);
                    return bld.create();
                }
            };
            MavenModuleFinder mavenModuleFinder = new MavenModuleFinder(this.localRepo, this.remoteRepositories, this.moduleSpecController);
            ModuleLoader loader = new ModuleLoader(new ModuleFinder[]{projectFinder, mavenModuleFinder});
            try {
                return loader.loadModule(this.projectName);
            }
            catch (ModuleLoadException e) {
                throw e.toError();
            }
        }
    }
}

