/*
 * Decompiled with CFR 0.152.
 */
package org.revapi;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.revapi.Archive;

public final class API {
    private final Iterable<? extends Archive> archives;
    private final Iterable<? extends Archive> supplementaryArchives;

    public API(@Nonnull Iterable<? extends Archive> archives, @Nullable Iterable<? extends Archive> supplementaryArchives) {
        this.archives = archives;
        this.supplementaryArchives = supplementaryArchives;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder of(Archive ... archives) {
        return API.builder().of(archives);
    }

    public static Builder of(Iterable<? extends Archive> archives) {
        return API.builder().of(archives);
    }

    @Nonnull
    public Iterable<? extends Archive> getArchives() {
        return this.archives;
    }

    @Nullable
    public Iterable<? extends Archive> getSupplementaryArchives() {
        return this.supplementaryArchives;
    }

    public String toString() {
        StringBuilder bld = new StringBuilder("API[archives=");
        API.addArchivesToString(bld, this.archives);
        bld.append(", supplementary=");
        API.addArchivesToString(bld, this.supplementaryArchives);
        bld.append("]");
        return bld.toString();
    }

    private static void addArchivesToString(StringBuilder bld, Iterable<? extends Archive> archives) {
        bld.append("[");
        if (archives != null) {
            Iterator<? extends Archive> it = archives.iterator();
            if (it.hasNext()) {
                bld.append(it.next().getName());
            }
            while (it.hasNext()) {
                bld.append(", ").append(it.next().getName());
            }
        }
        bld.append("]");
    }

    public static final class Builder {
        private final Set<Archive> archives = new LinkedHashSet<Archive>();
        private final Set<Archive> supplementaryArchives = new LinkedHashSet<Archive>();

        public Builder of(Archive ... archives) {
            return this.of(Arrays.asList(archives));
        }

        public Builder of(Iterable<? extends Archive> archives) {
            this.archives.clear();
            return this.addArchives(archives);
        }

        public Builder addArchive(Archive archive) {
            this.archives.add(archive);
            return this;
        }

        public Builder addArchives(Archive ... archives) {
            return this.addArchives(Arrays.asList(archives));
        }

        public Builder addArchives(Iterable<? extends Archive> archives) {
            for (Archive archive : archives) {
                this.archives.add(archive);
            }
            return this;
        }

        public Builder supportedBy(Archive ... archives) {
            return this.supportedBy(Arrays.asList(archives));
        }

        public Builder supportedBy(Iterable<? extends Archive> archives) {
            this.supplementaryArchives.clear();
            return this.addSupportArchives(archives);
        }

        public Builder addSupportArchive(Archive archive) {
            this.supplementaryArchives.add(archive);
            return this;
        }

        public Builder addSupportArchives(Archive ... archives) {
            return this.addSupportArchives(Arrays.asList(archives));
        }

        public Builder addSupportArchives(Iterable<? extends Archive> archives) {
            for (Archive archive : archives) {
                this.supplementaryArchives.add(archive);
            }
            return this;
        }

        public API build() {
            return new API(this.archives, this.supplementaryArchives);
        }
    }
}

