/*
 * Decompiled with CFR 0.152.
 */
package org.revapi;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.revapi.API;
import org.revapi.Revapi;
import org.revapi.configuration.Configurable;
import org.revapi.configuration.JSONUtil;

public final class AnalysisContext {
    private final Locale locale;
    private final ModelNode configuration;
    private final API oldApi;
    private final API newApi;
    private final Map<String, Object> data;

    private AnalysisContext(@Nonnull Locale locale, @Nullable ModelNode configuration, @Nonnull API oldApi, @Nonnull API newApi, @Nonnull Map<String, Object> data) {
        this.locale = locale;
        if (configuration == null) {
            this.configuration = new ModelNode();
            this.configuration.setEmptyList();
        } else {
            this.configuration = configuration;
        }
        this.oldApi = oldApi;
        this.newApi = newApi;
        this.data = data;
    }

    @Nonnull
    public static Builder builder(Revapi revapi) {
        ArrayList<String> knownExtensionIds = new ArrayList<String>();
        AnalysisContext.addExtensionIds(revapi.getPipelineConfiguration().getApiAnalyzerTypes(), knownExtensionIds);
        AnalysisContext.addExtensionIds(revapi.getPipelineConfiguration().getTransformTypes(), knownExtensionIds);
        AnalysisContext.addExtensionIds(revapi.getPipelineConfiguration().getFilterTypes(), knownExtensionIds);
        AnalysisContext.addExtensionIds(revapi.getPipelineConfiguration().getReporterTypes(), knownExtensionIds);
        return new Builder(knownExtensionIds);
    }

    public static Builder builder() {
        return new Builder(null);
    }

    public AnalysisContext copyWithConfiguration(ModelNode configuration) {
        return new AnalysisContext(this.locale, configuration, this.oldApi, this.newApi, this.data);
    }

    @Nonnull
    public Locale getLocale() {
        return this.locale;
    }

    @Nonnull
    public ModelNode getConfiguration() {
        return this.configuration;
    }

    @Nonnull
    public API getOldApi() {
        return this.oldApi;
    }

    @Nonnull
    public API getNewApi() {
        return this.newApi;
    }

    @Nullable
    public Object getData(String key) {
        return this.data.get(key);
    }

    private static <T extends Configurable> void addExtensionIds(Collection<Class<? extends T>> cs, List<String> extensionIds) {
        cs.stream().map(AnalysisContext::instantiate).map(Configurable::getExtensionId).filter(Objects::nonNull).forEach(extensionIds::add);
    }

    private static <T> T instantiate(Class<T> cls) {
        try {
            return cls.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException("Class " + cls + " does not have a public no-arg constructor.", e);
        }
    }

    public static final class Builder {
        private final List<String> knownExtensionIds;
        private Locale locale = Locale.getDefault();
        private API oldApi;
        private API newApi;
        private ModelNode configuration;
        private Map<String, Object> data = new HashMap<String, Object>(2);

        private Builder(List<String> knownExtensionIds) {
            this.knownExtensionIds = knownExtensionIds;
        }

        public Builder withLocale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public Builder withOldAPI(API api) {
            this.oldApi = api;
            return this;
        }

        public Builder withNewAPI(API api) {
            this.newApi = api;
            return this;
        }

        public Builder withConfiguration(ModelNode data) {
            this.configuration = this.convertToNewStyle(data);
            return this;
        }

        public Builder withConfigurationFromJSON(String json) {
            this.configuration = this.convertToNewStyle(ModelNode.fromJSONString((String)JSONUtil.stripComments(json)));
            return this;
        }

        public Builder withConfigurationFromJSONStream(InputStream jsonStream) throws IOException {
            this.configuration = this.convertToNewStyle(ModelNode.fromJSONStream((InputStream)JSONUtil.stripComments(jsonStream, Charset.forName("UTF-8"))));
            return this;
        }

        public Builder mergeConfiguration(ModelNode config) {
            if (this.configuration == null) {
                this.configuration = new ModelNode();
                this.configuration.setEmptyList();
            }
            Builder.mergeConfigs(this.configuration, this.convertToNewStyle(config));
            return this;
        }

        public Builder mergeConfigurationFromJSON(String json) {
            if (this.configuration == null) {
                this.configuration = new ModelNode();
                this.configuration.setEmptyList();
            }
            Builder.mergeConfigs(this.configuration, this.convertToNewStyle(ModelNode.fromJSONString((String)JSONUtil.stripComments(json))));
            return this;
        }

        public Builder mergeConfigurationFromJSONStream(InputStream jsonStream) throws IOException {
            if (this.configuration == null) {
                this.configuration = new ModelNode();
                this.configuration.setEmptyList();
            }
            InputStream str = JSONUtil.stripComments(jsonStream, Charset.forName("UTF-8"));
            Builder.mergeConfigs(this.configuration, ModelNode.fromJSONStream((InputStream)str));
            return this;
        }

        public Builder withData(Map<String, Object> data) {
            this.data.putAll(data);
            return this;
        }

        public Builder withData(String key, Object value) {
            this.data.put(key, value);
            return this;
        }

        public AnalysisContext build() {
            return new AnalysisContext(this.locale, this.configuration, this.oldApi, this.newApi, this.data);
        }

        private ModelNode convertToNewStyle(ModelNode configuration) {
            if (configuration.getType() == ModelType.LIST) {
                HashMap<String, Set> idsByExtension = new HashMap<String, Set>(4);
                for (ModelNode c : configuration.asList()) {
                    if (!c.hasDefined("id")) continue;
                    String extension = c.get("extension").asString();
                    String id = c.get("id").asString();
                    boolean added = idsByExtension.computeIfAbsent(extension, x -> new HashSet(2)).add(id);
                    if (added) continue;
                    throw new IllegalArgumentException("A configuration cannot contain 2 extension configurations with the same id. At least 2 extension configurations of extension '" + extension + "' have the id '" + id + "'.");
                }
                return configuration;
            }
            if (this.knownExtensionIds == null) {
                throw new IllegalArgumentException("The analysis context builder wasn't supplied with the list of known extension ids, so it only can process new-style configurations.");
            }
            ModelNode newStyleConfig = new ModelNode();
            newStyleConfig.setEmptyList();
            block1: for (String extensionId : this.knownExtensionIds) {
                String[] explodedId = extensionId.split("\\.");
                ModelNode extConfig = configuration;
                for (String segment : explodedId) {
                    if (!extConfig.hasDefined(segment)) continue block1;
                    extConfig = extConfig.get(segment);
                }
                ModelNode extNewStyle = new ModelNode();
                extNewStyle.get("extension").set(extensionId);
                extNewStyle.get("configuration").set(extConfig);
                newStyleConfig.add(extNewStyle);
            }
            return newStyleConfig;
        }

        private static void splitByExtensionAndId(List<ModelNode> configs, Map<String, Map<String, ModelNode>> byExtensionAndId, Map<String, List<ModelNode>> idlessByExtension) {
            for (ModelNode c : configs) {
                String extensionId = c.get("extension").asString();
                if (!c.hasDefined("id")) {
                    idlessByExtension.computeIfAbsent(extensionId, x -> new ArrayList(2)).add(c);
                    continue;
                }
                String id = c.get("id").asString();
                byExtensionAndId.computeIfAbsent(extensionId, x -> new HashMap(2)).compute(id, (i, n) -> {
                    if (n == null) {
                        return c;
                    }
                    throw new IllegalArgumentException("There cannot be 2 or more configurations with the same ID.");
                });
            }
        }

        private static void mergeConfigs(ModelNode a, ModelNode b) {
            HashMap<String, Map<String, ModelNode>> aByExtensionAndId = new HashMap<String, Map<String, ModelNode>>(4);
            HashMap<String, List<ModelNode>> idlessAByExtensionId = new HashMap<String, List<ModelNode>>(4);
            Builder.splitByExtensionAndId(a.asList(), aByExtensionAndId, idlessAByExtensionId);
            HashMap<String, Map<String, ModelNode>> bByExtensionAndId = new HashMap<String, Map<String, ModelNode>>(4);
            HashMap<String, List<ModelNode>> idlessBByExtensionId = new HashMap<String, List<ModelNode>>(4);
            Builder.splitByExtensionAndId(b.asList(), bByExtensionAndId, idlessBByExtensionId);
            Stream.concat(aByExtensionAndId.keySet().stream(), idlessAByExtensionId.keySet().stream()).forEach(ext -> {
                int aCnt = idlessAByExtensionId.getOrDefault(ext, Collections.emptyList()).size() + aByExtensionAndId.getOrDefault(ext, Collections.emptyMap()).size();
                int bCnt = idlessBByExtensionId.getOrDefault(ext, Collections.emptyList()).size();
                if (aCnt > 1 && bCnt > 0) {
                    throw new IllegalArgumentException("The configuration already contains more than 1 configuration for extension " + ext + ". Cannot determine which one of them to merge the new configuration(s) (which don't have an explicit ID) into.");
                }
                if (aCnt > 0 && bCnt > 1) {
                    throw new IllegalArgumentException("The configuration already contains 1 or more configurations for extension " + ext + ". At the same time, the configuration to merge already contains 2 or more configurations for the same extension without an explicit ID. Cannot figure out how to merge these together.");
                }
            });
            int bcIdx = 0;
            for (ModelNode bc : b.asList()) {
                ArrayList<String> path;
                String bcId = bc.hasDefined("id") ? bc.get("id").asString() : null;
                String bcExtension = bc.get("extension").asString();
                if (bcId == null) {
                    List idless = (List)idlessAByExtensionId.get(bcExtension);
                    if (idless != null) {
                        if (idless.size() == 1) {
                            ArrayList<String> path2 = new ArrayList<String>(4);
                            path2.addAll(Arrays.asList("[" + bcIdx + "]", "configuration"));
                            Builder.mergeNodes(bcExtension, null, path2, ((ModelNode)idless.get(0)).get("configuration"), bc.get("configuration"));
                        }
                    } else {
                        Map aExtensions = (Map)aByExtensionAndId.get(bcExtension);
                        if (aExtensions == null) {
                            a.add(bc);
                            continue;
                        }
                        path = new ArrayList<String>(4);
                        path.addAll(Arrays.asList("[" + bcIdx + "]", "configuration"));
                        ModelNode aConfig = (ModelNode)aExtensions.values().iterator().next();
                        Builder.mergeNodes(bcExtension, null, path, aConfig.get("configuration"), bc.get("configuration"));
                    }
                } else {
                    Map aExtensions = (Map)aByExtensionAndId.get(bcExtension);
                    if (aExtensions == null) {
                        a.add(bc);
                        continue;
                    }
                    ModelNode aConfig = (ModelNode)aExtensions.get(bcId);
                    if (aConfig == null) {
                        a.add(bc);
                    } else {
                        path = new ArrayList(4);
                        path.addAll(Arrays.asList("[" + bcIdx + "]", "configuration"));
                        Builder.mergeNodes(bcExtension, bcId, path, aConfig.get("configuration"), bc.get("configuration"));
                    }
                }
                ++bcIdx;
            }
        }

        private static void mergeNodes(String extension, String id, List<String> path, ModelNode a, ModelNode b) {
            switch (b.getType()) {
                case LIST: {
                    for (ModelNode v : b.asList()) {
                        a.add(v.clone());
                    }
                    break;
                }
                case OBJECT: {
                    for (String k : b.keys()) {
                        ModelNode ak = a.get(k);
                        path.add(k);
                        Builder.mergeNodes(extension, id, path, ak, b.get(k));
                        path.remove(path.size() - 1);
                    }
                    break;
                }
                default: {
                    if (a.isDefined()) {
                        String p = path.stream().collect(Collectors.joining("/"));
                        throw new IllegalArgumentException("A conflict detected while merging configurations of extension '" + extension + "' with id '" + id + "'. A value on path '" + p + "' would overwrite an already existing one.");
                    }
                    a.set(b);
                }
            }
        }
    }
}

