/*
 * Decompiled with CFR 0.152.
 */
package org.revapi;

import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.revapi.AnalysisContext;
import org.revapi.ApiAnalyzer;
import org.revapi.DifferenceTransform;
import org.revapi.ElementFilter;
import org.revapi.Reporter;
import org.revapi.Revapi;
import org.revapi.Stats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AnalysisResult
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(AnalysisResult.class);
    private final Exception failure;
    private final Extensions extensions;

    public static AnalysisResult fakeSuccess() {
        return new AnalysisResult(null, new Extensions(Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap()));
    }

    public static AnalysisResult fakeFailure(Exception failure) {
        return new AnalysisResult(failure, new Extensions(Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap()));
    }

    AnalysisResult(@Nullable Exception failure, Extensions extensions) {
        this.failure = failure;
        this.extensions = extensions;
    }

    public boolean isSuccess() {
        return this.failure == null;
    }

    @Nullable
    public Exception getFailure() {
        return this.failure;
    }

    public void throwIfFailed() throws Exception {
        if (this.failure != null) {
            throw this.failure;
        }
    }

    public Extensions getExtensions() {
        return this.extensions;
    }

    @Override
    public void close() throws Exception {
        Revapi.TIMING_LOG.debug(Stats.asString());
        Revapi.TIMING_LOG.debug("Closing all extensions");
        Consumer<ExtensionInstance> close = inst -> {
            Object ext = ((ExtensionInstance)inst).instance;
            if (!(ext instanceof AutoCloseable)) {
                return;
            }
            AutoCloseable c = (AutoCloseable)ext;
            try {
                c.close();
            }
            catch (Exception ex) {
                LOG.warn("Failed to close " + c, (Throwable)ex);
            }
        };
        this.extensions.reporters.keySet().forEach(close);
        this.extensions.transforms.keySet().forEach(close);
        this.extensions.filters.keySet().forEach(close);
        this.extensions.analyzers.keySet().forEach(close);
        Revapi.TIMING_LOG.debug("Extensions closed. Analysis complete.");
    }

    public static final class ExtensionInstance<I> {
        private final I instance;
        @Nullable
        private final String id;

        ExtensionInstance(I instance, @Nullable String id) {
            this.instance = instance;
            this.id = id;
        }

        public I getInstance() {
            return this.instance;
        }

        @Nullable
        public String getId() {
            return this.id;
        }

        public <U> ExtensionInstance<U> as(Class<U> instanceType) {
            if (!instanceType.isAssignableFrom(this.instance.getClass())) {
                throw new ClassCastException();
            }
            ExtensionInstance ret = this;
            return ret;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ExtensionInstance)) {
                return false;
            }
            ExtensionInstance that = (ExtensionInstance)o;
            return Objects.equals(this.instance, that.instance) && Objects.equals(this.id, that.id);
        }

        public int hashCode() {
            return Objects.hash(this.instance, this.id);
        }
    }

    public static final class Extensions
    implements Iterable<Map.Entry<ExtensionInstance<?>, AnalysisContext>> {
        private final Map<ExtensionInstance<ApiAnalyzer>, AnalysisContext> analyzers;
        private final Map<ExtensionInstance<ElementFilter>, AnalysisContext> filters;
        private final Map<ExtensionInstance<Reporter>, AnalysisContext> reporters;
        private final Map<ExtensionInstance<DifferenceTransform<?>>, AnalysisContext> transforms;

        Extensions(Map<ExtensionInstance<ApiAnalyzer>, AnalysisContext> analyzers, Map<ExtensionInstance<ElementFilter>, AnalysisContext> filters, Map<ExtensionInstance<Reporter>, AnalysisContext> reporters, Map<ExtensionInstance<DifferenceTransform<?>>, AnalysisContext> transforms) {
            this.analyzers = Collections.unmodifiableMap(analyzers);
            this.filters = Collections.unmodifiableMap(filters);
            this.reporters = Collections.unmodifiableMap(reporters);
            this.transforms = Collections.unmodifiableMap(transforms);
        }

        public Map<ExtensionInstance<ApiAnalyzer>, AnalysisContext> getAnalyzers() {
            return this.analyzers;
        }

        public Map<ExtensionInstance<ElementFilter>, AnalysisContext> getFilters() {
            return this.filters;
        }

        public Map<ExtensionInstance<Reporter>, AnalysisContext> getReporters() {
            return this.reporters;
        }

        public Map<ExtensionInstance<DifferenceTransform<?>>, AnalysisContext> getTransforms() {
            return this.transforms;
        }

        public <T> Map<ExtensionInstance<T>, AnalysisContext> getExtensionContexts(Class<T> extensionType) {
            IdentityHashMap ret = new IdentityHashMap();
            this.stream().filter(e -> extensionType.isAssignableFrom(((ExtensionInstance)e.getKey()).getInstance().getClass())).forEach(e -> {
                AnalysisContext cfr_ignored_0 = (AnalysisContext)ret.put(((ExtensionInstance)e.getKey()).as(extensionType), (AnalysisContext)e.getValue());
            });
            return ret;
        }

        public <T> Set<ExtensionInstance<T>> getExtensionInstances(Class<T> extensionType) {
            return this.getExtensionContexts(extensionType).keySet();
        }

        public <T> T getFirstExtension(Class<T> extensionType, T defaultValue) {
            Set<ExtensionInstance<T>> instances = this.getExtensionInstances(extensionType);
            return instances.isEmpty() ? defaultValue : instances.iterator().next().getInstance();
        }

        public AnalysisContext getFirstConfigurationOrNull(Class<?> extensionType) {
            Collection<AnalysisContext> ctxs = this.getExtensionContexts(extensionType).values();
            return ctxs.isEmpty() ? null : ctxs.iterator().next();
        }

        @Override
        public Iterator<Map.Entry<ExtensionInstance<?>, AnalysisContext>> iterator() {
            return this.stream().iterator();
        }

        public Stream<Map.Entry<ExtensionInstance<?>, AnalysisContext>> stream() {
            return Stream.concat(Extensions.retype(this.analyzers.entrySet()).stream(), Stream.concat(Extensions.retype(this.filters.entrySet()).stream(), Stream.concat(Extensions.retype(this.reporters.entrySet()).stream(), Extensions.retype(this.transforms.entrySet()).stream())));
        }

        private static Set<Map.Entry<ExtensionInstance<?>, AnalysisContext>> retype(Set<?> set) {
            return set;
        }
    }
}

