/*
 * Decompiled with CFR 0.152.
 */
package org.revapi;

import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.revapi.NaturalOrderComparator;

public final class CoIterator<E> {
    private final Iterator<? extends E> left;
    private final Iterator<? extends E> right;
    private final Comparator<? super E> comparator;
    private E currentLeft;
    private E currentRight;
    private E reportedLeft;
    private E reportedRight;

    public CoIterator(Iterator<? extends E> left, Iterator<? extends E> right, Comparator<? super E> comparator) {
        this.left = left;
        this.right = right;
        this.comparator = comparator;
        if (left.hasNext()) {
            this.currentLeft = left.next();
        }
        if (right.hasNext()) {
            this.currentRight = right.next();
        }
    }

    public CoIterator(Iterator<? extends E> left, Iterator<? extends E> right) {
        this(left, right, new NaturalOrderComparator());
    }

    public boolean hasNext() {
        return this.currentLeft != null || this.currentRight != null;
    }

    public void next() {
        boolean hasRight;
        boolean hasLeft = this.currentLeft != null;
        boolean bl = hasRight = this.currentRight != null;
        if (!hasLeft && !hasRight) {
            throw new NoSuchElementException();
        }
        int order = hasLeft && !hasRight ? -1 : (!hasLeft ? 1 : this.comparator.compare(this.currentLeft, this.currentRight));
        if (order < 0) {
            this.reportedLeft = this.currentLeft;
            this.currentLeft = this.nextOrNull(this.left);
            this.reportedRight = null;
        } else if (order > 0) {
            this.reportedLeft = null;
            this.reportedRight = this.currentRight;
            this.currentRight = this.nextOrNull(this.right);
        } else {
            this.reportedLeft = this.currentLeft;
            this.reportedRight = this.currentRight;
            this.currentLeft = this.nextOrNull(this.left);
            this.currentRight = this.nextOrNull(this.right);
        }
    }

    public E getLeft() {
        return this.reportedLeft;
    }

    public E getRight() {
        return this.reportedRight;
    }

    private E nextOrNull(Iterator<? extends E> it) {
        return it.hasNext() ? (E)it.next() : null;
    }
}

