/*
 * Decompiled with CFR 0.152.
 */
package org.revapi;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.revapi.CompatibilityType;
import org.revapi.DifferenceSeverity;
import org.revapi.Report;

public final class Difference {
    public final String code;
    public final String name;
    public final String description;
    public final Map<CompatibilityType, DifferenceSeverity> classification;
    public final Map<String, String> attachments;
    private final List<String> identifyingAttachments;

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    public Difference(@Nonnull String code, @Nonnull String name, @Nullable String description, @Nonnull CompatibilityType compatibility, @Nonnull DifferenceSeverity severity, @Nonnull Map<String, String> attachments) {
        this(code, name, description, Collections.singletonMap(compatibility, severity), attachments);
    }

    public Difference(@Nonnull String code, @Nonnull String name, @Nullable String description, @Nonnull Map<CompatibilityType, DifferenceSeverity> classification, @Nonnull Map<String, String> attachments) {
        this(code, name, description, classification, attachments, Collections.emptyList());
    }

    public Difference(@Nonnull String code, @Nonnull String name, @Nullable String description, @Nonnull Map<CompatibilityType, DifferenceSeverity> classification, @Nonnull Map<String, String> attachments, @Nonnull List<String> identifyingAttachments) {
        this.code = code;
        this.name = name;
        this.description = description;
        HashMap<CompatibilityType, DifferenceSeverity> tmp = new HashMap<CompatibilityType, DifferenceSeverity>(classification);
        this.classification = Collections.unmodifiableMap(tmp);
        this.attachments = Collections.unmodifiableMap(new LinkedHashMap<String, String>(attachments));
        this.identifyingAttachments = Collections.unmodifiableList(identifyingAttachments);
    }

    public boolean isIdentifyingAttachment(String attachmentName) {
        return this.identifyingAttachments.contains(attachmentName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Difference difference = (Difference)o;
        return this.code.equals(difference.code) && this.classification.equals(difference.classification) && this.attachments.equals(difference.attachments);
    }

    public int hashCode() {
        int result = this.code.hashCode();
        result = 31 * result + this.classification.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Difference[");
        sb.append("code='").append(this.code).append('\'');
        sb.append(", name='").append(this.name).append('\'');
        sb.append(", classification=").append(this.classification);
        sb.append(", description='").append(this.description).append('\'');
        sb.append(']');
        return sb.toString();
    }

    public static final class InReportBuilder
    extends BuilderBase<InReportBuilder> {
        private final Report.Builder reportBuilder;

        InReportBuilder(Report.Builder reportBuilder) {
            this.reportBuilder = reportBuilder;
        }

        @Nonnull
        public Report.Builder done() {
            Difference p = new Difference(this.code, this.name, this.description, this.classification, this.attachments, this.identifyingAttachments);
            this.reportBuilder.differences.add(p);
            return this.reportBuilder;
        }
    }

    public static final class Builder
    extends BuilderBase<Builder> {
        private Builder() {
        }

        @Nonnull
        public Difference build() {
            return new Difference(this.code, this.name, this.description, this.classification, this.attachments, this.identifyingAttachments);
        }
    }

    private static abstract class BuilderBase<This extends BuilderBase> {
        protected String code;
        protected String name;
        protected String description;
        protected Map<CompatibilityType, DifferenceSeverity> classification = new HashMap<CompatibilityType, DifferenceSeverity>();
        protected Map<String, String> attachments = new LinkedHashMap<String, String>(2);
        protected List<String> identifyingAttachments = new ArrayList<String>(2);

        private BuilderBase() {
        }

        @Nonnull
        public This withCode(@Nonnull String code) {
            this.code = code;
            return this.castThis();
        }

        @Nonnull
        public This withName(@Nonnull String name) {
            this.name = name;
            return this.castThis();
        }

        @Nonnull
        public This withDescription(@Nullable String description) {
            this.description = description;
            return this.castThis();
        }

        @Nonnull
        public This addClassification(@Nonnull CompatibilityType compat, @Nonnull DifferenceSeverity severity) {
            this.classification.put(compat, severity);
            return this.castThis();
        }

        @Nonnull
        public This addClassifications(Map<CompatibilityType, DifferenceSeverity> classifications) {
            this.classification.putAll(classifications);
            return this.castThis();
        }

        @Nonnull
        public This addAttachment(@Nonnull String key, @Nonnull String value) {
            this.attachments.put(key, value);
            return this.castThis();
        }

        @Nonnull
        public This addAttachments(@Nonnull Map<String, String> attachments) {
            this.attachments.putAll(attachments);
            return this.castThis();
        }

        @Nonnull
        public This withIdentifyingAttachments(@Nonnull List<String> attachments) {
            this.identifyingAttachments = attachments;
            return this.castThis();
        }

        private This castThis() {
            return (This)this;
        }
    }
}

