/*
 * Decompiled with CFR 0.152.
 */
package org.revapi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.dmr.ModelNode;
import org.revapi.ApiAnalyzer;
import org.revapi.DifferenceTransform;
import org.revapi.ElementFilter;
import org.revapi.Reporter;
import org.revapi.ServiceTypeLoader;

public final class PipelineConfiguration {
    private final Set<Class<? extends ApiAnalyzer>> apiAnalyzerTypes;
    private final Set<Class<? extends Reporter>> reporterTypes;
    private final Set<Class<? extends DifferenceTransform<?>>> transformTypes;
    private final Set<Class<? extends ElementFilter>> filterTypes;
    private final Set<List<String>> transformationBlocks;
    private final List<String> includedAnalyzerExtensionIds;
    private final List<String> excludedAnalyzerExtensionIds;
    private final List<String> includedReporterExtensionIds;
    private final List<String> excludedReporterExtensionIds;
    private final List<String> includedTransformExtensionIds;
    private final List<String> excludedTransformExtensionIds;
    private final List<String> includedFilterExtensionIds;
    private final List<String> excludedFilterExtensionIds;

    public static Builder builder() {
        return new Builder();
    }

    public static Builder parse(ModelNode json) {
        ModelNode analyzerIncludeNode = json.get("analyzers").get("include");
        ModelNode analyzerExcludeNode = json.get("analyzers").get("exclude");
        ModelNode filterIncludeNode = json.get("filters").get("include");
        ModelNode filterExcludeNode = json.get("filters").get("exclude");
        ModelNode transformIncludeNode = json.get("transforms").get("include");
        ModelNode transformExcludeNode = json.get("transforms").get("exclude");
        ModelNode reporterIncludeNode = json.get("reporters").get("include");
        ModelNode reporterExcludeNode = json.get("reporters").get("exclude");
        return PipelineConfiguration.builder().withTransformationBlocks(json.get("transformBlocks")).withAnalyzerExtensionIdsInclude(PipelineConfiguration.asStringList(analyzerIncludeNode)).withAnalyzerExtensionIdsExclude(PipelineConfiguration.asStringList(analyzerExcludeNode)).withFilterExtensionIdsInclude(PipelineConfiguration.asStringList(filterIncludeNode)).withFilterExtensionIdsExclude(PipelineConfiguration.asStringList(filterExcludeNode)).withTransformExtensionIdsInclude(PipelineConfiguration.asStringList(transformIncludeNode)).withTransformExtensionIdsExclude(PipelineConfiguration.asStringList(transformExcludeNode)).withReporterExtensionIdsInclude(PipelineConfiguration.asStringList(reporterIncludeNode)).withReporterExtensionIdsExclude(PipelineConfiguration.asStringList(reporterExcludeNode));
    }

    public static PipelineConfiguration parse(ModelNode json, Collection<Class<? extends ApiAnalyzer>> analyzers, Collection<Class<? extends ElementFilter>> filters, Collection<Class<? extends DifferenceTransform<?>>> transforms, Collection<Class<? extends Reporter>> reporters) {
        return PipelineConfiguration.parse(json).withAnalyzers(analyzers).withFilters(filters).withTransforms(transforms).withReporters(reporters).build();
    }

    private static List<String> asStringList(ModelNode listNode) {
        if (!listNode.isDefined()) {
            return Collections.emptyList();
        }
        return listNode.asList().stream().map(ModelNode::asString).collect(Collectors.toList());
    }

    public PipelineConfiguration(Set<Class<? extends ApiAnalyzer>> apiAnalyzerTypes, Set<Class<? extends Reporter>> reporterTypes, Set<Class<? extends DifferenceTransform<?>>> transformTypes, Set<Class<? extends ElementFilter>> filterTypes, Set<List<String>> transformationBlocks, List<String> includedAnalyzerExtensionIds, List<String> excludedAnalyzerExtensionIds, List<String> includedReporterExtensionIds, List<String> excludedReporterExtensionIds, List<String> includedTransformExtensionIds, List<String> excludedTransformExtensionIds, List<String> includedFilterExtensionIds, List<String> excludedFilterExtensionIds) {
        this.apiAnalyzerTypes = apiAnalyzerTypes;
        this.reporterTypes = reporterTypes;
        this.transformTypes = transformTypes;
        this.filterTypes = filterTypes;
        this.transformationBlocks = transformationBlocks;
        this.includedAnalyzerExtensionIds = includedAnalyzerExtensionIds;
        this.excludedAnalyzerExtensionIds = excludedAnalyzerExtensionIds;
        this.includedReporterExtensionIds = includedReporterExtensionIds;
        this.excludedReporterExtensionIds = excludedReporterExtensionIds;
        this.includedTransformExtensionIds = includedTransformExtensionIds;
        this.excludedTransformExtensionIds = excludedTransformExtensionIds;
        this.includedFilterExtensionIds = includedFilterExtensionIds;
        this.excludedFilterExtensionIds = excludedFilterExtensionIds;
    }

    public Set<Class<? extends ApiAnalyzer>> getApiAnalyzerTypes() {
        return this.apiAnalyzerTypes;
    }

    public Set<Class<? extends Reporter>> getReporterTypes() {
        return this.reporterTypes;
    }

    public Set<Class<? extends DifferenceTransform<?>>> getTransformTypes() {
        return this.transformTypes;
    }

    public Set<Class<? extends ElementFilter>> getFilterTypes() {
        return this.filterTypes;
    }

    public Set<List<String>> getTransformationBlocks() {
        return this.transformationBlocks;
    }

    public List<String> getIncludedAnalyzerExtensionIds() {
        return this.includedAnalyzerExtensionIds;
    }

    public List<String> getExcludedAnalyzerExtensionIds() {
        return this.excludedAnalyzerExtensionIds;
    }

    public List<String> getIncludedReporterExtensionIds() {
        return this.includedReporterExtensionIds;
    }

    public List<String> getExcludedReporterExtensionIds() {
        return this.excludedReporterExtensionIds;
    }

    public List<String> getIncludedTransformExtensionIds() {
        return this.includedTransformExtensionIds;
    }

    public List<String> getExcludedTransformExtensionIds() {
        return this.excludedTransformExtensionIds;
    }

    public List<String> getIncludedFilterExtensionIds() {
        return this.includedFilterExtensionIds;
    }

    public List<String> getExcludedFilterExtensionIds() {
        return this.excludedFilterExtensionIds;
    }

    public static final class Builder {
        private Set<Class<? extends ApiAnalyzer>> analyzers = null;
        private Set<Class<? extends Reporter>> reporters = null;
        private Set<Class<? extends DifferenceTransform<?>>> transforms = null;
        private Set<Class<? extends ElementFilter>> filters = null;
        private Set<List<String>> transformationBlocks = null;
        private List<String> includedAnalyzerExtensionIds = null;
        private List<String> excludedAnalyzerExtensionIds = null;
        private List<String> includedReporterExtensionIds = null;
        private List<String> excludedReporterExtensionIds = null;
        private List<String> includedTransformExtensionIds = null;
        private List<String> excludedTransformExtensionIds = null;
        private List<String> includedFilterExtensionIds = null;
        private List<String> excludedFilterExtensionIds = null;

        public Builder withAnalyzersFromThreadContextClassLoader() {
            return this.withAnalyzers(ServiceTypeLoader.load(ApiAnalyzer.class));
        }

        public Builder withAnalyzersFrom(ClassLoader cl) {
            return this.withAnalyzers(ServiceTypeLoader.load(ApiAnalyzer.class, cl));
        }

        @SafeVarargs
        public final Builder withAnalyzers(Class<? extends ApiAnalyzer> ... analyzers) {
            return this.withAnalyzers(Arrays.asList(analyzers));
        }

        public Builder withAnalyzers(Iterable<Class<? extends ApiAnalyzer>> analyzers) {
            if (this.analyzers == null) {
                this.analyzers = new HashSet<Class<? extends ApiAnalyzer>>();
            }
            for (Class<? extends ApiAnalyzer> a : analyzers) {
                this.analyzers.add(a);
            }
            return this;
        }

        public Builder withReportersFromThreadContextClassLoader() {
            return this.withReporters(ServiceTypeLoader.load(Reporter.class));
        }

        public Builder withReportersFrom(ClassLoader cl) {
            return this.withReporters(ServiceTypeLoader.load(Reporter.class, cl));
        }

        @SafeVarargs
        public final Builder withReporters(Class<? extends Reporter> ... reporters) {
            return this.withReporters(Arrays.asList(reporters));
        }

        public Builder withReporters(Iterable<Class<? extends Reporter>> reporters) {
            if (this.reporters == null) {
                this.reporters = new HashSet<Class<? extends Reporter>>();
            }
            for (Class<? extends Reporter> r : reporters) {
                this.reporters.add(r);
            }
            return this;
        }

        public Builder withTransformsFromThreadContextClassLoader() {
            ServiceTypeLoader<DifferenceTransform> trs;
            ServiceTypeLoader<DifferenceTransform> rtrs = trs = ServiceTypeLoader.load(DifferenceTransform.class);
            return this.withTransforms(rtrs);
        }

        public Builder withTransformsFrom(ClassLoader cl) {
            ServiceTypeLoader<DifferenceTransform> trs;
            ServiceTypeLoader<DifferenceTransform> rtrs = trs = ServiceTypeLoader.load(DifferenceTransform.class, cl);
            return this.withTransforms(rtrs);
        }

        @SafeVarargs
        public final Builder withTransforms(Class<? extends DifferenceTransform<?>> ... transforms) {
            return this.withTransforms(Arrays.asList(transforms));
        }

        public Builder withTransforms(Iterable<Class<? extends DifferenceTransform<?>>> transforms) {
            if (this.transforms == null) {
                this.transforms = new HashSet();
            }
            for (Class<DifferenceTransform<?>> clazz : transforms) {
                this.transforms.add(clazz);
            }
            return this;
        }

        public Builder withFiltersFromThreadContextClassLoader() {
            return this.withFilters(ServiceTypeLoader.load(ElementFilter.class));
        }

        public Builder withFiltersFrom(ClassLoader cl) {
            return this.withFilters(ServiceTypeLoader.load(ElementFilter.class, cl));
        }

        @SafeVarargs
        public final Builder withFilters(Class<? extends ElementFilter> ... filters) {
            return this.withFilters(Arrays.asList(filters));
        }

        public Builder withFilters(Iterable<Class<? extends ElementFilter>> filters) {
            if (this.filters == null) {
                this.filters = new HashSet<Class<? extends ElementFilter>>();
            }
            for (Class<? extends ElementFilter> f : filters) {
                this.filters.add(f);
            }
            return this;
        }

        public Builder withAllExtensionsFromThreadContextClassLoader() {
            return this.withAllExtensionsFrom(Thread.currentThread().getContextClassLoader());
        }

        public Builder withAllExtensionsFrom(ClassLoader cl) {
            return this.withAnalyzersFrom(cl).withFiltersFrom(cl).withReportersFrom(cl).withTransformsFrom(cl);
        }

        public Builder withTransformationBlocks(Set<List<String>> transformationBlocks) {
            this.transformationBlocks = new HashSet<List<String>>(transformationBlocks.size());
            for (List<String> block : transformationBlocks) {
                this.transformationBlocks.add(new ArrayList<String>(block));
            }
            return this;
        }

        public Builder addTransformationBlock(List<String> transformationBlock) {
            if (this.transformationBlocks == null) {
                this.transformationBlocks = new HashSet<List<String>>();
            }
            this.transformationBlocks.add(new ArrayList<String>(transformationBlock));
            return this;
        }

        public Builder withAnalyzerExtensionIdsInclude(List<String> analyzerExtensionIds) {
            this.includedAnalyzerExtensionIds = new ArrayList<String>(analyzerExtensionIds);
            return this;
        }

        public Builder addAnalyzerExtensionIdInclude(String analyzerExtensionId) {
            if (this.includedAnalyzerExtensionIds == null) {
                this.includedAnalyzerExtensionIds = new ArrayList<String>();
            }
            this.includedAnalyzerExtensionIds.add(analyzerExtensionId);
            return this;
        }

        public Builder withAnalyzerExtensionIdsExclude(List<String> analyzerExtensionIds) {
            this.excludedAnalyzerExtensionIds = new ArrayList<String>(analyzerExtensionIds);
            return this;
        }

        public Builder addAnalyzerExtensionIdExclude(String analyzerExtensionId) {
            if (this.excludedAnalyzerExtensionIds == null) {
                this.excludedAnalyzerExtensionIds = new ArrayList<String>();
            }
            this.excludedAnalyzerExtensionIds.add(analyzerExtensionId);
            return this;
        }

        public Builder withReporterExtensionIdsInclude(List<String> reporterExtensionIds) {
            this.includedReporterExtensionIds = new ArrayList<String>(reporterExtensionIds);
            return this;
        }

        public Builder addReporterExtensionIdInclude(String reporterExtensionId) {
            if (this.includedReporterExtensionIds == null) {
                this.includedReporterExtensionIds = new ArrayList<String>();
            }
            this.includedReporterExtensionIds.add(reporterExtensionId);
            return this;
        }

        public Builder withReporterExtensionIdsExclude(List<String> reporterExtensionIds) {
            this.excludedReporterExtensionIds = new ArrayList<String>(reporterExtensionIds);
            return this;
        }

        public Builder addReporterExtensionIdExclude(String reporterExtensionId) {
            if (this.excludedReporterExtensionIds == null) {
                this.excludedReporterExtensionIds = new ArrayList<String>();
            }
            this.excludedReporterExtensionIds.add(reporterExtensionId);
            return this;
        }

        public Builder withTransformExtensionIdsInclude(List<String> transformExtensionIds) {
            this.includedTransformExtensionIds = new ArrayList<String>(transformExtensionIds);
            return this;
        }

        public Builder addTransformExtensionIdInclude(String transformExtensionId) {
            if (this.includedTransformExtensionIds == null) {
                this.includedTransformExtensionIds = new ArrayList<String>();
            }
            this.includedTransformExtensionIds.add(transformExtensionId);
            return this;
        }

        public Builder withTransformExtensionIdsExclude(List<String> transformExtensionIds) {
            this.excludedTransformExtensionIds = new ArrayList<String>(transformExtensionIds);
            return this;
        }

        public Builder addTransformExtensionIdExclude(String transformExtensionId) {
            if (this.excludedTransformExtensionIds == null) {
                this.excludedTransformExtensionIds = new ArrayList<String>();
            }
            this.excludedTransformExtensionIds.add(transformExtensionId);
            return this;
        }

        public Builder withFilterExtensionIdsInclude(List<String> filterExtensionIds) {
            this.includedFilterExtensionIds = new ArrayList<String>(filterExtensionIds);
            return this;
        }

        public Builder addFilterExtensionIdInclude(String filterExtensionId) {
            if (this.includedFilterExtensionIds == null) {
                this.includedFilterExtensionIds = new ArrayList<String>();
            }
            this.includedFilterExtensionIds.add(filterExtensionId);
            return this;
        }

        public Builder withFilterExtensionIdsExclude(List<String> filterExtensionIds) {
            this.excludedFilterExtensionIds = new ArrayList<String>(filterExtensionIds);
            return this;
        }

        public Builder addFilterExtensionIdExclude(String filterExtensionId) {
            if (this.excludedFilterExtensionIds == null) {
                this.excludedFilterExtensionIds = new ArrayList<String>();
            }
            this.excludedFilterExtensionIds.add(filterExtensionId);
            return this;
        }

        public Builder withTransformationBlocks(ModelNode configuration) {
            if (configuration == null || !configuration.isDefined()) {
                return this;
            }
            List blocks = configuration.asList();
            this.transformationBlocks = new HashSet<List<String>>();
            for (ModelNode block : blocks) {
                List ids = block.asList().stream().map(ModelNode::asString).collect(Collectors.toList());
                this.transformationBlocks.add(ids);
            }
            return this;
        }

        public PipelineConfiguration build() throws IllegalStateException {
            this.analyzers = this.analyzers == null ? Collections.emptySet() : this.analyzers;
            this.reporters = this.reporters == null ? Collections.emptySet() : this.reporters;
            this.transforms = this.transforms == null ? Collections.emptySet() : this.transforms;
            this.filters = this.filters == null ? Collections.emptySet() : this.filters;
            this.transformationBlocks = this.transformationBlocks == null ? Collections.emptySet() : this.transformationBlocks;
            this.includedAnalyzerExtensionIds = this.includedAnalyzerExtensionIds == null ? Collections.emptyList() : this.includedAnalyzerExtensionIds;
            this.excludedAnalyzerExtensionIds = this.excludedAnalyzerExtensionIds == null ? Collections.emptyList() : this.excludedAnalyzerExtensionIds;
            this.includedReporterExtensionIds = this.includedReporterExtensionIds == null ? Collections.emptyList() : this.includedReporterExtensionIds;
            this.excludedReporterExtensionIds = this.excludedReporterExtensionIds == null ? Collections.emptyList() : this.excludedReporterExtensionIds;
            this.includedTransformExtensionIds = this.includedTransformExtensionIds == null ? Collections.emptyList() : this.includedTransformExtensionIds;
            this.excludedTransformExtensionIds = this.excludedTransformExtensionIds == null ? Collections.emptyList() : this.excludedTransformExtensionIds;
            this.includedFilterExtensionIds = this.includedFilterExtensionIds == null ? Collections.emptyList() : this.includedFilterExtensionIds;
            this.excludedFilterExtensionIds = this.excludedFilterExtensionIds == null ? Collections.emptyList() : this.excludedFilterExtensionIds;
            return new PipelineConfiguration(this.analyzers, this.reporters, this.transforms, this.filters, this.transformationBlocks, this.includedAnalyzerExtensionIds, this.excludedAnalyzerExtensionIds, this.includedReporterExtensionIds, this.excludedReporterExtensionIds, this.includedTransformExtensionIds, this.excludedTransformExtensionIds, this.includedFilterExtensionIds, this.excludedFilterExtensionIds);
        }
    }
}

