/*
 * Decompiled with CFR 0.152.
 */
package org.revapi;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.revapi.Difference;
import org.revapi.Element;

public final class Report {
    private final List<Difference> differences = new ArrayList<Difference>();
    private final Element oldElement;
    private final Element newElement;

    public static Builder builder() {
        return new Builder();
    }

    public Report(@Nonnull Iterable<Difference> problems, @Nullable Element oldElement, @Nullable Element newElement) {
        for (Difference p : problems) {
            this.differences.add(p);
        }
        this.oldElement = oldElement;
        this.newElement = newElement;
    }

    @Nullable
    public Element getNewElement() {
        return this.newElement;
    }

    @Nullable
    public Element getOldElement() {
        return this.oldElement;
    }

    @Nonnull
    public List<Difference> getDifferences() {
        return this.differences;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Report that = (Report)o;
        if (this.newElement != null ? !this.newElement.equals(that.newElement) : that.newElement != null) {
            return false;
        }
        if (this.oldElement != null ? !this.oldElement.equals(that.oldElement) : that.oldElement != null) {
            return false;
        }
        return this.differences.equals(that.differences);
    }

    public int hashCode() {
        int result = this.differences.hashCode();
        result = 31 * result + (this.oldElement != null ? this.oldElement.hashCode() : 0);
        result = 31 * result + (this.newElement != null ? this.newElement.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MatchReport[");
        sb.append("oldElement=").append(this.oldElement == null ? "null" : this.oldElement.getFullHumanReadableString());
        sb.append(", newElement=").append(this.newElement == null ? "null" : this.newElement.getFullHumanReadableString());
        sb.append(", problems=").append(this.differences);
        sb.append(']');
        return sb.toString();
    }

    public static final class Builder {
        private Element oldElement;
        private Element newElement;
        ArrayList<Difference> differences = new ArrayList();

        @Nonnull
        public Builder withOld(@Nullable Element element) {
            this.oldElement = element;
            return this;
        }

        @Nonnull
        public Builder withNew(@Nullable Element element) {
            this.newElement = element;
            return this;
        }

        @Nonnull
        public Difference.InReportBuilder addProblem() {
            return new Difference.InReportBuilder(this);
        }

        @Nonnull
        public Report build() {
            return new Report(this.differences, this.oldElement, this.newElement);
        }
    }
}

