/*
 * Decompiled with CFR 0.152.
 */
package org.revapi;

import java.lang.reflect.InvocationTargetException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import org.jboss.dmr.ModelNode;
import org.revapi.API;
import org.revapi.AnalysisContext;
import org.revapi.AnalysisResult;
import org.revapi.ApiAnalyzer;
import org.revapi.ArchiveAnalyzer;
import org.revapi.CoIterator;
import org.revapi.CorrespondenceComparatorDeducer;
import org.revapi.Difference;
import org.revapi.DifferenceAnalyzer;
import org.revapi.DifferenceTransform;
import org.revapi.Element;
import org.revapi.ElementFilter;
import org.revapi.ElementForest;
import org.revapi.PipelineConfiguration;
import org.revapi.Report;
import org.revapi.Reporter;
import org.revapi.Stats;
import org.revapi.configuration.Configurable;
import org.revapi.configuration.ConfigurationValidator;
import org.revapi.configuration.ValidationResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Revapi {
    private static final Logger LOG = LoggerFactory.getLogger(Revapi.class);
    static final Logger TIMING_LOG = LoggerFactory.getLogger((String)"revapi.analysis.timing");
    private static final long MAX_TRANSFORMATION_ITERATIONS = 1000000L;
    private final PipelineConfiguration pipelineConfiguration;
    private final ConfigurationValidator configurationValidator;
    private final Map<String, Set<List<DifferenceTransform<?>>>> matchingTransformsCache = new HashMap();

    public Revapi(PipelineConfiguration pipelineConfiguration) {
        this.pipelineConfiguration = pipelineConfiguration;
        this.configurationValidator = new ConfigurationValidator();
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    public ValidationResult validateConfiguration(@Nonnull AnalysisContext analysisContext) {
        ValidationResult validation = ValidationResult.success();
        AnalysisResult.Extensions exts = this.prepareAnalysis(analysisContext);
        validation = this.validate(analysisContext, validation, exts);
        return validation;
    }

    public PipelineConfiguration getPipelineConfiguration() {
        return this.pipelineConfiguration;
    }

    public AnalysisResult.Extensions prepareAnalysis(@Nonnull AnalysisContext analysisContext) {
        Map<AnalysisResult.ExtensionInstance<ElementFilter>, AnalysisContext> filters = this.splitByConfiguration(analysisContext, this.pipelineConfiguration.getFilterTypes(), this.pipelineConfiguration.getIncludedFilterExtensionIds(), this.pipelineConfiguration.getExcludedFilterExtensionIds());
        Map<AnalysisResult.ExtensionInstance<Reporter>, AnalysisContext> reporters = this.splitByConfiguration(analysisContext, this.pipelineConfiguration.getReporterTypes(), this.pipelineConfiguration.getIncludedReporterExtensionIds(), this.pipelineConfiguration.getExcludedReporterExtensionIds());
        Map<AnalysisResult.ExtensionInstance<ApiAnalyzer>, AnalysisContext> analyzers = this.splitByConfiguration(analysisContext, this.pipelineConfiguration.getApiAnalyzerTypes(), this.pipelineConfiguration.getIncludedAnalyzerExtensionIds(), this.pipelineConfiguration.getExcludedAnalyzerExtensionIds());
        Map<AnalysisResult.ExtensionInstance<DifferenceTransform<?>>, AnalysisContext> transforms = this.splitByConfiguration(analysisContext, this.pipelineConfiguration.getTransformTypes(), this.pipelineConfiguration.getIncludedTransformExtensionIds(), this.pipelineConfiguration.getExcludedTransformExtensionIds());
        return new AnalysisResult.Extensions(analyzers, filters, reporters, transforms);
    }

    public AnalysisResult analyze(@Nonnull AnalysisContext analysisContext) {
        TIMING_LOG.debug("Analysis starts");
        AnalysisResult.Extensions extensions = this.prepareAnalysis(analysisContext);
        if (extensions.getAnalyzers().isEmpty()) {
            throw new IllegalArgumentException("At least one analyzer needs to be present. Make sure there is at least one on the classpath and that the extension filters do not exclude all of them.");
        }
        StreamSupport.stream(extensions.spliterator(), false).map(e -> e).forEach(e -> ((Configurable)((AnalysisResult.ExtensionInstance)e.getKey()).getInstance()).initialize((AnalysisContext)e.getValue()));
        AnalysisProgress progress = new AnalysisProgress(extensions, this.pipelineConfiguration);
        TIMING_LOG.debug("Initialization complete.");
        this.matchingTransformsCache.clear();
        Exception error = null;
        try {
            for (AnalysisResult.ExtensionInstance<ApiAnalyzer> ia : extensions.getAnalyzers().keySet()) {
                this.analyzeWith(ia.getInstance(), analysisContext.getOldApi(), analysisContext.getNewApi(), progress);
            }
        }
        catch (Exception t) {
            error = t;
        }
        return new AnalysisResult(error, extensions);
    }

    private <T extends Configurable> Map<AnalysisResult.ExtensionInstance<T>, AnalysisContext> splitByConfiguration(AnalysisContext fullConfig, Set<Class<? extends T>> configurables, List<String> extensionIdIncludes, List<String> extensionIdExcludes) {
        HashMap<AnalysisResult.ExtensionInstance<T>, AnalysisContext> map = new HashMap<AnalysisResult.ExtensionInstance<T>, AnalysisContext>();
        for (Class<T> clazz : configurables) {
            Configurable c = (Configurable)this.instantiate(clazz);
            String extensionId = c.getExtensionId();
            if (extensionId == null) {
                extensionId = "$$%%(@#_)I#@)(*)(#$)(@#$__IMPROBABLE, right??!?!?!";
            }
            if (!extensionIdIncludes.isEmpty() && !extensionIdIncludes.contains(extensionId) || extensionIdExcludes.contains(extensionId)) continue;
            Configurable inst = null;
            boolean configured = false;
            for (ModelNode config : fullConfig.getConfiguration().asList()) {
                String configExtension = config.get("extension").asString();
                if (!extensionId.equals(configExtension)) continue;
                inst = inst == null ? c : (Configurable)this.instantiate(clazz);
                ModelNode idNode = config.get("id");
                String instanceId = idNode.isDefined() ? idNode.asString() : null;
                AnalysisResult.ExtensionInstance<Configurable> key = new AnalysisResult.ExtensionInstance<Configurable>(inst, instanceId);
                map.put(key, fullConfig.copyWithConfiguration(config.get("configuration").clone()));
                configured = true;
            }
            if (configured) continue;
            map.put(new AnalysisResult.ExtensionInstance<Configurable>(c, null), fullConfig.copyWithConfiguration(new ModelNode()));
        }
        return map;
    }

    private ValidationResult validate(@Nonnull AnalysisContext analysisContext, ValidationResult validationResult, AnalysisResult.Extensions configurables) {
        for (Map.Entry<AnalysisResult.ExtensionInstance<?>, AnalysisContext> e : configurables) {
            if (!(e.getKey().getInstance() instanceof Configurable)) continue;
            Configurable c = (Configurable)e.getKey().getInstance();
            ValidationResult partial = this.configurationValidator.validate(analysisContext.getConfiguration(), c);
            validationResult = validationResult.merge(partial);
        }
        return validationResult;
    }

    private void analyzeWith(ApiAnalyzer apiAnalyzer, API oldApi, API newApi, AnalysisProgress progress) throws Exception {
        if (TIMING_LOG.isDebugEnabled()) {
            TIMING_LOG.debug("Commencing analysis using " + apiAnalyzer + " on:\nOld API:\n" + oldApi + "\n\nNew API:\n" + newApi);
        }
        ArchiveAnalyzer oldAnalyzer = apiAnalyzer.getArchiveAnalyzer(oldApi);
        ArchiveAnalyzer newAnalyzer = apiAnalyzer.getArchiveAnalyzer(newApi);
        TIMING_LOG.debug("Obtaining API trees.");
        ElementForest oldTree = oldAnalyzer.analyze();
        ElementForest newTree = newAnalyzer.analyze();
        TIMING_LOG.debug("API trees obtained");
        try (DifferenceAnalyzer elementDifferenceAnalyzer = apiAnalyzer.getDifferenceAnalyzer(oldAnalyzer, newAnalyzer);){
            TIMING_LOG.debug("Obtaining API roots");
            SortedSet<? extends Element> as = oldTree.getRoots();
            SortedSet<? extends Element> bs = newTree.getRoots();
            TIMING_LOG.debug("API roots obtained");
            if (LOG.isDebugEnabled()) {
                LOG.debug("Old tree: {}", (Object)oldTree);
                LOG.debug("New tree: {}", (Object)newTree);
            }
            TIMING_LOG.debug("Opening difference analyzer");
            elementDifferenceAnalyzer.open();
            this.analyze(apiAnalyzer.getCorrespondenceDeducer(), elementDifferenceAnalyzer, as, bs, progress);
            TIMING_LOG.debug("Closing difference analyzer");
        }
        TIMING_LOG.debug("Difference analyzer closed");
    }

    private void analyze(CorrespondenceComparatorDeducer deducer, DifferenceAnalyzer elementDifferenceAnalyzer, SortedSet<? extends Element> as, SortedSet<? extends Element> bs, AnalysisProgress progress) {
        ArrayList<Element> sortedAs = new ArrayList<Element>(as);
        ArrayList<Element> sortedBs = new ArrayList<Element>(bs);
        Stats.of("sorts").start();
        Comparator<? super Element> comp = deducer.sortAndGetCorrespondenceComparator(sortedAs, sortedBs);
        Stats.of("sorts").end(sortedAs, sortedBs);
        CoIterator<? super Element> it = new CoIterator<Element>(sortedAs.iterator(), sortedBs.iterator(), comp);
        while (it.hasNext()) {
            it.next();
            Element a = it.getLeft();
            Element b = it.getRight();
            LOG.trace("Inspecting {} and {}", (Object)a, (Object)b);
            Stats.of("filters").start();
            Set filters = progress.extensions.getFilters().keySet().stream().map(AnalysisResult.ExtensionInstance::getInstance).collect(Collectors.toSet());
            boolean analyzeThis = !(a != null && !Revapi.filtersApply(a, filters) || b != null && !Revapi.filtersApply(b, filters));
            Stats.of("filters").end(a, (Object)b);
            long beginDuration = 0L;
            if (analyzeThis) {
                LOG.trace("Starting analysis of {} and {}.", (Object)a, (Object)b);
                Stats.of("analyses").start();
                Stats.of("analysisBegins").start();
                elementDifferenceAnalyzer.beginAnalysis(a, b);
                Stats.of("analysisBegins").end(a, (Object)b);
                beginDuration = Stats.of("analyses").reset();
            } else {
                LOG.trace("Elements {} and {} were filtered out of analysis.", (Object)a, (Object)b);
            }
            Stats.of("descends").start();
            boolean shouldDescend = a == null || b == null ? !(a != null && !Revapi.filtersDescend(a, filters) || b != null && !Revapi.filtersDescend(b, filters) || !elementDifferenceAnalyzer.isDescendRequired(a, b)) : Revapi.filtersDescend(a, filters) && Revapi.filtersDescend(b, filters);
            Stats.of("descends").end(a, (Object)b);
            if (shouldDescend) {
                LOG.trace("Descending into {}, {} pair.", (Object)a, (Object)b);
                this.analyze(deducer, elementDifferenceAnalyzer, a == null ? Collections.emptySortedSet() : a.getChildren(), b == null ? Collections.emptySortedSet() : b.getChildren(), progress);
            } else {
                LOG.trace("Filters disallowed descending into {} and {}.", (Object)a, (Object)b);
            }
            if (analyzeThis) {
                LOG.trace("Ending the analysis of {} and {}.", (Object)a, (Object)b);
                Stats.of("analyses").start();
                Stats.of("analysisEnds").start();
                Report r = elementDifferenceAnalyzer.endAnalysis(a, b);
                Stats.of("analysisEnds").end(a, (Object)b);
                Stats.of("analyses").end(beginDuration, (Object)new AbstractMap.SimpleEntry<Element, Element>(a, b));
                this.transformAndReport(r, progress);
                continue;
            }
            LOG.trace("Finished the skipped analysis of {} and {}.", (Object)a, (Object)b);
        }
    }

    private <T> T instantiate(Class<? extends T> type) {
        try {
            return type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Failed to instantiate extension: " + type, e);
        }
    }

    @SafeVarargs
    private static <T> Stream<T> concat(Stream<? extends T> ... streams) {
        if (streams.length == 0) {
            return Stream.empty();
        }
        return Revapi.concat(streams[0], streams, 1);
    }

    private static <T> Stream<T> concat(Stream<? extends T> head, Stream<? extends T>[] all, int from) {
        if (from == all.length - 1) {
            return Stream.concat(head, all[from]);
        }
        return Stream.concat(head, Revapi.concat(all[from], all, from + 1));
    }

    private void transformAndReport(Report report, AnalysisProgress progress) {
        boolean listChanged;
        if (report == null) {
            return;
        }
        Stats.of("transforms").start();
        int iteration = 0;
        do {
            listChanged = false;
            ListIterator<Difference> it = report.getDifferences().listIterator();
            ArrayList<Difference> transformed = new ArrayList<Difference>(1);
            while (it.hasNext()) {
                Difference d = it.next();
                transformed.clear();
                boolean differenceChanged = false;
                LOG.debug("Transformation iteration {}", (Object)iteration);
                Iterator<List<DifferenceTransform<Object>>> iterator = this.getTransformsForDifference(d, progress).iterator();
                while (iterator.hasNext()) {
                    List<DifferenceTransform<?>> tb;
                    List<DifferenceTransform<?>> tBlock = tb = iterator.next();
                    Difference td = d;
                    for (DifferenceTransform<?> t : tBlock) {
                        if (td == null) break;
                        try {
                            td = t.transform(report.getOldElement(), report.getNewElement(), td);
                        }
                        catch (Exception e) {
                            LOG.warn("Difference transform " + t + " of class '" + t.getClass() + " threw an exception while processing difference " + d + " on old element " + report.getOldElement() + " and new element " + report.getNewElement(), (Throwable)e);
                        }
                    }
                    if (td == null) {
                        differenceChanged = true;
                        continue;
                    }
                    if (d.equals(td)) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Difference transform(s) {} transform {} to {}", new Object[]{tBlock, d, td});
                    }
                    transformed.add(td);
                    differenceChanged = true;
                }
                if (differenceChanged) {
                    listChanged = true;
                    it.remove();
                    if (!transformed.isEmpty()) {
                        for (Difference td : transformed) {
                            it.add(td);
                            it.previous();
                        }
                    }
                }
                if (++iteration % 1000 == 0) {
                    LOG.warn("Transformation of differences in match report " + report + " has cycled " + iteration + " times. Maybe we're in an infinite loop with differences transforming back and forth?");
                }
                if ((long)iteration != 1000000L) continue;
                throw new IllegalStateException("Transformation failed to settle in 1000000 iterations. This is most probably an error in difference transform configuration that cycles between two or more changes back and forth.");
            }
        } while (listChanged);
        Stats.of("transforms").end(report);
        if (!report.getDifferences().isEmpty()) {
            Stats.of("reports").start();
            for (AnalysisResult.ExtensionInstance<Reporter> ir : progress.extensions.getReporters().keySet()) {
                ir.getInstance().report(report);
            }
            Stats.of("reports").end(report);
        }
    }

    private Set<List<DifferenceTransform<?>>> getTransformsForDifference(Difference diff, AnalysisProgress progress) {
        Set<List<DifferenceTransform<?>>> ret = this.matchingTransformsCache.get(diff.code);
        if (ret == null) {
            ret = new HashSet();
            for (List<DifferenceTransform<?>> ts : progress.transformBlocks) {
                ArrayList actualTs = new ArrayList(ts.size());
                block1: for (DifferenceTransform<?> t : ts) {
                    for (Pattern p : t.getDifferenceCodePatterns()) {
                        if (!p.matcher(diff.code).matches()) continue;
                        actualTs.add(t);
                        continue block1;
                    }
                }
                ret.add(actualTs);
            }
            this.matchingTransformsCache.put(diff.code, ret);
        }
        return ret;
    }

    private static boolean filtersApply(Element element, Iterable<? extends ElementFilter> filters) {
        for (ElementFilter elementFilter : filters) {
            String name = elementFilter.getClass().getName() + ".applies";
            Stats.of(name).start();
            boolean applies = elementFilter.applies(element);
            Stats.of(name).end(element);
            if (applies) continue;
            return false;
        }
        return true;
    }

    private static boolean filtersDescend(Element element, Iterable<? extends ElementFilter> filters) {
        boolean hasNoFilters;
        Iterator<? extends ElementFilter> it = filters.iterator();
        boolean bl = hasNoFilters = !it.hasNext();
        while (it.hasNext()) {
            ElementFilter f = it.next();
            String name = f.getClass().getName() + ".shouldDescendInto";
            Stats.of(name).start();
            boolean should = f.shouldDescendInto(element);
            Stats.of(name).end(element);
            if (!should) continue;
            return true;
        }
        return hasNoFilters;
    }

    private static final class AnalysisProgress {
        final AnalysisResult.Extensions extensions;
        final Set<List<DifferenceTransform<?>>> transformBlocks;

        AnalysisProgress(AnalysisResult.Extensions extensions, PipelineConfiguration configuration) {
            this.extensions = extensions;
            this.transformBlocks = AnalysisProgress.groupTransformsToBlocks(extensions, configuration);
        }

        private static Set<List<DifferenceTransform<?>>> groupTransformsToBlocks(AnalysisResult.Extensions extensions, PipelineConfiguration configuration) {
            HashSet ret = new HashSet();
            HashMap<String, List> transformsById = new HashMap<String, List>();
            Set allTransforms = Collections.newSetFromMap(new IdentityHashMap());
            for (AnalysisResult.ExtensionInstance<DifferenceTransform<?>> extensionInstance : extensions.getTransforms().keySet()) {
                String configurationId = extensionInstance.getId();
                String extensionId = extensionInstance.getInstance().getExtensionId();
                if (configurationId != null) {
                    transformsById.computeIfAbsent(configurationId, __ -> new ArrayList()).add(extensionInstance.getInstance());
                }
                transformsById.computeIfAbsent(extensionId, __ -> new ArrayList()).add(extensionInstance.getInstance());
                allTransforms.add(extensionInstance.getInstance());
            }
            for (List list : configuration.getTransformationBlocks()) {
                ArrayList<DifferenceTransform> ts = new ArrayList<DifferenceTransform>(list.size());
                for (String id : list) {
                    List candidates = (List)transformsById.remove(id);
                    if (candidates == null) {
                        throw new IllegalArgumentException("Unrecognized id in the transformation block configuration: " + id);
                    }
                    if (candidates.isEmpty()) {
                        throw new IllegalArgumentException("There is no transform with extension id or explicit id '" + id + "'. Please fix the pipeline configuration.");
                    }
                    if (candidates.size() > 1) {
                        throw new IllegalArgumentException("There is more than 1 transform with extension id or explicit id '" + id + "'. Please fix the pipeline configuration and use unique ids for extension configurations.");
                    }
                    DifferenceTransform t3 = (DifferenceTransform)candidates.get(0);
                    ts.add(t3);
                    allTransforms.remove(t3);
                }
                ret.add(ts);
            }
            allTransforms.forEach(t -> ret.add(Collections.singletonList(t)));
            return ret;
        }
    }

    public static final class Builder {
        private final PipelineConfiguration.Builder pb = PipelineConfiguration.builder();

        @Nonnull
        public Builder withAnalyzersFromThreadContextClassLoader() {
            this.pb.withAnalyzersFromThreadContextClassLoader();
            return this;
        }

        @Nonnull
        public Builder withAnalyzersFrom(@Nonnull ClassLoader cl) {
            this.pb.withAnalyzersFrom(cl);
            return this;
        }

        @SafeVarargs
        @Nonnull
        public final Builder withAnalyzers(Class<? extends ApiAnalyzer> ... analyzers) {
            this.pb.withAnalyzers(analyzers);
            return this;
        }

        @Nonnull
        public Builder withAnalyzers(@Nonnull Iterable<Class<? extends ApiAnalyzer>> analyzers) {
            this.pb.withAnalyzers(analyzers);
            return this;
        }

        @Nonnull
        public Builder withReportersFromThreadContextClassLoader() {
            this.pb.withReportersFromThreadContextClassLoader();
            return this;
        }

        @Nonnull
        public Builder withReportersFrom(@Nonnull ClassLoader cl) {
            this.pb.withReportersFrom(cl);
            return this;
        }

        @SafeVarargs
        @Nonnull
        public final Builder withReporters(Class<? extends Reporter> ... reporters) {
            this.pb.withReporters(reporters);
            return this;
        }

        @Nonnull
        public Builder withReporters(@Nonnull Iterable<Class<? extends Reporter>> reporters) {
            this.pb.withReporters(reporters);
            return this;
        }

        @Nonnull
        public Builder withTransformsFromThreadContextClassLoader() {
            this.pb.withTransformsFromThreadContextClassLoader();
            return this;
        }

        @Nonnull
        public Builder withTransformsFrom(@Nonnull ClassLoader cl) {
            this.pb.withTransformsFrom(cl);
            return this;
        }

        @SafeVarargs
        @Nonnull
        public final Builder withTransforms(Class<? extends DifferenceTransform<?>> ... transforms) {
            this.pb.withTransforms(transforms);
            return this;
        }

        @Nonnull
        public Builder withTransforms(@Nonnull Iterable<Class<? extends DifferenceTransform<?>>> transforms) {
            this.pb.withTransforms(transforms);
            return this;
        }

        @Nonnull
        public Builder withFiltersFromThreadContextClassLoader() {
            this.pb.withFiltersFromThreadContextClassLoader();
            return this;
        }

        @Nonnull
        public Builder withFiltersFrom(@Nonnull ClassLoader cl) {
            this.pb.withFiltersFrom(cl);
            return this;
        }

        @SafeVarargs
        @Nonnull
        public final Builder withFilters(Class<? extends ElementFilter> ... filters) {
            this.pb.withFilters(filters);
            return this;
        }

        @Nonnull
        public Builder withFilters(@Nonnull Iterable<Class<? extends ElementFilter>> filters) {
            this.pb.withFilters(filters);
            return this;
        }

        @Nonnull
        public Builder withAllExtensionsFromThreadContextClassLoader() {
            this.pb.withAllExtensionsFromThreadContextClassLoader();
            return this;
        }

        @Nonnull
        public Builder withAllExtensionsFrom(@Nonnull ClassLoader cl) {
            this.pb.withAllExtensionsFrom(cl);
            return this;
        }

        public Builder withTransformationBlocks(Set<List<String>> blocks) {
            this.pb.withTransformationBlocks(blocks);
            return this;
        }

        public Builder addTransformationBlock(List<String> block) {
            this.pb.addTransformationBlock(block);
            return this;
        }

        @Nonnull
        public Revapi build() throws IllegalStateException {
            return new Revapi(this.pb.build());
        }
    }
}

