/*
 * Decompiled with CFR 0.152.
 */
package org.revapi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceConfigurationError;

public final class ServiceTypeLoader<T>
implements Iterable<Class<? extends T>> {
    private static final String PREFIX = "META-INF/services/";
    private final ClassLoader classLoader;
    private final Class<T> serviceType;
    private List<Class<? extends T>> cache;

    private ServiceTypeLoader(ClassLoader classLoader, Class<T> serviceType) {
        this.classLoader = classLoader;
        this.serviceType = serviceType;
    }

    public static <X> ServiceTypeLoader<X> load(Class<X> serviceType, ClassLoader cl) {
        return new ServiceTypeLoader<X>(cl, serviceType);
    }

    public static <X> ServiceTypeLoader<X> load(Class<X> serviceType) {
        return ServiceTypeLoader.load(serviceType, Thread.currentThread().getContextClassLoader());
    }

    public void reload() {
        this.cache = null;
    }

    @Override
    public Iterator<Class<? extends T>> iterator() {
        if (this.cache == null) {
            this.load();
        }
        return this.cache.iterator();
    }

    private void load() throws ServiceConfigurationError {
        Enumeration<URL> resources;
        this.cache = new ArrayList<Class<? extends T>>();
        String serviceFileLocation = PREFIX + this.serviceType.getName();
        try {
            resources = this.classLoader == null ? ClassLoader.getSystemResources(serviceFileLocation) : this.classLoader.getResources(serviceFileLocation);
        }
        catch (IOException e) {
            throw new ServiceConfigurationError(this.serviceType.getName() + ": Failed to load service configuration file.");
        }
        while (resources.hasMoreElements()) {
            URL resourceFile = resources.nextElement();
            String line = null;
            int lineNum = 0;
            try {
                BufferedReader in = new BufferedReader(new InputStreamReader(resourceFile.openStream()));
                Throwable throwable = null;
                try {
                    while ((line = in.readLine()) != null) {
                        ++lineNum;
                        int hashIdx = line.indexOf(35);
                        if (hashIdx >= 0) {
                            line = line.substring(0, hashIdx);
                        }
                        if ((line = line.trim()).isEmpty()) continue;
                        this.cache.add(Class.forName(line, false, this.classLoader));
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    in.close();
                }
            }
            catch (IOException e) {
                throw new ServiceConfigurationError(this.serviceType.getName() + ": " + resourceFile + "Failed to read service configuration file.", e);
            }
            catch (ClassNotFoundException e) {
                throw new ServiceConfigurationError(this.serviceType.getName() + ": " + resourceFile + ":" + lineNum + ": Class not found: " + line, e);
            }
            catch (ClassCastException e) {
                throw new ServiceConfigurationError(this.serviceType.getName() + ": " + resourceFile + ":" + lineNum + ": Class doesn't implement service interface: " + line, e);
            }
        }
    }
}

