/*
 * Decompiled with CFR 0.152.
 */
package org.revapi;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.revapi.Revapi;

public final class Stats {
    private static final Map<String, Collector> COLLECTORS = new TreeMap<String, Collector>();

    private Stats() {
    }

    public static Collector of(String stat) {
        if (!Revapi.TIMING_LOG.isDebugEnabled()) {
            return DummyCollector.INSTANCE;
        }
        Collector ret = COLLECTORS.get(stat);
        if (ret == null) {
            ret = new Collector();
            COLLECTORS.put(stat, ret);
        }
        return ret;
    }

    public static String asString() {
        Map map = COLLECTORS.entrySet().stream().sorted((e1, e2) -> (int)(((Collector)e2.getValue()).totalTime - ((Collector)e1.getValue()).totalTime)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (m1, m2) -> m1, LinkedHashMap::new));
        StringBuilder bld = new StringBuilder("Stats:");
        if (map.isEmpty()) {
            return bld.append(" <none>").toString();
        }
        for (Map.Entry e : map.entrySet()) {
            bld.append('\n').append((String)e.getKey()).append(": ").append(e.getValue());
        }
        return bld.toString();
    }

    private static final class Tuple2 {
        private final Object a;
        private final Object b;

        private Tuple2(Object a, Object b) {
            this.a = a;
            this.b = b;
        }

        public String toString() {
            return "[" + this.a + ", " + this.b + "]";
        }
    }

    private static final class DummyCollector
    extends Collector {
        static final DummyCollector INSTANCE = new DummyCollector();

        private DummyCollector() {
        }

        @Override
        public void end(long additionalDuration, Object cause) {
        }

        @Override
        public void end(long additionalDuration, Object cause1, Object cause2) {
        }

        @Override
        public void end(Object cause) {
        }

        @Override
        public void end(Object cause1, Object cause2) {
        }

        @Override
        public long reset() {
            return 0L;
        }

        @Override
        public long start() {
            return 0L;
        }
    }

    public static class Collector {
        volatile long occurrences;
        volatile long totalTime;
        volatile long currentStartTime;
        volatile long worstTime;
        volatile Object offender;

        private Collector() {
        }

        public long start() {
            this.currentStartTime = System.currentTimeMillis();
            return this.currentStartTime;
        }

        public void end(Object cause) {
            this.end(0L, cause);
        }

        public void end(Object cause1, Object cause2) {
            this.end(0L, (Object)new Tuple2(cause1, cause2));
        }

        public void end(long additionalDuration, Object cause) {
            long duration = System.currentTimeMillis() - this.currentStartTime + additionalDuration;
            this.totalTime += duration;
            ++this.occurrences;
            if (duration > this.worstTime) {
                this.worstTime = duration;
                this.offender = cause;
            }
        }

        public void end(long additionalDuration, Object cause1, Object cause2) {
            this.end(additionalDuration, (Object)new Tuple2(cause1, cause2));
        }

        public long reset() {
            return System.currentTimeMillis() - this.currentStartTime;
        }

        public String toString() {
            return "{occurrences = " + this.occurrences + ", total = " + this.totalTime + "ms, average = " + String.format("%.2fms", (double)this.totalTime / (double)this.occurrences) + ", worstTime = " + this.worstTime + "ms caused by " + this.offender + "}";
        }
    }
}

