/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.configuration;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.ref.WeakReference;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import org.jboss.dmr.ModelNode;
import org.revapi.configuration.Configurable;
import org.revapi.configuration.ConfigurationException;
import org.revapi.configuration.JSONUtil;
import org.revapi.configuration.ValidationResult;

public final class ConfigurationValidator {
    private WeakReference<ScriptEngine> jsEngine;

    public ValidationResult validate(@Nonnull ModelNode fullConfiguration, @Nonnull Configurable configurable) throws ConfigurationException {
        try {
            switch (fullConfiguration.getType()) {
                case LIST: {
                    return this._validate(fullConfiguration, configurable);
                }
                case UNDEFINED: {
                    return ValidationResult.success();
                }
            }
            throw new ConfigurationException("Expecting a JSON array as the configuration object.");
        }
        catch (IOException | ScriptException e) {
            throw new ConfigurationException("Failed to validate configuration.", e);
        }
    }

    public ValidationResult validate(@Nonnull ModelNode extensionConfiguration, @Nonnull ModelNode configurationSchema) throws ConfigurationException {
        try {
            StringWriter output = new StringWriter();
            ScriptEngine js = this.getJsEngine(output);
            String schema = configurationSchema.toJSONString(true);
            String config = extensionConfiguration.toJSONString(true);
            Bindings variables = js.createBindings();
            js.eval("var data = " + config + ";", variables);
            try {
                js.eval("var schema = " + schema + ";", variables);
            }
            catch (ScriptException e) {
                throw new IllegalArgumentException("Failed to parse the schema: " + schema, e);
            }
            variables.put("tv4", js.getContext().getAttribute("tv4", 200));
            Object resultObject = js.eval("tv4.validateMultiple(data, schema)", variables);
            ModelNode result = JSONUtil.toModelNode(resultObject);
            PartialValidationResult r = new PartialValidationResult("/", result);
            return this.convert(Collections.singletonList(r));
        }
        catch (IOException | ScriptException e) {
            throw new ConfigurationException("Failed to validate configuration.", e);
        }
    }

    private ValidationResult _validate(ModelNode fullConfiguration, Configurable configurable) throws IOException, ScriptException {
        String schema;
        String extensionId = configurable.getExtensionId();
        if (extensionId == null) {
            return ValidationResult.success();
        }
        StringWriter output = new StringWriter();
        ScriptEngine js = this.getJsEngine(output);
        ArrayList<PartialValidationResult> validationResults = new ArrayList<PartialValidationResult>();
        Reader rdr = configurable.getJSONSchema();
        Object object = null;
        try {
            if (rdr == null) {
                ValidationResult validationResult = ValidationResult.success();
                return validationResult;
            }
            schema = ConfigurationValidator.read(rdr);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (rdr != null) {
                if (object != null) {
                    try {
                        rdr.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    rdr.close();
                }
            }
        }
        int idx = 0;
        for (ModelNode extensionConfig : fullConfiguration.asList()) {
            ModelNode currentExtensionId = extensionConfig.get("extension");
            if (!currentExtensionId.isDefined()) {
                throw new ConfigurationException("Found invalid configuration object without \"extension\" identifier.");
            }
            if (!extensionId.equals(currentExtensionId.asString())) {
                ++idx;
                continue;
            }
            ModelNode currentConfig = extensionConfig.get("configuration");
            StringWriter configJSONWrt = new StringWriter();
            PrintWriter wrt = new PrintWriter(configJSONWrt);
            currentConfig.writeJSONString(wrt, true);
            String config = configJSONWrt.toString();
            Bindings variables = js.createBindings();
            js.eval("var data = " + config + ";", variables);
            try {
                js.eval("var schema = " + schema + ";", variables);
            }
            catch (ScriptException e) {
                throw new IllegalArgumentException("Failed to parse the schema: " + schema, e);
            }
            variables.put("tv4", js.getContext().getAttribute("tv4", 200));
            Object resultObject = js.eval("tv4.validateMultiple(data, schema)", variables);
            ModelNode result = JSONUtil.toModelNode(resultObject);
            PartialValidationResult r = new PartialValidationResult("[" + idx + "].configuration", result);
            validationResults.add(r);
            ++idx;
        }
        return this.convert(validationResults);
    }

    private ValidationResult convert(List<PartialValidationResult> results) {
        ModelNode result = new ModelNode();
        for (PartialValidationResult r : results) {
            if (r.results.has("errors")) {
                List errors = r.results.get("errors").asList();
                for (ModelNode error : errors) {
                    if (!error.has("dataPath")) continue;
                    error.get("dataPath").set("/" + r.rootPath.replace(".", "/") + error.get("dataPath").asString());
                }
            }
            boolean valid = r.results.get("valid").asBoolean() && (!result.has("valid") || result.get("valid").asBoolean());
            result.get("valid").set(valid);
            if (result.has("errors")) {
                for (ModelNode e : r.results.get("errors").asList()) {
                    result.get("errors").add(e);
                }
            } else {
                result.get("errors").set(r.results.get("errors"));
            }
            if (result.has("missing")) {
                for (ModelNode m : r.results.get("missing").asList()) {
                    result.get("missing").add(m.asString());
                }
                continue;
            }
            result.get("missing").set(r.results.get("missing"));
        }
        return result.isDefined() ? ValidationResult.fromTv4Results(result) : new ValidationResult(null, null);
    }

    private ScriptEngine getJsEngine(Writer output) throws IOException, ScriptException {
        ScriptEngine ret = null;
        if (this.jsEngine != null) {
            ret = (ScriptEngine)this.jsEngine.get();
        }
        if (ret == null) {
            ret = new ScriptEngineManager().getEngineByName("javascript");
            SimpleScriptContext ctx = new SimpleScriptContext();
            Bindings globalScope = ret.createBindings();
            ctx.setBindings(globalScope, 200);
            this.initTv4(ret, globalScope);
            ret.setContext(ctx);
            this.jsEngine = new WeakReference<ScriptEngine>(ret);
        }
        ret.getContext().setWriter(output);
        ret.getContext().setErrorWriter(output);
        return ret;
    }

    private void initTv4(ScriptEngine engine, Bindings bindings) throws IOException, ScriptException {
        try (InputStreamReader rdr = new InputStreamReader(this.getClass().getResourceAsStream("/tv4.min.js"), Charset.forName("UTF-8"));){
            engine.eval((Reader)rdr, bindings);
        }
    }

    private static String read(Reader rdr) throws IOException {
        int cnt;
        StringBuilder bld = new StringBuilder();
        char[] buffer = new char[4096];
        while ((cnt = rdr.read(buffer)) != -1) {
            bld.append(buffer, 0, cnt);
        }
        return bld.toString();
    }

    private static class PartialValidationResult {
        final String rootPath;
        final ModelNode results;

        private PartialValidationResult(String rootPath, ModelNode results) {
            this.rootPath = rootPath;
            this.results = results;
        }
    }
}

