/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.configuration;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.jboss.dmr.ModelNode;
import org.revapi.configuration.ReaderInputStream;

public final class JSONUtil {
    private JSONUtil() {
    }

    public static InputStream stripComments(InputStream json, Charset charset) {
        Reader rdr = JSONUtil.stripComments(new InputStreamReader(json, Charset.forName("UTF-8")));
        return new ReaderInputStream(rdr, charset);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String stripComments(String json) {
        try (Reader rdr = JSONUtil.stripComments(new StringReader(json));){
            int cnt;
            StringBuilder bld = new StringBuilder();
            char[] buf = new char[1024];
            while ((cnt = rdr.read(buf)) != -1) {
                bld.append(buf, 0, cnt);
            }
            String string = bld.toString();
            return string;
        }
        catch (IOException e) {
            throw new AssertionError("IOException in StringReader? I thought that was impossible!", e);
        }
    }

    public static Reader stripComments(final Reader json) {
        return new Reader(){
            State state = State.NORMAL;
            int lastChar = -1;

            @Override
            public int read() throws IOException {
                int emit;
                while (true) {
                    boolean cont = true;
                    emit = this.lastChar;
                    block0 : switch (this.state) {
                        case NORMAL: {
                            switch (this.lastChar) {
                                case 47: {
                                    this.state = State.FIRST_SLASH;
                                    break block0;
                                }
                                case 34: {
                                    this.state = State.IN_STRING;
                                }
                            }
                            if (this.lastChar == -1) break;
                            this.lastChar = -1;
                            cont = false;
                            break;
                        }
                        case FIRST_SLASH: {
                            switch (this.lastChar) {
                                case 47: {
                                    this.state = State.SINGLE_LINE;
                                    break block0;
                                }
                                case 42: {
                                    this.state = State.MULTI_LINE;
                                    break block0;
                                }
                                case 34: {
                                    emit = 47;
                                    this.state = State.IN_STRING;
                                    break block0;
                                }
                            }
                            emit = 47;
                            this.state = State.NORMAL;
                            cont = false;
                            break;
                        }
                        case SINGLE_LINE: {
                            switch (this.lastChar) {
                                case 10: {
                                    this.state = State.NORMAL;
                                    this.lastChar = -1;
                                    cont = false;
                                    break block0;
                                }
                            }
                            break;
                        }
                        case MULTI_LINE: {
                            switch (this.lastChar) {
                                case 42: {
                                    this.state = State.STAR_IN_MULTI_LINE;
                                }
                            }
                            break;
                        }
                        case STAR_IN_MULTI_LINE: {
                            switch (this.lastChar) {
                                case 47: {
                                    this.state = State.NORMAL;
                                }
                            }
                            break;
                        }
                        case IN_STRING: {
                            switch (this.lastChar) {
                                case 92: {
                                    this.state = State.ESCAPE_IN_STRING;
                                    break;
                                }
                                case 34: {
                                    this.state = State.NORMAL;
                                }
                            }
                            if (this.lastChar == -1) break;
                            cont = false;
                            this.lastChar = -1;
                            break;
                        }
                        case ESCAPE_IN_STRING: {
                            if (this.lastChar == -1) break;
                            cont = false;
                            this.lastChar = -1;
                            this.state = State.IN_STRING;
                        }
                    }
                    if (!cont) break;
                    int ci = json.read();
                    if (ci == -1) {
                        this.lastChar = -1;
                        switch (this.state) {
                            case SINGLE_LINE: 
                            case MULTI_LINE: 
                            case STAR_IN_MULTI_LINE: {
                                return -1;
                            }
                        }
                        return emit;
                    }
                    this.lastChar = ci;
                }
                return emit;
            }

            @Override
            public int read(@Nonnull char[] cbuf, int off, int len) throws IOException {
                for (int i = 0; i < len; ++i) {
                    int c = this.read();
                    if (c == -1) {
                        return i == 0 ? -1 : i;
                    }
                    cbuf[off + i] = (char)c;
                }
                return len;
            }

            @Override
            public void close() throws IOException {
                json.close();
            }
        };
    }

    public static String stringifyJavascriptObject(Object object) {
        StringBuilder bld = new StringBuilder();
        JSONUtil.stringify(object, bld);
        return bld.toString();
    }

    public static ModelNode toModelNode(Object object) {
        ModelNode ret = new ModelNode();
        if (object instanceof Map) {
            ret.setEmptyObject();
            for (Map.Entry e : ((Map)object).entrySet()) {
                String key = e.getKey().toString();
                try {
                    int idx = Integer.parseInt(key);
                    if (!ret.has(0)) {
                        boolean isMap = false;
                        try {
                            ret.keys();
                        }
                        catch (IllegalArgumentException ignored) {
                            isMap = true;
                        }
                        if (isMap) {
                            throw new IllegalArgumentException("Mixed javascript list and object not supported.");
                        }
                        ret.setEmptyList();
                    }
                    ret.get(idx).set(JSONUtil.toModelNode(e.getValue()));
                }
                catch (NumberFormatException ignored) {
                    ret.get(e.getKey().toString()).set(JSONUtil.toModelNode(e.getValue()));
                }
            }
        } else if (object instanceof List) {
            ret.setEmptyList();
            for (Object o : (List)object) {
                ret.add(JSONUtil.toModelNode(o));
            }
        } else if (object instanceof Integer) {
            ret.set(((Integer)object).intValue());
        } else if (object instanceof Double) {
            ret.set(((Double)object).doubleValue());
        } else if (object instanceof Boolean) {
            ret.set(((Boolean)object).booleanValue());
        } else if (object instanceof Long) {
            ret.set(((Long)object).longValue());
        } else if (object instanceof String) {
            ret.set((String)object);
        } else if (object instanceof BigDecimal) {
            ret.set((BigDecimal)object);
        } else if (object instanceof BigInteger) {
            ret.set((BigInteger)object);
        } else if (object != null) {
            ret.set(object.toString());
        }
        return ret;
    }

    private static void stringify(Object object, StringBuilder bld) {
        if (object instanceof Map) {
            Map.Entry e;
            bld.append("{");
            Iterator it = ((Map)object).entrySet().iterator();
            if (it.hasNext()) {
                e = it.next();
                bld.append("\"").append(e.getKey()).append("\":");
                JSONUtil.stringify(e.getValue(), bld);
            }
            while (it.hasNext()) {
                bld.append(",");
                e = it.next();
                bld.append("\"").append(e.getKey()).append("\":");
                JSONUtil.stringify(e.getValue(), bld);
            }
            bld.append("}");
        } else if (object instanceof List) {
            bld.append("[");
            Iterator it = ((List)object).iterator();
            if (it.hasNext()) {
                JSONUtil.stringify(it.next(), bld);
            }
            while (it.hasNext()) {
                bld.append(",");
                JSONUtil.stringify(it.next(), bld);
            }
            bld.append("]");
        } else if (object == null) {
            bld.append("null");
        } else {
            bld.append(object.toString());
        }
    }

    private static enum State {
        NORMAL,
        FIRST_SLASH,
        SINGLE_LINE,
        MULTI_LINE,
        STAR_IN_MULTI_LINE,
        IN_STRING,
        ESCAPE_IN_STRING;

    }
}

