/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.configuration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import javax.annotation.Nullable;
import org.jboss.dmr.ModelNode;

public final class ValidationResult {
    private final String[] missingSchemas;
    private final Error[] errors;

    public static ValidationResult success() {
        return new ValidationResult(null, null);
    }

    public ValidationResult(@Nullable String[] missingSchemas, @Nullable Error[] errors) {
        this.missingSchemas = missingSchemas;
        this.errors = errors;
    }

    static ValidationResult fromTv4Results(ModelNode tv4ResultJSON) {
        Error[] errorsA;
        String[] missingSchemasA;
        if (tv4ResultJSON.get("valid").asBoolean()) {
            return ValidationResult.success();
        }
        ArrayList<String> missingSchemas = new ArrayList<String>();
        for (Object missing : tv4ResultJSON.get("missing").asList()) {
            missingSchemas.add(missing.asString());
        }
        ArrayList<Error> errors = new ArrayList<Error>();
        for (ModelNode error : tv4ResultJSON.get("errors").asList()) {
            int code = error.get("code").asInt();
            String message = error.get("message").asString();
            String dataPath = error.get("dataPath").asString();
            errors.add(new Error(code, message, dataPath));
        }
        String[] stringArray = missingSchemasA = missingSchemas.isEmpty() ? null : new String[missingSchemas.size()];
        if (missingSchemasA != null) {
            missingSchemasA = missingSchemas.toArray(missingSchemasA);
        }
        Error[] errorArray = errorsA = errors.isEmpty() ? null : new Error[errors.size()];
        if (errorsA != null) {
            errorsA = errors.toArray(errorsA);
        }
        return new ValidationResult(missingSchemasA, errorsA);
    }

    public ValidationResult merge(ValidationResult other) {
        HashSet<Error> newErrors;
        HashSet<String> newMissingSchemas;
        if (this.missingSchemas == null && this.errors == null) {
            return other;
        }
        if (other.missingSchemas == null && other.errors == null) {
            return this;
        }
        HashSet<String> hashSet = newMissingSchemas = this.missingSchemas == null ? null : new HashSet<String>(Arrays.asList(this.missingSchemas));
        if (other.missingSchemas != null) {
            if (newMissingSchemas == null) {
                newMissingSchemas = new HashSet();
            }
            newMissingSchemas.addAll(Arrays.asList(other.missingSchemas));
        }
        String[] retMissingSchemas = newMissingSchemas == null ? null : newMissingSchemas.toArray(new String[newMissingSchemas.size()]);
        HashSet<Error> hashSet2 = newErrors = this.errors == null ? null : new HashSet<Error>(Arrays.asList(this.errors));
        if (other.errors != null) {
            if (newErrors == null) {
                newErrors = new HashSet();
            }
            newErrors.addAll(Arrays.asList(other.errors));
        }
        Error[] retErrors = newErrors == null ? null : newErrors.toArray(new Error[newErrors.size()]);
        return new ValidationResult(retMissingSchemas, retErrors);
    }

    @Nullable
    public String[] getMissingSchemas() {
        return this.missingSchemas;
    }

    @Nullable
    public Error[] getErrors() {
        return this.errors;
    }

    public boolean isSuccessful() {
        return this.missingSchemas == null && this.errors == null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ValidationResult[");
        sb.append("errors=").append(Arrays.toString(this.errors));
        sb.append(", missingSchemas=").append(Arrays.toString(this.missingSchemas));
        sb.append(']');
        return sb.toString();
    }

    public static final class Error {
        public final int code;
        public final String message;
        public final String dataPath;

        public Error(int code, String message, String dataPath) {
            this.code = code;
            this.message = message;
            this.dataPath = dataPath;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Error error = (Error)o;
            if (this.code != error.code) {
                return false;
            }
            if (!this.dataPath.equals(error.dataPath)) {
                return false;
            }
            return this.message.equals(error.message);
        }

        public int hashCode() {
            int result = this.code;
            result = 31 * result + this.message.hashCode();
            result = 31 * result + this.dataPath.hashCode();
            return result;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Error[");
            sb.append("code=").append(this.code);
            sb.append(", dataPath='").append(this.dataPath).append('\'');
            sb.append(", message='").append(this.message).append('\'');
            sb.append(']');
            return sb.toString();
        }
    }
}

