/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.query;

import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.revapi.Element;
import org.revapi.query.Filter;

public class DFSFilteringIterator<E extends Element>
implements Iterator<E> {
    private final Class<? extends E> resultClass;
    private final Deque<Iterator<? extends Element>> dfsStack = new LinkedList<Iterator<? extends Element>>();
    private final Filter<? super E> filter;
    private E current;

    public DFSFilteringIterator(@Nonnull Iterator<? extends Element> rootIterator, @Nonnull Class<? extends E> resultClass, @Nullable Filter<? super E> filter) {
        this.dfsStack.push(rootIterator);
        this.resultClass = resultClass;
        this.filter = filter;
    }

    @Override
    public boolean hasNext() {
        if (this.current != null) {
            return true;
        }
        block0: while (true) {
            boolean descend;
            if (!this.dfsStack.isEmpty() && !this.dfsStack.peek().hasNext()) {
                this.dfsStack.pop();
                continue;
            }
            if (this.dfsStack.isEmpty()) {
                return false;
            }
            Iterator<? extends Element> currentIterator = this.dfsStack.peek();
            do {
                Iterator childIterator;
                if (!currentIterator.hasNext()) continue block0;
                Element next = currentIterator.next();
                while (next == null && currentIterator.hasNext()) {
                    next = currentIterator.next();
                }
                if (next == null) continue block0;
                boolean found = false;
                if (this.resultClass.isAssignableFrom(next.getClass())) {
                    Element cur = (Element)this.resultClass.cast(next);
                    if (this.filter == null || this.filter.applies(cur)) {
                        this.current = cur;
                        found = true;
                    }
                }
                boolean bl = descend = this.filter == null || this.filter.shouldDescendInto(next);
                if (descend && (childIterator = next.getChildren().iterator()).hasNext()) {
                    this.dfsStack.push(childIterator);
                }
                if (!found) continue;
                return true;
            } while (!descend);
        }
    }

    @Override
    public E next() {
        if (this.current == null && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        E ret = this.current;
        this.current = null;
        return ret;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

