/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.query;

import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.revapi.query.Filter;

public class FilteringIterator<E>
implements Iterator<E> {
    private final Class<E> resultType;
    private final Iterator<?> wrapped;
    private final Filter<? super E> filter;
    private E current;

    public FilteringIterator(@Nonnull Iterator<?> iterator, @Nonnull Class<E> resultType, @Nullable Filter<? super E> filter) {
        this.wrapped = iterator;
        this.filter = filter;
        this.resultType = resultType;
    }

    @Override
    public boolean hasNext() {
        if (this.current != null) {
            return this.wrapped.hasNext();
        }
        while (this.wrapped.hasNext()) {
            Object next = this.wrapped.next();
            if (next == null || !this.resultType.isAssignableFrom(next.getClass())) continue;
            E cur = this.resultType.cast(next);
            if (this.filter != null && !this.filter.applies(cur)) continue;
            this.current = cur;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public E next() {
        if (this.current == null && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        E ret = this.current;
        this.current = null;
        return ret;
    }

    @Override
    public void remove() {
        this.wrapped.remove();
    }
}

