/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.simple;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.revapi.Element;
import org.revapi.query.DFSFilteringIterator;
import org.revapi.query.Filter;
import org.revapi.query.FilteringIterator;

public abstract class SimpleElement
implements Element,
Cloneable {
    private Element parent;
    private SortedSet<Element> children;

    public SimpleElement clone() {
        try {
            SimpleElement ret = (SimpleElement)super.clone();
            ret.parent = null;
            ret.children = null;
            return ret;
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("All simple elements need to be cloneable.", e);
        }
    }

    @Override
    @Nonnull
    public SortedSet<? extends Element> getChildren() {
        if (this.children == null) {
            this.children = new ParentPreservingSet(this.newChildrenInstance());
        }
        return this.children;
    }

    @Nonnull
    protected SortedSet<Element> newChildrenInstance() {
        return new TreeSet<Element>();
    }

    @Override
    @Nullable
    public Element getParent() {
        return this.parent;
    }

    @Override
    public void setParent(@Nullable Element parent) {
        this.parent = parent;
    }

    @Override
    @Nonnull
    public final <T extends Element> List<T> searchChildren(@Nonnull Class<T> resultType, boolean recurse, @Nullable Filter<? super T> filter) {
        ArrayList results = new ArrayList();
        this.searchChildren(results, resultType, recurse, filter);
        return results;
    }

    @Override
    public final <T extends Element> void searchChildren(@Nonnull List<T> results, @Nonnull Class<T> resultType, boolean recurse, @Nullable Filter<? super T> filter) {
        for (Element element : this.getChildren()) {
            if (resultType.isAssignableFrom(element.getClass())) {
                Element te = (Element)resultType.cast(element);
                if (filter == null || filter.applies(te)) {
                    results.add(te);
                }
            }
            if (!recurse || filter != null && !filter.shouldDescendInto(element)) continue;
            element.searchChildren(results, resultType, true, filter);
        }
    }

    @Override
    @Nonnull
    public String getFullHumanReadableString() {
        return this.toString();
    }

    @Override
    @Nonnull
    public <T extends Element> Iterator<T> iterateOverChildren(@Nonnull Class<T> resultType, boolean recurse, @Nullable Filter<? super T> filter) {
        if (this.children == null) {
            return new EmptyIterator();
        }
        return recurse ? new DFSFilteringIterator<T>(this.getChildren().iterator(), resultType, filter) : new FilteringIterator<T>(this.getChildren().iterator(), resultType, filter);
    }

    @Nonnull
    protected <T extends Element> List<T> getDirectChildrenOfType(@Nonnull Class<T> type) {
        return this.searchChildren(type, false, null);
    }

    private class ParentPreservingSet
    implements SortedSet<Element> {
        private final SortedSet<Element> set;

        private ParentPreservingSet(SortedSet<Element> set) {
            this.set = set;
        }

        @Override
        public boolean add(Element element) {
            boolean ret = this.set.add(element);
            if (ret) {
                element.setParent(SimpleElement.this);
            }
            return ret;
        }

        @Override
        public boolean addAll(@Nonnull Collection<? extends Element> c) {
            for (Element element : c) {
                this.add(element);
            }
            return !c.isEmpty();
        }

        @Override
        public void clear() {
            for (Element e : this) {
                e.setParent(null);
            }
            this.set.clear();
        }

        @Override
        public int size() {
            return this.set.size();
        }

        @Override
        public boolean isEmpty() {
            return this.set.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.set.contains(o);
        }

        @Override
        @Nonnull
        public Iterator<Element> iterator() {
            return new ParentPreservingIterator(this.set.iterator());
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            return this.set.toArray();
        }

        @Override
        @Nonnull
        public <T> T[] toArray(@Nonnull T[] a) {
            return this.set.toArray(a);
        }

        @Override
        public boolean remove(Object o) {
            Iterator<Element> it = this.iterator();
            while (it.hasNext()) {
                Element e = it.next();
                if ((o != null || e != null) && (o == null || !o.equals(e))) continue;
                it.remove();
                if (e != null) {
                    e.setParent(null);
                }
                return true;
            }
            return false;
        }

        @Override
        public boolean containsAll(@Nonnull Collection<?> c) {
            return this.set.containsAll(c);
        }

        @Override
        public boolean removeAll(@Nonnull Collection<?> c) {
            boolean ret = false;
            for (Object o : c) {
                ret |= this.remove(o);
            }
            return ret;
        }

        @Override
        public boolean retainAll(@Nonnull Collection<?> c) {
            boolean ret = false;
            for (Object o : c) {
                if (this.contains(o)) continue;
                ret = true;
                this.remove(o);
            }
            return ret;
        }

        @Override
        public Comparator<? super Element> comparator() {
            return this.set.comparator();
        }

        @Override
        @Nonnull
        public SortedSet<Element> subSet(Element fromElement, Element toElement) {
            return this.set.subSet(fromElement, toElement);
        }

        @Override
        @Nonnull
        public SortedSet<Element> headSet(Element toElement) {
            return this.set.headSet(toElement);
        }

        @Override
        @Nonnull
        public SortedSet<Element> tailSet(Element fromElement) {
            return this.set.tailSet(fromElement);
        }

        @Override
        public Element first() {
            return this.set.first();
        }

        @Override
        public Element last() {
            return this.set.last();
        }

        private class ParentPreservingIterator
        implements Iterator<Element> {
            private final Iterator<Element> it;
            Element last;

            private ParentPreservingIterator(Iterator<Element> it) {
                this.it = it;
            }

            @Override
            public boolean hasNext() {
                return this.it.hasNext();
            }

            @Override
            public Element next() {
                this.last = this.it.next();
                return this.last;
            }

            @Override
            public void remove() {
                if (this.last != null) {
                    this.last.setParent(null);
                }
                this.it.remove();
            }
        }
    }

    private static class EmptyIterator<E>
    implements Iterator<E> {
        private EmptyIterator() {
        }

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public E next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new IllegalStateException();
        }
    }
}

