/*
 * Decompiled with CFR 0.152.
 */
package org.revapi.simple;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.revapi.API;
import org.revapi.Element;
import org.revapi.ElementForest;
import org.revapi.query.Filter;
import org.revapi.simple.SimpleElement;

public class SimpleElementForest
implements ElementForest {
    private SortedSet<? extends SimpleElement> roots;
    private final API api;

    protected SimpleElementForest(@Nonnull API api) {
        this.api = api;
    }

    @Override
    @Nonnull
    public API getApi() {
        return this.api;
    }

    @Nonnull
    public SortedSet<? extends SimpleElement> getRoots() {
        if (this.roots == null) {
            this.roots = new TreeSet<SimpleElement>();
        }
        return this.roots;
    }

    @Override
    @Nonnull
    public <T extends Element> List<T> search(@Nonnull Class<T> resultType, boolean recurse, @Nullable Filter<? super T> filter, @Nullable Element root) {
        ArrayList results = new ArrayList();
        this.search(results, resultType, root == null ? this.getRoots() : root.getChildren(), recurse, filter);
        return results;
    }

    public <T extends Element> void search(@Nonnull List<T> results, @Nonnull Class<T> resultType, @Nonnull SortedSet<? extends Element> currentLevel, boolean recurse, @Nullable Filter<? super T> filter) {
        for (Element element : currentLevel) {
            if (resultType.isAssignableFrom(element.getClass())) {
                Element te = element;
                if (filter == null || filter.applies(te)) {
                    results.add(te);
                }
            }
            if (!recurse || filter != null && !filter.shouldDescendInto(element)) continue;
            this.search(results, resultType, element.getChildren(), true, filter);
        }
    }

    public String toString() {
        StringBuilder bld = new StringBuilder(this.getClass().getSimpleName());
        this.addToString(bld, 1, this.getRoots());
        return bld.toString();
    }

    private void addToString(StringBuilder bld, int indent, SortedSet<? extends Element> elements) {
        for (Element element : elements) {
            bld.append("\n");
            for (int i = 0; i < indent; ++i) {
                bld.append("    ");
            }
            bld.append(element.toString());
            this.addToString(bld, indent + 1, element.getChildren());
        }
    }
}

