/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.byteman;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.byteman.agent.submit.Submit;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.content.PackageDetailsKey;
import org.rhq.core.domain.content.PackageType;
import org.rhq.core.domain.content.transfer.ContentResponseResult;
import org.rhq.core.domain.content.transfer.DeployIndividualPackageResponse;
import org.rhq.core.domain.content.transfer.DeployPackageStep;
import org.rhq.core.domain.content.transfer.DeployPackagesResponse;
import org.rhq.core.domain.content.transfer.RemoveIndividualPackageResponse;
import org.rhq.core.domain.content.transfer.RemovePackagesResponse;
import org.rhq.core.domain.content.transfer.ResourcePackageDetails;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.resource.CreateResourceStatus;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.content.ContentContext;
import org.rhq.core.pluginapi.content.ContentFacet;
import org.rhq.core.pluginapi.content.ContentServices;
import org.rhq.core.pluginapi.inventory.CreateChildResourceFacet;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.core.util.MessageDigestGenerator;
import org.rhq.core.util.exception.ThrowableUtil;
import org.rhq.plugins.byteman.BytemanAgentDiscoveryComponent;

public class BytemanAgentComponent
implements ResourceComponent<BytemanAgentComponent>,
MeasurementFacet,
OperationFacet,
ContentFacet,
CreateChildResourceFacet,
ConfigurationFacet {
    private static final String PKG_TYPE_NAME_BOOT_JAR = "bootJar";
    private static final String PKG_TYPE_NAME_SYSTEM_JAR = "systemJar";
    private final Log log = LogFactory.getLog(BytemanAgentComponent.class);
    private ResourceContext<BytemanAgentComponent> resourceContext;
    private Submit bytemanClient;
    private File bootJarsDataDir;
    private File systemJarsDataDir;
    private File scriptsDataDir;
    private Map<String, String> allKnownScripts;

    public void start(ResourceContext<BytemanAgentComponent> context) {
        this.resourceContext = context;
        this.bootJarsDataDir = this.getResourceDataDirectory("boot");
        this.systemJarsDataDir = this.getResourceDataDirectory("system");
        this.scriptsDataDir = this.getResourceDataDirectory("script");
        this.getBytemanClient();
        try {
            this.addDeployedClasspathJars();
        }
        catch (Throwable t) {
            this.log.warn((Object)"Failed to add managed classpath jars to the byteman agent - is it up?", t);
        }
        this.getAvailability();
    }

    public void stop() {
        this.resourceContext = null;
        this.bytemanClient = null;
        this.allKnownScripts = null;
    }

    public AvailabilityType getAvailability() {
        try {
            this.allKnownScripts = this.getBytemanClient().getAllScripts();
            return AvailabilityType.UP;
        }
        catch (Exception e) {
            this.allKnownScripts = null;
            return AvailabilityType.DOWN;
        }
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests) {
        Submit client = this.getBytemanClient();
        Map allScripts = null;
        for (MeasurementScheduleRequest request : requests) {
            String name = request.getName();
            try {
                List loadedJars;
                if (name.equals("TRAIT-clientVersion")) {
                    String clientVersion = client.getClientVersion();
                    report.addData(new MeasurementDataTrait(request, clientVersion));
                    continue;
                }
                if (name.equals("totalNumberOfScripts")) {
                    int total = 0;
                    if (allScripts == null) {
                        allScripts = client.getAllScripts();
                    }
                    if (allScripts != null) {
                        total += allScripts.size();
                    }
                    report.addData(new MeasurementDataNumeric(request, Double.valueOf(total)));
                    continue;
                }
                if (name.equals("totalNumberOfRules")) {
                    int total = 0;
                    if (allScripts == null) {
                        allScripts = client.getAllScripts();
                    }
                    if (allScripts != null) {
                        for (String script : allScripts.values()) {
                            total += client.splitAllRulesFromScript(script).size();
                        }
                    }
                    report.addData(new MeasurementDataNumeric(request, Double.valueOf(total)));
                    continue;
                }
                if (name.equals("totalNumberOfBootJars")) {
                    int total = 0;
                    loadedJars = client.getLoadedBootClassloaderJars();
                    if (loadedJars != null) {
                        total = loadedJars.size();
                    }
                    report.addData(new MeasurementDataNumeric(request, Double.valueOf(total)));
                    continue;
                }
                if (name.equals("totalNumberOfSystemJars")) {
                    int total = 0;
                    loadedJars = client.getLoadedSystemClassloaderJars();
                    if (loadedJars != null) {
                        total = loadedJars.size();
                    }
                    report.addData(new MeasurementDataNumeric(request, Double.valueOf(total)));
                    continue;
                }
                throw new Exception("cannot collect unknown metric");
            }
            catch (Exception e) {
                this.log.error((Object)("Failed to obtain measurement [" + name + "]. Cause: " + e));
            }
        }
    }

    public Configuration loadResourceConfiguration() throws Exception {
        Properties props = this.getBytemanClient().listSystemProperties();
        Configuration config = new Configuration();
        PropertyList list = new PropertyList("bytemanSystemProperties");
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String name = entry.getKey().toString();
            if (!name.startsWith("org.jboss.byteman.")) continue;
            PropertyMap map = new PropertyMap("bytemanSystemProperty");
            map.put((Property)new PropertySimple("name", (Object)name));
            map.put((Property)new PropertySimple("value", (Object)entry.getValue().toString()));
            list.add((Property)map);
        }
        if (list.getList().size() > 0) {
            config.put((Property)list);
        }
        return config;
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        try {
            Properties propsToSet = new Properties();
            Configuration config = report.getConfiguration();
            PropertyList list = config.getList("bytemanSystemProperties");
            List maps = list.getList();
            for (Property map : maps) {
                Map nameValue = ((PropertyMap)map).getMap();
                String name = ((PropertySimple)nameValue.get("name")).getStringValue();
                if (!name.startsWith("org.jboss.byteman.")) continue;
                String value = ((PropertySimple)nameValue.get("value")).getStringValue();
                if (name.equals("org.jboss.byteman.sysprops.strict") && !value.equals("true")) continue;
                propsToSet.put(name, value);
            }
            this.getBytemanClient().setSystemProperties(propsToSet);
            this.log.info((Object)("Set byteman configuration: " + propsToSet));
            report.setStatus(ConfigurationUpdateStatus.SUCCESS);
        }
        catch (Exception e) {
            report.setErrorMessageFromThrowable((Throwable)e);
        }
    }

    public OperationResult invokeOperation(String name, Configuration configuration) {
        OperationResult result = new OperationResult();
        Submit client = this.getBytemanClient();
        try {
            if ("getRule".equals(name)) {
                String ruleName = configuration.getSimpleValue("ruleName", null);
                if (ruleName == null || ruleName.length() == 0) {
                    throw new Exception("Did not specify the name of the rule to get");
                }
                Map allScripts = client.getAllScripts();
                for (String script : allScripts.values()) {
                    List rules = client.splitAllRulesFromScript(script);
                    for (String rule : rules) {
                        if (!ruleName.equals(client.determineRuleName(rule))) continue;
                        Configuration resultConfig = result.getComplexResults();
                        resultConfig.put((Property)new PropertySimple("ruleDefinition", (Object)rule));
                        return result;
                    }
                }
                throw new Exception("No rule was found with the name [" + ruleName + "]");
            }
            if ("getClientVersion".equals(name)) {
                String clientVersion = client.getClientVersion();
                Configuration resultConfig = result.getComplexResults();
                resultConfig.put((Property)new PropertySimple("version", (Object)(clientVersion == null ? "<unknown>" : clientVersion)));
                return result;
            }
            if ("addJarsToSystemClasspath".equals(name)) {
                String jarPaths = configuration.getSimpleValue("jarPathnames", null);
                if (jarPaths == null || jarPaths.length() == 0) {
                    throw new Exception("Did not specify any jars to add");
                }
                String[] jarPathsArr = jarPaths.split(",");
                ArrayList<String> jarPathList = new ArrayList<String>();
                for (String jarPathString : jarPathsArr) {
                    jarPathList.add(jarPathString);
                }
                String response = client.addJarsToSystemClassloader(jarPathList);
                result.setSimpleResult(response);
                return result;
            }
            if ("addJarsToBootClasspath".equals(name)) {
                String jarPaths = configuration.getSimpleValue("jarPathnames", null);
                if (jarPaths == null || jarPaths.length() == 0) {
                    throw new Exception("Did not specify any jars to add");
                }
                String[] jarPathsArr = jarPaths.split(",");
                ArrayList<String> jarPathList = new ArrayList<String>();
                for (String jarPathString : jarPathsArr) {
                    jarPathList.add(jarPathString);
                }
                String response = client.addJarsToBootClassloader(jarPathList);
                result.setSimpleResult(response);
                return result;
            }
            if ("getAddedClasspathJars".equals(name)) {
                PropertyMap map;
                PropertyList list;
                Configuration resultConfig = result.getComplexResults();
                List jars = client.getLoadedBootClassloaderJars();
                if (jars != null && !jars.isEmpty()) {
                    list = new PropertyList("additionalBootClasspathJars");
                    for (String jar : jars) {
                        map = new PropertyMap("additionalBootClasspathJar");
                        map.put((Property)new PropertySimple("jarPathname", (Object)jar));
                        list.add((Property)map);
                    }
                    resultConfig.put((Property)list);
                }
                if ((jars = client.getLoadedSystemClassloaderJars()) != null && !jars.isEmpty()) {
                    list = new PropertyList("additionalSystemClasspathJars");
                    for (String jar : jars) {
                        map = new PropertyMap("additionalSystemClasspathJar");
                        map.put((Property)new PropertySimple("jarPathname", (Object)jar));
                        list.add((Property)map);
                    }
                    resultConfig.put((Property)list);
                }
                return result;
            }
            throw new UnsupportedOperationException(name);
        }
        catch (Exception e) {
            result.setErrorMessage(ThrowableUtil.getAllMessages((Throwable)e));
            return result;
        }
    }

    public Set<ResourcePackageDetails> discoverDeployedPackages(PackageType type) {
        HashSet<ResourcePackageDetails> details;
        block10: {
            details = new HashSet<ResourcePackageDetails>();
            String typeName = type.getName();
            try {
                File dataDir;
                File[] discoveredFiles = null;
                if (PKG_TYPE_NAME_BOOT_JAR.equals(typeName)) {
                    dataDir = this.bootJarsDataDir;
                } else if (PKG_TYPE_NAME_SYSTEM_JAR.equals(typeName)) {
                    dataDir = this.systemJarsDataDir;
                } else {
                    throw new UnsupportedOperationException("Can only deploy boot/system jars");
                }
                File[] files = dataDir.listFiles();
                if (files != null && files.length > 0) {
                    discoveredFiles = files;
                }
                if (discoveredFiles == null) break block10;
                for (File file : discoveredFiles) {
                    String sha256;
                    String shortName;
                    block11: {
                        shortName = file.getName();
                        sha256 = null;
                        try {
                            sha256 = new MessageDigestGenerator("SHA-256").calcDigestString(file);
                        }
                        catch (Exception e) {
                            if (!this.log.isDebugEnabled()) break block11;
                            this.log.debug((Object)("Failed to generate sha256 for [" + file + "]"));
                        }
                    }
                    String version = this.getVersion(file, sha256);
                    PackageDetailsKey detailsKey = new PackageDetailsKey(shortName, version, typeName, "noarch");
                    ResourcePackageDetails detail = new ResourcePackageDetails(detailsKey);
                    detail.setDisplayName(shortName);
                    detail.setFileCreatedDate(Long.valueOf(file.lastModified()));
                    detail.setFileName(shortName);
                    detail.setFileSize(Long.valueOf(file.length()));
                    detail.setMD5(MessageDigestGenerator.getDigestString((File)file));
                    detail.setSHA256(sha256);
                    details.add(detail);
                }
            }
            catch (Exception e) {
                this.log.error((Object)("Failed to perform discovery for packages of type [" + typeName + "]"), (Throwable)e);
            }
        }
        return details;
    }

    private String getVersion(File file, String sha256) {
        String manifestVersion;
        String version;
        block7: {
            version = "0";
            manifestVersion = null;
            try {
                manifestVersion = BytemanAgentDiscoveryComponent.getJarAttribute(file.getAbsolutePath(), Attributes.Name.IMPLEMENTATION_VERSION.toString(), null);
            }
            catch (Exception e) {
                if (!this.log.isDebugEnabled()) break block7;
                this.log.debug((Object)("Failed to determine manifestVersion for [" + file + "]"));
            }
        }
        if (null != manifestVersion && null != sha256) {
            version = manifestVersion + " [sha256=" + sha256 + "]";
        } else if (null != sha256) {
            version = "[sha256=" + sha256 + "]";
        } else if (null != manifestVersion) {
            version = manifestVersion;
        }
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeployPackagesResponse deployPackages(Set<ResourcePackageDetails> packages, ContentServices contentServices) {
        Submit client = this.getBytemanClient();
        DeployPackagesResponse response = new DeployPackagesResponse();
        for (ResourcePackageDetails detail : packages) {
            PackageDetailsKey packageKey = detail.getKey();
            String packageType = detail.getPackageTypeName();
            DeployIndividualPackageResponse individualResponse = new DeployIndividualPackageResponse(packageKey);
            response.addPackageResponse(individualResponse);
            try {
                Boolean isBootJar = null;
                if (PKG_TYPE_NAME_BOOT_JAR.equals(packageType)) {
                    this.bootJarsDataDir.mkdirs();
                    isBootJar = Boolean.TRUE;
                } else if (PKG_TYPE_NAME_SYSTEM_JAR.equals(packageType)) {
                    this.systemJarsDataDir.mkdirs();
                    isBootJar = Boolean.FALSE;
                } else {
                    throw new UnsupportedOperationException("Cannot deploy package of type [" + packageType + "]");
                }
                File newFile = this.getPackageFile(detail);
                FileOutputStream fos = new FileOutputStream(newFile);
                try {
                    ContentContext contentContext = this.resourceContext.getContentContext();
                    contentServices.downloadPackageBits(contentContext, packageKey, (OutputStream)fos, true);
                }
                finally {
                    fos.close();
                }
                if (isBootJar != null) {
                    if (isBootJar.booleanValue()) {
                        client.addJarsToBootClassloader(Arrays.asList(newFile.getAbsolutePath()));
                    } else {
                        client.addJarsToSystemClassloader(Arrays.asList(newFile.getAbsolutePath()));
                    }
                }
                individualResponse.setResult(ContentResponseResult.SUCCESS);
            }
            catch (Exception e) {
                individualResponse.setErrorMessage(ThrowableUtil.getStackAsString((Throwable)e));
                individualResponse.setResult(ContentResponseResult.FAILURE);
            }
        }
        return response;
    }

    public InputStream retrievePackageBits(ResourcePackageDetails packageDetails) {
        try {
            File file = this.getPackageFile(packageDetails);
            return new FileInputStream(file);
        }
        catch (Exception e) {
            this.log.error((Object)("Cannot retrieve content for package [" + packageDetails + "]"));
            throw new RuntimeException(e);
        }
    }

    public List<DeployPackageStep> generateInstallationSteps(ResourcePackageDetails packageDetails) {
        return new ArrayList<DeployPackageStep>(0);
    }

    public RemovePackagesResponse removePackages(Set<ResourcePackageDetails> packages) {
        RemovePackagesResponse response = new RemovePackagesResponse();
        for (ResourcePackageDetails detail : packages) {
            RemoveIndividualPackageResponse individualResponse = new RemoveIndividualPackageResponse(detail.getKey());
            response.addPackageResponse(individualResponse);
            try {
                File packageFile = this.getPackageFile(detail);
                if (packageFile.delete()) {
                    individualResponse.setResult(ContentResponseResult.SUCCESS);
                    continue;
                }
                individualResponse.setErrorMessage("Failed to delete [" + packageFile.getAbsolutePath() + "]");
                individualResponse.setResult(ContentResponseResult.FAILURE);
            }
            catch (Exception e) {
                individualResponse.setErrorMessage(ThrowableUtil.getStackAsString((Throwable)e));
                individualResponse.setResult(ContentResponseResult.FAILURE);
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CreateResourceReport createResource(CreateResourceReport report) {
        try {
            this.scriptsDataDir.mkdirs();
            ResourcePackageDetails newDetails = report.getPackageDetails();
            String newName = report.getUserSpecifiedResourceName();
            if (newName == null && (newName = newDetails.getName()) == null) {
                throw new NullPointerException("was not given a name for the new script");
            }
            newName = newName.replace('/', '-').replace('\\', '-');
            File newFile = new File(this.scriptsDataDir, newName);
            String newFileAbsolutePath = newFile.getAbsolutePath();
            ContentContext contentContext = this.resourceContext.getContentContext();
            ContentServices contentServices = contentContext.getContentServices();
            ResourceType newChildResourceType = report.getResourceType();
            FileOutputStream fos = new FileOutputStream(newFile);
            BufferedOutputStream outputStream = new BufferedOutputStream(fos);
            try {
                contentServices.downloadPackageBitsForChildResource(contentContext, newChildResourceType.getName(), newDetails.getKey(), (OutputStream)outputStream);
            }
            finally {
                outputStream.close();
            }
            this.getBytemanClient().addRulesFromFiles(Arrays.asList(newFileAbsolutePath));
            newDetails.setDisplayName(newName);
            newDetails.setFileName(newFileAbsolutePath);
            newDetails.setFileSize(Long.valueOf(newFile.length()));
            newDetails.setInstallationTimestamp(newFile.lastModified());
            newDetails.setMD5(MessageDigestGenerator.getDigestString((File)newFile));
            report.setResourceKey(newFileAbsolutePath);
            report.setResourceName(newName);
            report.setStatus(CreateResourceStatus.SUCCESS);
        }
        catch (Throwable t) {
            this.log.error((Object)("Failed to create child resource [" + report + "]"), t);
            report.setException(t);
            report.setStatus(CreateResourceStatus.FAILURE);
        }
        return report;
    }

    public Submit getBytemanClient() {
        if (this.bytemanClient == null) {
            Configuration pc = this.resourceContext.getPluginConfiguration();
            String address = pc.getSimpleValue("listenerAddress", null);
            String port = pc.getSimpleValue("listenerPort", null);
            this.bytemanClient = new Submit(address, Integer.valueOf(port).intValue());
        }
        return this.bytemanClient;
    }

    public Map<String, String> getAllKnownScripts() {
        if (this.allKnownScripts == null) {
            try {
                this.allKnownScripts = this.getBytemanClient().getAllScripts();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.allKnownScripts;
    }

    public File getPackageFile(ResourcePackageDetails packageDetails) throws Exception {
        File file;
        String path = packageDetails.getFileName();
        if (path == null) {
            path = packageDetails.getName();
        }
        if (!(file = new File(path)).isAbsolute()) {
            String typeName = packageDetails.getPackageTypeName();
            if (PKG_TYPE_NAME_BOOT_JAR.equals(typeName)) {
                file = new File(this.bootJarsDataDir, path);
            } else if (PKG_TYPE_NAME_SYSTEM_JAR.equals(typeName)) {
                file = new File(this.systemJarsDataDir, path);
            } else if ("bytemanScript".equals(typeName)) {
                file = new File(this.scriptsDataDir, path);
            } else {
                throw new Exception("Invalid package type - cannot get package file");
            }
        }
        return file;
    }

    public File getBootJarsDataDirectory() {
        return this.bootJarsDataDir;
    }

    public File getSystemJarsDataDirectory() {
        return this.systemJarsDataDir;
    }

    public File getScriptsDataDirectory() {
        return this.scriptsDataDir;
    }

    public File getResourceDataDirectory(String suffix) {
        File pluginDataDir = this.resourceContext.getDataDirectory();
        File resourceDataDir = new File(pluginDataDir, this.resourceContext.getResourceKey().replace(":", "-"));
        if (suffix != null) {
            resourceDataDir = new File(resourceDataDir, suffix);
        }
        return resourceDataDir;
    }

    protected void addDeployedClasspathJars() throws Exception {
        List loadedJars;
        Submit client = this.getBytemanClient();
        ArrayList<String> paths = new ArrayList<String>();
        File dataDir = this.bootJarsDataDir;
        File[] files = dataDir.listFiles();
        if (files != null && files.length > 0) {
            loadedJars = client.getLoadedBootClassloaderJars();
            for (File file : files) {
                if (loadedJars.contains(file.getAbsolutePath())) continue;
                paths.add(file.getAbsolutePath());
            }
            client.addJarsToBootClassloader(paths);
        }
        paths.clear();
        dataDir = this.systemJarsDataDir;
        files = dataDir.listFiles();
        if (files != null && files.length > 0) {
            loadedJars = client.getLoadedSystemClassloaderJars();
            for (File file : files) {
                if (loadedJars.contains(file.getAbsolutePath())) continue;
                paths.add(file.getAbsolutePath());
            }
            client.addJarsToSystemClassloader(paths);
        }
    }
}

