/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.hosts;

import java.io.File;
import java.util.Date;
import java.util.List;
import net.augeas.Augeas;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;

public class HostsComponent
implements ResourceComponent,
ConfigurationFacet {
    private ResourceContext resourceContext;
    private File hostsFile;

    public void start(ResourceContext resourceContext) throws InvalidPluginConfigurationException, Exception {
        this.resourceContext = resourceContext;
        Configuration pluginConfiguration = resourceContext.getPluginConfiguration();
        PropertySimple hostsPathProperty = pluginConfiguration.getSimple("hosts-path");
        if (hostsPathProperty == null) {
            throw new InvalidPluginConfigurationException("Hosts path not found in the plugin configuration, cannot start resource component");
        }
        String hostsPath = hostsPathProperty.getStringValue();
        this.hostsFile = new File(hostsPath);
        if (!this.hostsFile.exists()) {
            throw new InvalidPluginConfigurationException("Hosts file not found at specified location: " + hostsPath);
        }
    }

    public void stop() {
    }

    public AvailabilityType getAvailability() {
        if (this.hostsFile == null) {
            return AvailabilityType.DOWN;
        }
        return this.hostsFile.exists() ? AvailabilityType.UP : AvailabilityType.DOWN;
    }

    public Configuration loadResourceConfiguration() throws Exception {
        Configuration pluginConfiguration = this.resourceContext.getPluginConfiguration();
        return this.loadResourceConfiguration(pluginConfiguration);
    }

    public Configuration loadResourceConfiguration(Configuration pluginConfiguration) throws Exception {
        PropertySimple lensesPathProperty = pluginConfiguration.getSimple("lenses-path");
        if (lensesPathProperty == null) {
            throw new Exception("Lenses path not found in plugin configuration, cannot retrieve configuration");
        }
        PropertySimple rootPathProperty = pluginConfiguration.getSimple("root-path");
        if (rootPathProperty == null) {
            throw new Exception("Root path not found in plugin configuration, cannot retrieve configuration");
        }
        String lensesPath = lensesPathProperty.getStringValue();
        String rootPath = rootPathProperty.getStringValue();
        Augeas augeas = new Augeas(rootPath, lensesPath);
        PropertySimple augeasTreeNodeProperty = pluginConfiguration.getSimple("augeas-hosts-path");
        if (augeasTreeNodeProperty == null) {
            throw new Exception("Augeas tree node not specified for hosts, cannot retrive configuration");
        }
        String hostsTreeNode = augeasTreeNodeProperty.getStringValue();
        List matches = augeas.match(hostsTreeNode);
        if (matches.size() == 0) {
            throw new Exception("Unable to load hosts data from augeas");
        }
        Configuration configuration = new Configuration();
        configuration.setNotes("Loaded from Augeas at " + new Date());
        PropertyList entriesList = new PropertyList("hostEntries");
        configuration.put((Property)entriesList);
        for (String entryNode : matches) {
            String ip = augeas.get(entryNode + "/ipaddr");
            String canonical = augeas.get(entryNode + "/canonical");
            PropertyMap entry = new PropertyMap("hostEntry");
            entry.put((Property)new PropertySimple("ip", (Object)ip));
            entry.put((Property)new PropertySimple("canonical", (Object)canonical));
            entriesList.add((Property)entry);
        }
        return configuration;
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
    }
}

