/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.system.ProcessInfo;
import org.rhq.modules.plugins.jbossas7.AS7Mode;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class AbstractBaseDiscovery<T extends ResourceComponent<?>>
implements ResourceDiscoveryComponent<T> {
    static final String DORG_JBOSS_BOOT_LOG_FILE = "-Dorg.jboss.boot.log.file=";
    private static final String DJBOSS_SERVER_HOME_DIR = "-Djboss.home.dir";
    static final int DEFAULT_MGMT_PORT = 9990;
    private static final String JBOSS_AS_PREFIX = "jboss-as-";
    protected Document hostXml;
    protected final Log log = LogFactory.getLog(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readStandaloneOrHostXml(ProcessInfo processInfo, boolean isDomainMode) {
        String hostXmlFile = this.getHostXmlFileLocation(processInfo, isDomainMode);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            FileInputStream is = new FileInputStream(hostXmlFile);
            try {
                this.hostXml = builder.parse(is);
            }
            finally {
                ((InputStream)is).close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    String getHomeDirFromCommandLine(String[] commandLine) {
        for (String line : commandLine) {
            if (!line.startsWith(DJBOSS_SERVER_HOME_DIR)) continue;
            return line.substring(DJBOSS_SERVER_HOME_DIR.length() + 1);
        }
        return "";
    }

    String getLogFileFromCommandLine(String[] commandLine) {
        for (String line : commandLine) {
            if (!line.startsWith(DORG_JBOSS_BOOT_LOG_FILE)) continue;
            return line.substring(DORG_JBOSS_BOOT_LOG_FILE.length());
        }
        return "";
    }

    protected HostPort getManagementPortFromHostXml(String[] commandLine) {
        if (this.hostXml == null) {
            throw new IllegalArgumentException("hostXml is null. You need to call 'readStandaloneOrHostXml' first.");
        }
        Element host = this.hostXml.getDocumentElement();
        NodeList interfaceParent = host.getElementsByTagName("management-interfaces");
        if (interfaceParent == null || interfaceParent.getLength() == 0) {
            this.log.warn((Object)"No <management-interfaces> found in host.xml");
            return new HostPort();
        }
        NodeList mgmtInterfaces = interfaceParent.item(0).getChildNodes();
        if (mgmtInterfaces == null || mgmtInterfaces.getLength() == 0) {
            this.log.warn((Object)"No <*-interface> found in host.xml");
            return new HostPort();
        }
        for (int i = 0; i < mgmtInterfaces.getLength(); ++i) {
            Element mgmtInterface;
            if (!(mgmtInterfaces.item(i) instanceof Element) || !(mgmtInterface = (Element)mgmtInterfaces.item(i)).getNodeName().equals("http-interface")) continue;
            String tmp = mgmtInterface.getAttribute("port");
            int port = Integer.valueOf(tmp);
            HostPort hp = new HostPort();
            hp.isLocal = true;
            hp.port = port;
            String nIf = mgmtInterface.getAttribute("interface");
            hp.host = this.getInterface(nIf, commandLine);
            return hp;
        }
        return new HostPort();
    }

    private String getInterface(String nIf, String[] commandLine) {
        if (this.hostXml == null) {
            throw new IllegalArgumentException("hostXml is null. You need to call 'readStandaloneOrHostXml' first.");
        }
        Element host = this.hostXml.getDocumentElement();
        NodeList interfaceParent = host.getElementsByTagName("interfaces");
        if (interfaceParent == null || interfaceParent.getLength() == 0) {
            this.log.warn((Object)"No <interfaces> found in host.xml");
            return null;
        }
        NodeList mgmtInterfaces = interfaceParent.item(0).getChildNodes();
        if (mgmtInterfaces == null || mgmtInterfaces.getLength() == 0) {
            this.log.warn((Object)"No <*-interface> found in host.xml");
            return null;
        }
        for (int i = 0; i < mgmtInterfaces.getLength(); ++i) {
            NodeList nl;
            String name;
            Element mgmtInterface;
            if (!(mgmtInterfaces.item(i) instanceof Element) || !(mgmtInterface = (Element)mgmtInterfaces.item(i)).getNodeName().equals("interface") || !(name = mgmtInterface.getAttribute("name")).equals(nIf) || (nl = mgmtInterface.getChildNodes()) == null) continue;
            for (int j = 0; j < nl.getLength(); ++j) {
                if (!(nl.item(j) instanceof Element)) continue;
                String nodeName = nl.item(j).getNodeName();
                if (nodeName.equals("any-ipv4-address")) {
                    return "0.0.0.0";
                }
                String value = ((Element)nl.item(j)).getAttribute("value");
                value = this.replaceExpression(value, commandLine);
                return value;
            }
        }
        return null;
    }

    private String replaceExpression(String value, String[] commandLine) {
        String expression;
        if (!value.contains("${")) {
            return value;
        }
        value = value.substring(2, value.length() - 1);
        String fallback = "localhost";
        if (value.contains(":")) {
            int i = value.indexOf(":");
            expression = value.substring(0, i);
            fallback = value.substring(i + 1);
        } else {
            expression = value;
        }
        String ret = null;
        for (String line : commandLine) {
            if (!line.contains("-bmanagement") && !line.contains("jboss.bind.address.management")) continue;
            ret = line.substring(line.indexOf("=") + 1);
            break;
        }
        if (ret == null) {
            ret = fallback;
        }
        return ret;
    }

    protected String findHostName() {
        if (this.hostXml == null) {
            throw new IllegalArgumentException("hostXml is null. You need to call 'readStandaloneOrHostXml' first.");
        }
        String hostName = this.hostXml.getDocumentElement().getAttribute("name");
        return hostName;
    }

    protected HostPort getDomainControllerFromHostXml() {
        if (this.hostXml == null) {
            throw new IllegalArgumentException("hostXml is null. You need to call 'readStandaloneOrHostXml' first.");
        }
        Element host = this.hostXml.getDocumentElement();
        NodeList dcParent = host.getElementsByTagName("domain-controller");
        if (dcParent == null || dcParent.getLength() == 0) {
            return new HostPort(false);
        }
        NodeList interfs = dcParent.item(0).getChildNodes();
        for (int i = 0; i < interfs.getLength(); ++i) {
            if (!(interfs.item(i) instanceof Element)) continue;
            Element interf = (Element)interfs.item(i);
            if (interf.getNodeName().equals("local")) {
                return new HostPort();
            }
            HostPort hp = new HostPort(false);
            hp.host = interf.getAttribute("host");
            hp.port = Integer.parseInt(interf.getAttribute("port"));
            return hp;
        }
        return new HostPort(false);
    }

    protected String getHostXmlFileLocation(ProcessInfo processInfo, boolean isDomain) {
        String home = processInfo.getEnvironmentVariable("jboss.home.dir");
        if (home == null) {
            home = this.getHomeDirFromCommandLine(processInfo.getCommandLine());
        }
        StringBuilder builder = new StringBuilder(home);
        if (isDomain) {
            builder.append(File.separator).append(AS7Mode.DOMAIN.getBaseDir());
        } else {
            builder.append(File.separator).append(AS7Mode.STANDALONE.getBaseDir());
        }
        builder.append(File.separator).append("configuration");
        if (isDomain) {
            builder.append(File.separator).append(AS7Mode.HOST.getDefaultXmlFile());
        } else {
            builder.append(File.separator).append(AS7Mode.STANDALONE.getDefaultXmlFile());
        }
        return builder.toString();
    }

    protected String determineServerVersionFromHomeDir(String homeDir) {
        String tmp = homeDir.substring(homeDir.lastIndexOf("/") + 1);
        String version = tmp.startsWith(JBOSS_AS_PREFIX) ? tmp.substring(JBOSS_AS_PREFIX.length()) : homeDir.substring(homeDir.lastIndexOf("-") + 1);
        return version;
    }

    protected static class HostPort {
        String host = "localhost";
        int port = 9990;
        boolean isLocal = true;

        public HostPort() {
        }

        public HostPort(boolean local) {
            this();
            this.isLocal = local;
        }

        public String toString() {
            return "HostPort{host='" + this.host + '\'' + ", port=" + this.port + ", isLocal=" + this.isLocal + '}';
        }
    }
}

