/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonNode;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.core.domain.configuration.definition.PropertySimpleType;
import org.rhq.core.domain.content.transfer.ResourcePackageDetails;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.domain.resource.CreateResourceStatus;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.content.ContentContext;
import org.rhq.core.pluginapi.content.ContentServices;
import org.rhq.core.pluginapi.inventory.CreateChildResourceFacet;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;
import org.rhq.core.pluginapi.inventory.DeleteResourceFacet;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;
import org.rhq.modules.plugins.jbossas7.ASConnection;
import org.rhq.modules.plugins.jbossas7.ASUploadConnection;
import org.rhq.modules.plugins.jbossas7.ConfigurationLoadDelegate;
import org.rhq.modules.plugins.jbossas7.ConfigurationWriteDelegate;
import org.rhq.modules.plugins.jbossas7.PluginStats;
import org.rhq.modules.plugins.jbossas7.json.Address;
import org.rhq.modules.plugins.jbossas7.json.ComplexResult;
import org.rhq.modules.plugins.jbossas7.json.CompositeOperation;
import org.rhq.modules.plugins.jbossas7.json.Operation;
import org.rhq.modules.plugins.jbossas7.json.PROPERTY_VALUE;
import org.rhq.modules.plugins.jbossas7.json.ReadAttribute;
import org.rhq.modules.plugins.jbossas7.json.ReadChildrenNames;
import org.rhq.modules.plugins.jbossas7.json.ReadResource;
import org.rhq.modules.plugins.jbossas7.json.Remove;
import org.rhq.modules.plugins.jbossas7.json.Result;

public class BaseComponent<T extends ResourceComponent<?>>
implements ResourceComponent<T>,
MeasurementFacet,
ConfigurationFacet,
DeleteResourceFacet,
CreateChildResourceFacet,
OperationFacet {
    private static final String INTERNAL = "_internal:";
    private static final int INTERNAL_SIZE = "_internal:".length();
    private static final String LOCALHOST = "localhost";
    private static final String DEFAULT_HTTP_MANAGEMENT_PORT = "9990";
    final Log log = LogFactory.getLog(this.getClass());
    ResourceContext context;
    Configuration pluginConfiguration;
    String myServerName;
    ASConnection connection;
    String path;
    Address address;
    String key;
    String host;
    int port;
    private boolean verbose = ASConnection.verbose;

    public AvailabilityType getAvailability() {
        ReadResource op = new ReadResource(this.address);
        Result res = this.connection.execute(op);
        return res.isSuccess() ? AvailabilityType.UP : AvailabilityType.DOWN;
    }

    public void start(ResourceContext context) throws InvalidPluginConfigurationException, Exception {
        this.context = context;
        this.pluginConfiguration = context.getPluginConfiguration();
        if (!(context.getParentResourceComponent() instanceof BaseComponent)) {
            this.host = this.pluginConfiguration.getSimpleValue("hostname", LOCALHOST);
            String portString = this.pluginConfiguration.getSimpleValue("port", DEFAULT_HTTP_MANAGEMENT_PORT);
            this.port = Integer.parseInt(portString);
            this.connection = new ASConnection(this.host, this.port);
        } else {
            this.connection = ((BaseComponent)context.getParentResourceComponent()).getASConnection();
        }
        this.path = this.pluginConfiguration.getSimpleValue("path", null);
        this.address = new Address(this.path);
        this.key = context.getResourceKey();
        this.myServerName = context.getResourceKey().substring(context.getResourceKey().lastIndexOf("/") + 1);
    }

    public void stop() {
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        for (MeasurementScheduleRequest req : metrics) {
            if (req.getName().startsWith(INTERNAL)) {
                this.processPluginStats(req, report);
                continue;
            }
            ReadAttribute op = new ReadAttribute(this.address, req.getName());
            Result res = this.connection.execute(op, false);
            if (!res.isSuccess()) {
                this.log.warn((Object)("Getting metric [" + req.getName() + "] at [ " + this.address + "] failed: " + res.getFailureDescription()));
                continue;
            }
            String val = (String)res.getResult();
            if (val == null) continue;
            if (req.getDataType() == DataType.MEASUREMENT) {
                if (val.equals("no metrics available")) continue;
                try {
                    Double d = Double.parseDouble(val);
                    MeasurementDataNumeric data = new MeasurementDataNumeric(req, d);
                    report.addData(data);
                }
                catch (NumberFormatException e) {
                    this.log.warn((Object)("Non numeric input for [" + req.getName() + "] : [" + val + "]"));
                }
                continue;
            }
            if (req.getDataType() != DataType.TRAIT) continue;
            MeasurementDataTrait data = new MeasurementDataTrait(req, val);
            report.addData(data);
        }
    }

    private void processPluginStats(MeasurementScheduleRequest req, MeasurementReport report) {
        String name = req.getName();
        if (!name.startsWith(INTERNAL)) {
            return;
        }
        name = name.substring(INTERNAL_SIZE);
        PluginStats stats = PluginStats.getInstance();
        Double val = name.equals("mgmtRequests") ? Double.valueOf(stats.getRequestCount()) : (name.equals("requestTime") ? Double.valueOf(stats.getRequestTime()) : (name.equals("maxTime") ? Double.valueOf(stats.getMaxTime()) : Double.valueOf(Double.NaN)));
        MeasurementDataNumeric data = new MeasurementDataNumeric(req, val);
        report.addData(data);
    }

    protected ASConnection getASConnection() {
        return this.connection;
    }

    protected String getPath() {
        return this.path;
    }

    public Configuration loadResourceConfiguration() throws Exception {
        ConfigurationDefinition configDef = this.context.getResourceType().getResourceConfigurationDefinition();
        ConfigurationLoadDelegate delegate = new ConfigurationLoadDelegate(configDef, this.connection, this.address);
        return delegate.loadResourceConfiguration();
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        ConfigurationDefinition configDef = this.context.getResourceType().getResourceConfigurationDefinition();
        ConfigurationWriteDelegate delegate = new ConfigurationWriteDelegate(configDef, this.connection, this.address);
        delegate.updateResourceConfiguration(report);
    }

    public void deleteResource() throws Exception {
        this.log.info((Object)("delete resource: " + this.path + " ..."));
        Remove op = new Remove(this.address);
        ComplexResult res = this.connection.executeComplex(op);
        if (!res.isSuccess()) {
            throw new IllegalArgumentException("Delete for [" + this.path + "] failed: " + res.getFailureDescription());
        }
        if (this.path.contains("server-group")) {
            // empty if block
        }
        this.log.info((Object)"   ... done");
    }

    public CreateResourceReport createResource(CreateResourceReport report) {
        if (report.getPackageDetails() != null) {
            return this.deployContent(report);
        }
        report.setStatus(CreateResourceStatus.INVALID_CONFIGURATION);
        Address createAddress = new Address(this.address);
        createAddress.add(report.getPluginConfiguration().getSimpleValue("path", ""), report.getUserSpecifiedResourceName());
        Operation op = new Operation("add", createAddress);
        for (Property prop : report.getResourceConfiguration().getProperties()) {
            if (!(prop instanceof PropertySimple)) continue;
            PropertySimple ps = (PropertySimple)prop;
            String value = ps.getStringValue();
            op.addAdditionalProperty(prop.getName(), value);
        }
        Result result = this.getASConnection().execute(op);
        if (result.isSuccess()) {
            report.setStatus(CreateResourceStatus.SUCCESS);
            report.setResourceKey(this.address.getPath());
            report.setResourceName(report.getUserSpecifiedResourceName());
        } else {
            report.setStatus(CreateResourceStatus.FAILURE);
            report.setErrorMessage(result.getFailureDescription());
        }
        return report;
    }

    protected CreateResourceReport deployContent(CreateResourceReport report) {
        ContentContext cctx = this.context.getContentContext();
        ResourcePackageDetails details = report.getPackageDetails();
        ContentServices contentServices = cctx.getContentServices();
        String resourceTypeName = report.getResourceType().getName();
        ASUploadConnection uploadConnection = new ASUploadConnection(this.host, this.port);
        OutputStream out = uploadConnection.getOutputStream(details.getFileName());
        contentServices.downloadPackageBitsForChildResource(cctx, resourceTypeName, details.getKey(), out);
        JsonNode uploadResult = uploadConnection.finishUpload();
        if (this.verbose) {
            this.log.info((Object)uploadResult);
        }
        if (ASUploadConnection.isErrorReply(uploadResult)) {
            report.setStatus(CreateResourceStatus.FAILURE);
            report.setErrorMessage(ASUploadConnection.getFailureDescription(uploadResult));
            return report;
        }
        String fileName = details.getFileName();
        if (fileName.startsWith("C:\\fakepath\\")) {
            fileName = fileName.substring("C:\\fakepath\\".length());
        }
        String tmpName = fileName;
        JsonNode resultNode = uploadResult.get("result");
        String hash = resultNode.get("BYTES_VALUE").getTextValue();
        return this.runDeploymentMagicOnServer(report, fileName, tmpName, hash);
    }

    public CreateResourceReport runDeploymentMagicOnServer(CreateResourceReport report, String runtimeName, String deploymentName, String hash) {
        String resourceKey;
        Result result;
        boolean toServerGroup = this.context.getResourceKey().contains("server-group=");
        this.log.info((Object)("Deploying [" + runtimeName + "] to domain only= " + !toServerGroup + " ..."));
        ASConnection connection = this.getASConnection();
        Operation step1 = new Operation("add", "deployment", deploymentName);
        ArrayList content = new ArrayList(1);
        HashMap<String, PROPERTY_VALUE> contentValues = new HashMap<String, PROPERTY_VALUE>();
        contentValues.put("hash", new PROPERTY_VALUE("BYTES_VALUE", hash));
        content.add(contentValues);
        step1.addAdditionalProperty("content", content);
        step1.addAdditionalProperty("name", deploymentName);
        step1.addAdditionalProperty("runtime-name", runtimeName);
        CompositeOperation cop = new CompositeOperation();
        cop.addStep(step1);
        if (!toServerGroup) {
            if (this.context.getResourceType().getName().contains("Standalone")) {
                Operation step2 = new Operation("deploy", step1.getAddress());
                cop.addStep(step2);
            }
            result = connection.execute(cop);
            resourceKey = step1.getAddress().getPath();
        } else {
            Address serverGroupAddress = new Address(this.context.getResourceKey());
            serverGroupAddress.add("deployment", deploymentName);
            Operation step2 = new Operation("add", serverGroupAddress);
            cop.addStep(step2);
            Operation step3 = new Operation("deploy", serverGroupAddress);
            cop.addStep(step3);
            resourceKey = serverGroupAddress.getPath();
            if (this.verbose) {
                this.log.info((Object)("Deploy operation: " + cop));
            }
            result = connection.execute(cop);
        }
        if (!result.isSuccess()) {
            String failureDescription = result.getFailureDescription();
            report.setErrorMessage(failureDescription);
            report.setStatus(CreateResourceStatus.FAILURE);
            this.log.warn((Object)(" ... done with failure: " + failureDescription));
        } else {
            report.setStatus(CreateResourceStatus.SUCCESS);
            report.setResourceName(runtimeName);
            report.setResourceKey(resourceKey);
            this.log.info((Object)(" ... with success and key [" + resourceKey + "]"));
        }
        return report;
    }

    public OperationResult invokeOperation(String name, Configuration parameters) throws InterruptedException, Exception {
        String serverGroup;
        if (!name.contains(":")) {
            OperationResult badName = new OperationResult("Operation name did not contain a ':'");
            badName.setErrorMessage("Operation name did not contain a ':'");
            return badName;
        }
        int colonPos = name.indexOf(58);
        String what = name.substring(0, colonPos);
        String op = name.substring(colonPos + 1);
        Operation operation = null;
        Address theAddress = new Address();
        if (what.equals("server-group")) {
            String groupName = parameters.getSimpleValue("name", "");
            String profile = parameters.getSimpleValue("profile", "default");
            theAddress.add("server-group", groupName);
            operation = new Operation(op, theAddress);
            operation.addAdditionalProperty("profile", profile);
        } else if (what.equals("server")) {
            if (this.context.getResourceType().getName().equals("JBossAS-Managed")) {
                String host = this.pluginConfiguration.getSimpleValue("domainHost", "local");
                theAddress.add("host", host);
                theAddress.add("server-config", this.myServerName);
                operation = new Operation(op, theAddress);
            } else if (this.context.getResourceType().getName().equals("Host")) {
                theAddress.add(this.address);
                String serverName = parameters.getSimpleValue("name", null);
                theAddress.add("server-config", serverName);
                HashMap<String, Object> props = new HashMap<String, Object>();
                serverGroup = parameters.getSimpleValue("group", null);
                props.put("group", serverGroup);
                if (op.equals("add")) {
                    props.put("name", serverName);
                    boolean autoStart = parameters.getSimple("auto-start").getBooleanValue();
                    props.put("auto-start", autoStart);
                }
                operation = new Operation(op, theAddress, props);
            } else {
                operation = new Operation(op, theAddress);
            }
        } else if (what.equals("destination")) {
            theAddress.add(this.address);
            String newName = parameters.getSimpleValue("name", "");
            String type = parameters.getSimpleValue("type", "jms-queue").toLowerCase();
            theAddress.add(type, newName);
            PropertyList jndiNamesProp = parameters.getList("entries");
            if (jndiNamesProp == null || jndiNamesProp.getList().isEmpty()) {
                OperationResult fail = new OperationResult();
                fail.setErrorMessage("No jndi bindings given");
                return fail;
            }
            ArrayList<String> jndiNames = new ArrayList<String>();
            for (Property p : jndiNamesProp.getList()) {
                PropertySimple ps = (PropertySimple)p;
                jndiNames.add(ps.getStringValue());
            }
            operation = new Operation(op, theAddress);
            operation.addAdditionalProperty("entries", jndiNames);
            if (type.equals("jms-queue")) {
                String selector;
                PropertySimple ps = (PropertySimple)parameters.get("durable");
                if (ps != null) {
                    boolean durable = ps.getBooleanValue();
                    operation.addAdditionalProperty("durable", durable);
                }
                if (!(selector = parameters.getSimpleValue("selector", "")).isEmpty()) {
                    operation.addAdditionalProperty("selector", selector);
                }
            }
        } else if (what.equals("managed-server")) {
            String chost = parameters.getSimpleValue("hostname", "");
            String serverName = parameters.getSimpleValue("servername", "");
            serverGroup = parameters.getSimpleValue("server-group", "");
            String socketBindings = parameters.getSimpleValue("socket-bindings", "");
            String portS = parameters.getSimpleValue("port-offset", "0");
            int port = Integer.parseInt(portS);
            String autostartS = parameters.getSimpleValue("auto-start", "false");
            boolean autoStart = Boolean.getBoolean(autostartS);
            theAddress.add("host", chost);
            theAddress.add("server-config", serverName);
            HashMap<String, Object> props = new HashMap<String, Object>();
            props.put("name", serverName);
            props.put("group", serverGroup);
            props.put("socket-binding-group", socketBindings);
            props.put("socket-binding-port-offset", port);
            props.put("auto-start", autoStart);
            operation = new Operation(op, theAddress, props);
        } else if (what.equals("domain")) {
            operation = new Operation(op, new Address());
        } else if (what.equals("domain-deployment")) {
            if (op.equals("promote")) {
                String serverGroup2 = parameters.getSimpleValue("server-group", "-not set-");
                ArrayList<String> serverGroups = new ArrayList<String>();
                if (serverGroup2.equals("__all")) {
                    serverGroups.addAll(this.getServerGroups());
                } else {
                    serverGroups.add(serverGroup2);
                }
                String resourceKey = this.context.getResourceKey();
                resourceKey = resourceKey.substring(resourceKey.indexOf("=") + 1);
                this.log.info((Object)("Promoting [" + resourceKey + "] to server group(s) [" + Arrays.asList(serverGroups) + "]"));
                PropertySimple simple = parameters.getSimple("enabled");
                Boolean enabled = false;
                if (simple != null && simple.getBooleanValue() != null) {
                    enabled = simple.getBooleanValue();
                }
                operation = new CompositeOperation();
                for (String theGroup : serverGroups) {
                    theAddress = new Address();
                    theAddress.add("server-group", theGroup);
                    theAddress.add("deployment", resourceKey);
                    Operation step = new Operation("add", theAddress);
                    step.addAdditionalProperty("enabled", enabled);
                    ((CompositeOperation)operation).addStep(step);
                }
            }
        } else if (what.equals("naming") && op.equals("jndi-view")) {
            theAddress.add(this.address);
            operation = new Operation("jndi-view", theAddress);
        }
        OperationResult operationResult = new OperationResult();
        if (operation != null) {
            Result result = this.connection.execute(operation);
            if (!result.isSuccess()) {
                operationResult.setErrorMessage(result.getFailureDescription());
            } else {
                String tmp = result.getResult() == null ? "-none provided by the server-" : result.getResult().toString();
                operationResult.setSimpleResult(tmp);
            }
        } else {
            operationResult.setErrorMessage("No valid operation was given for input [" + name + "]");
        }
        return operationResult;
    }

    private Collection<String> getServerGroups() {
        ReadChildrenNames op = new ReadChildrenNames(new Address(), "server-group");
        Result res = this.connection.execute(op);
        return (Collection)res.getResult();
    }

    Object getObjectForProperty(PropertySimple prop, PropertyDefinitionSimple propDef) {
        PropertySimpleType type = propDef.getType();
        switch (type) {
            case STRING: {
                return prop.getStringValue();
            }
            case INTEGER: {
                return prop.getIntegerValue();
            }
            case BOOLEAN: {
                return prop.getBooleanValue();
            }
            case LONG: {
                return prop.getLongValue();
            }
            case FLOAT: {
                return prop.getFloatValue();
            }
            case DOUBLE: {
                return prop.getDoubleValue();
            }
        }
        return prop.getStringValue();
    }

    public void setConnection(ASConnection connection) {
        this.connection = connection;
    }

    public void setPath(String path) {
        this.path = path;
        this.address = new Address(path);
    }

    public Address getAddress() {
        return this.address;
    }
}

