/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ProcessScanResult;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.system.ProcessInfo;
import org.rhq.modules.plugins.jbossas7.AS7Mode;
import org.rhq.modules.plugins.jbossas7.AbstractBaseDiscovery;
import org.w3c.dom.Document;

public class BaseProcessDiscovery
extends AbstractBaseDiscovery
implements ResourceDiscoveryComponent {
    static final String DORG_JBOSS_BOOT_LOG_FILE = "-Dorg.jboss.boot.log.file=";
    private final Log log = LogFactory.getLog(this.getClass());

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext discoveryContext) throws Exception {
        HashSet<DiscoveredResourceDetails> discoveredResources = new HashSet<DiscoveredResourceDetails>();
        List scans = discoveryContext.getAutoDiscoveredProcesses();
        for (ProcessScanResult psr : scans) {
            String serverNameFull;
            String serverName;
            String bootLogFile;
            Configuration config = discoveryContext.getDefaultPluginConfiguration();
            String[] commandLine = psr.getProcessInfo().getCommandLine();
            String psName = psr.getProcessScan().getName();
            String description = discoveryContext.getResourceType().getDescription();
            String homeDir = this.getHomeDirFromCommandLine(commandLine);
            String version = null;
            String logFile = bootLogFile = this.getLogFileFromCommandLine(commandLine);
            if (psName.equals("HostController")) {
                this.readStandaloneOrHostXml(psr.getProcessInfo(), true);
                AbstractBaseDiscovery.HostPort hp = this.getDomainControllerFromHostXml();
                if (hp.isLocal) {
                    serverName = "DomainController";
                    serverNameFull = "DomainController";
                    description = "Domain controller for an AS7 domain";
                } else {
                    serverName = "HostController";
                    serverNameFull = "HostController";
                }
                config.put((Property)new PropertySimple("baseDir", (Object)homeDir));
                config.put((Property)new PropertySimple("startScript", (Object)AS7Mode.DOMAIN.getStartScript()));
                String host = this.findHost(psr.getProcessInfo(), true);
                config.put((Property)new PropertySimple("domainHost", (Object)host));
                this.fillUserPassFromFile(config, "domain", homeDir);
                String domainConfig = this.getServerConfigFromCommandLine(commandLine, AS7Mode.DOMAIN);
                String hostConfig = this.getServerConfigFromCommandLine(commandLine, AS7Mode.HOST);
                config.put((Property)new PropertySimple("domainConfig", (Object)domainConfig));
                config.put((Property)new PropertySimple("hostConfig", (Object)hostConfig));
            } else {
                serverNameFull = homeDir;
                this.readStandaloneOrHostXml(psr.getProcessInfo(), false);
                if (serverNameFull.isEmpty()) {
                    String tmp = this.getLogFileFromCommandLine(commandLine);
                    int i = tmp.indexOf("servers/");
                    tmp = tmp.substring(i + 8);
                    serverNameFull = tmp = tmp.substring(0, tmp.indexOf("/"));
                }
                String host = this.findHost(psr.getProcessInfo(), false);
                config.put((Property)new PropertySimple("domainHost", (Object)host));
                config.put((Property)new PropertySimple("baseDir", (Object)serverNameFull));
                serverName = this.findHostName();
                if (serverName.isEmpty()) {
                    serverName = serverNameFull;
                }
                String serverConfig = this.getServerConfigFromCommandLine(commandLine, AS7Mode.STANDALONE);
                config.put((Property)new PropertySimple("config", (Object)serverConfig));
                config.put((Property)new PropertySimple("startScript", (Object)AS7Mode.STANDALONE.getStartScript()));
                this.fillUserPassFromFile(config, "standalone", serverNameFull);
                logFile = bootLogFile.substring(0, bootLogFile.lastIndexOf("/")) + File.separator + "server.log";
            }
            this.initLogEventSourcesConfigProp(logFile, config);
            AbstractBaseDiscovery.HostPort managmentPort = this.getManagementPortFromHostXml(commandLine);
            config.put((Property)new PropertySimple("hostname", (Object)managmentPort.host));
            config.put((Property)new PropertySimple("port", (Object)managmentPort.port));
            DiscoveredResourceDetails detail = new DiscoveredResourceDetails(discoveryContext.getResourceType(), serverNameFull, serverName, version, description, config, psr.getProcessInfo());
            discoveredResources.add(detail);
            this.log.info((Object)("Discovered new ...  " + discoveryContext.getResourceType() + ", " + serverNameFull));
        }
        return discoveredResources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fillUserPassFromFile(Configuration config, String mode, String baseDir) {
        String configDir = baseDir + File.separator + mode + File.separator + "configuration";
        File file = new File(configDir, "mgmt-users.properties");
        if (!file.exists() || !file.canRead()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("No console user properties file found at [" + file.getAbsolutePath() + "] or file is not readable"));
            }
            return;
        }
        BufferedReader br = null;
        try {
            String line;
            FileReader fileReader = new FileReader(file);
            br = new BufferedReader(fileReader);
            while ((line = br.readLine()) != null) {
                if (line.startsWith("#") || line.isEmpty() || !line.contains("=")) continue;
                String user = line.substring(0, line.indexOf("="));
                String pass = line.substring(line.indexOf("=") + 1);
                config.put((Property)new PropertySimple("user", (Object)user));
                config.put((Property)new PropertySimple("password", (Object)pass));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String findHost(ProcessInfo processInfo, boolean isDomain) {
        String hostXmlFile = this.getHostXmlFileLocation(processInfo, isDomain);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        String hostName = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            FileInputStream is = new FileInputStream(hostXmlFile);
            try {
                Document document = builder.parse(is);
                hostName = document.getDocumentElement().getAttribute("name");
            }
            finally {
                ((InputStream)is).close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (hostName == null) {
            hostName = "local";
        }
        return hostName;
    }

    String getServerConfigFromCommandLine(String[] commandLine, AS7Mode mode) {
        String configArg = mode.getConfigArg();
        for (String line : commandLine) {
            if (!line.startsWith(configArg)) continue;
            return line.substring(configArg.length() + 1);
        }
        return mode.getDefaultXmlFile();
    }

    @Override
    String getLogFileFromCommandLine(String[] commandLine) {
        for (String line : commandLine) {
            if (!line.startsWith(DORG_JBOSS_BOOT_LOG_FILE)) continue;
            return line.substring(DORG_JBOSS_BOOT_LOG_FILE.length());
        }
        return "";
    }

    private void initLogEventSourcesConfigProp(String fileName, Configuration pluginConfiguration) {
        PropertyList logEventSources = pluginConfiguration.getList("logEventSources");
        if (logEventSources == null) {
            return;
        }
        File serverLogFile = new File(fileName);
        if (serverLogFile.exists() && !serverLogFile.isDirectory()) {
            PropertyMap serverLogEventSource = new PropertyMap("logEventSource");
            serverLogEventSource.put((Property)new PropertySimple("logFilePath", (Object)serverLogFile));
            serverLogEventSource.put((Property)new PropertySimple("enabled", (Object)Boolean.FALSE));
            logEventSources.add((Property)serverLogEventSource);
        }
    }
}

