/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionList;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionMap;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.core.domain.configuration.definition.PropertyGroupDefinition;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.modules.plugins.jbossas7.ASConnection;
import org.rhq.modules.plugins.jbossas7.json.Address;
import org.rhq.modules.plugins.jbossas7.json.Operation;
import org.rhq.modules.plugins.jbossas7.json.ReadAttribute;
import org.rhq.modules.plugins.jbossas7.json.ReadChildrenResources;
import org.rhq.modules.plugins.jbossas7.json.ReadResource;
import org.rhq.modules.plugins.jbossas7.json.Result;

public class ConfigurationLoadDelegate
implements ConfigurationFacet {
    final Log log = LogFactory.getLog(this.getClass());
    private Address address;
    private ASConnection connection;
    private ConfigurationDefinition configurationDefinition;

    public ConfigurationLoadDelegate(ConfigurationDefinition configDef, ASConnection connection, Address address) {
        this.configurationDefinition = configDef;
        this.connection = connection;
        this.address = address;
    }

    public Configuration loadResourceConfiguration() throws Exception {
        Configuration config = new Configuration();
        List gdef = this.configurationDefinition.getGroupDefinitions();
        for (PropertyGroupDefinition pgDef : gdef) {
            this.loadHandleGroup(config, pgDef);
        }
        List nonGroupdedDefs = this.configurationDefinition.getNonGroupedProperties();
        ReadResource op = new ReadResource(this.address);
        this.loadHandleProperties(config, nonGroupdedDefs, op);
        return config;
    }

    private void loadHandleGroup(Configuration config, PropertyGroupDefinition groupDefinition) throws Exception {
        Operation operation;
        String groupName = groupDefinition.getName();
        if (groupName.startsWith("attribute:")) {
            String attr = groupName.substring("attribute:".length());
            operation = new ReadAttribute(this.address, attr);
        } else if (groupName.startsWith("children:")) {
            String type = groupName.substring("children:".length());
            if (type.contains(":")) {
                type = type.substring(0, type.indexOf(":"));
            }
            operation = new ReadChildrenResources(this.address, type);
            operation.addAdditionalProperty("recursive", "true");
        } else {
            throw new IllegalArgumentException("Unknown operation in group name [" + groupName + "]");
        }
        List listedDefs = this.configurationDefinition.getPropertiesInGroup(groupName);
        this.loadHandleProperties(config, listedDefs, operation);
    }

    private void loadHandleProperties(Configuration config, List<PropertyDefinition> definitions, Operation op) throws Exception {
        if (definitions.size() == 0) {
            return;
        }
        Result operationResult = this.connection.execute(op);
        if (!operationResult.isSuccess()) {
            throw new IOException("Operation " + op + " failed: " + operationResult.getFailureDescription());
        }
        if (operationResult.getResult() instanceof List) {
            PropertyList propertyList = this.loadHandlePropertyList((PropertyDefinitionList)definitions.get(0), operationResult.getResult());
            if (propertyList != null) {
                config.put((Property)propertyList);
            }
            return;
        }
        Map results = (Map)operationResult.getResult();
        for (PropertyDefinition propDef : definitions) {
            PropertyMap propertyMap;
            if (propDef instanceof PropertyDefinitionList && propDef.getName().equals("*")) {
                if (!((propDef = ((PropertyDefinitionList)propDef).getMemberDefinition()) instanceof PropertyDefinitionMap)) {
                    this.log.error((Object)"Embedded child is not a map");
                    return;
                }
                PropertyList list = new PropertyList("*");
                for (Map.Entry entry : results.entrySet()) {
                    Object val = entry.getValue();
                    PropertyMap propertyMap2 = this.loadHandlePropertyMap((PropertyDefinitionMap)propDef, val);
                    if (propertyMap2 == null) continue;
                    list.add((Property)propertyMap2);
                }
                config.put((Property)list);
                continue;
            }
            String propertyName = propDef.getName();
            Object valueObject = results.get(propertyName);
            if (propDef instanceof PropertyDefinitionSimple) {
                PropertySimple value = this.loadHandlePropertySimple((PropertyDefinitionSimple)propDef, valueObject);
                if (value == null) continue;
                config.put((Property)value);
                continue;
            }
            if (propDef instanceof PropertyDefinitionList) {
                PropertyList propertyList = this.loadHandlePropertyList((PropertyDefinitionList)propDef, valueObject);
                if (propertyList == null) continue;
                config.put((Property)propertyList);
                continue;
            }
            if (!(propDef instanceof PropertyDefinitionMap) || (propertyMap = this.loadHandlePropertyMap((PropertyDefinitionMap)propDef, valueObject)) == null) continue;
            config.put((Property)propertyMap);
        }
    }

    PropertySimple loadHandlePropertySimple(PropertyDefinitionSimple propDef, Object valueObject) {
        PropertySimple propertySimple;
        String name = propDef.getName();
        if (valueObject != null) {
            propertySimple = new PropertySimple(name, valueObject);
        } else if (propDef.isRequired()) {
            String defaultValue = propDef.getDefaultValue();
            propertySimple = new PropertySimple(name, (Object)defaultValue);
        } else {
            propertySimple = new PropertySimple(name, null);
        }
        return propertySimple;
    }

    PropertyMap loadHandlePropertyMap(PropertyDefinitionMap propDef, Object valueObject) {
        if (valueObject == null) {
            return null;
        }
        PropertyMap propertyMap = new PropertyMap(propDef.getName());
        Map memberDefMap = propDef.getPropertyDefinitions();
        Map objects = (Map)valueObject;
        for (Map.Entry maEntry : memberDefMap.entrySet()) {
            PropertySimple property;
            String key = (String)maEntry.getKey();
            Object o = key.equals("*") ? objects.entrySet().iterator().next().getValue() : objects.get(key);
            PropertyDefinition value = (PropertyDefinition)maEntry.getValue();
            if (value instanceof PropertyDefinitionSimple) {
                property = this.loadHandlePropertySimple((PropertyDefinitionSimple)value, o);
            } else if (value instanceof PropertyDefinitionList) {
                property = this.loadHandlePropertyList((PropertyDefinitionList)value, o);
            } else if (value instanceof PropertyDefinitionMap) {
                property = this.loadHandlePropertyMap((PropertyDefinitionMap)value, o);
            } else {
                throw new IllegalArgumentException("Unknown property type in map property [" + propDef.getName() + "]");
            }
            if (property != null) {
                propertyMap.put((Property)property);
                continue;
            }
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug((Object)("Property " + key + " was null"));
        }
        return propertyMap;
    }

    PropertyList loadHandlePropertyList(PropertyDefinitionList propDef, Object valueObject) {
        PropertyList propertyList;
        block5: {
            Collection<Object> objects;
            PropertyDefinition memberDefinition;
            block4: {
                String propertyName = propDef.getName();
                propertyList = new PropertyList(propertyName);
                memberDefinition = propDef.getMemberDefinition();
                if (memberDefinition == null) {
                    throw new IllegalArgumentException("Member definition for property [" + propertyName + "] was null");
                }
                if (valueObject == null) {
                    return null;
                }
                objects = valueObject instanceof List ? (List)valueObject : ((Map)valueObject).values();
                if (!(memberDefinition instanceof PropertyDefinitionSimple)) break block4;
                for (Object obj : objects) {
                    PropertySimple property = this.loadHandlePropertySimple((PropertyDefinitionSimple)memberDefinition, obj);
                    if (property == null) continue;
                    propertyList.add((Property)property);
                }
                break block5;
            }
            if (!(memberDefinition instanceof PropertyDefinitionMap)) break block5;
            for (Object obj : objects) {
                Map map = (Map)obj;
                PropertyMap propertyMap = this.loadHandlePropertyMap((PropertyDefinitionMap)propDef.getMemberDefinition(), map);
                if (propertyMap == null) continue;
                propertyList.add((Property)propertyMap);
            }
        }
        return propertyList;
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        throw new IllegalArgumentException("Please use ConfigurationWriteDelegate");
    }
}

