/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionList;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionMap;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.core.domain.configuration.definition.PropertyGroupDefinition;
import org.rhq.core.pluginapi.configuration.ConfigurationFacet;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.modules.plugins.jbossas7.ASConnection;
import org.rhq.modules.plugins.jbossas7.json.Address;
import org.rhq.modules.plugins.jbossas7.json.CompositeOperation;
import org.rhq.modules.plugins.jbossas7.json.Result;
import org.rhq.modules.plugins.jbossas7.json.WriteAttribute;

public class ConfigurationWriteDelegate
implements ConfigurationFacet {
    final Log log = LogFactory.getLog(this.getClass());
    private Address address;
    private ASConnection connection;
    private ConfigurationDefinition configurationDefinition;
    private String namePropLocator;
    private String type;

    public ConfigurationWriteDelegate(ConfigurationDefinition configDef, ASConnection connection, Address address) {
        this.configurationDefinition = configDef;
        this.connection = connection;
        this.address = address;
    }

    public Configuration loadResourceConfiguration() throws Exception {
        throw new IllegalAccessException("Please use ConfigurationLoadDelegate");
    }

    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        Configuration conf = report.getConfiguration();
        CompositeOperation cop = this.updateGenerateOperationFromProperties(conf);
        Result result = this.connection.execute(cop);
        if (!result.isSuccess()) {
            report.setStatus(ConfigurationUpdateStatus.FAILURE);
            report.setErrorMessage(result.getFailureDescription());
        } else {
            report.setStatus(ConfigurationUpdateStatus.SUCCESS);
        }
    }

    protected CompositeOperation updateGenerateOperationFromProperties(Configuration conf) {
        CompositeOperation cop = new CompositeOperation();
        for (PropertyDefinition propDef : this.configurationDefinition.getNonGroupedProperties()) {
            this.updateProperty(conf, cop, propDef);
        }
        for (PropertyGroupDefinition pgd : this.configurationDefinition.getGroupDefinitions()) {
            String groupName = pgd.getName();
            this.namePropLocator = null;
            if (!groupName.startsWith("children:")) continue;
            this.type = groupName.substring("children:".length());
            if (!this.type.contains(":")) {
                this.log.error((Object)("Group name " + groupName + " contains no property name locator "));
                return cop;
            }
            this.namePropLocator = this.type.substring(this.type.indexOf(":") + 1);
            this.type = this.type.substring(0, this.type.indexOf(":"));
            List definitions = this.configurationDefinition.getPropertiesInGroup(groupName);
            for (PropertyDefinition def : definitions) {
                this.updateProperty(conf, cop, def);
            }
        }
        return cop;
    }

    private void updateProperty(Configuration conf, CompositeOperation cop, PropertyDefinition propDef) {
        if (propDef.isReadOnly()) {
            return;
        }
        if (propDef instanceof PropertyDefinitionList && propDef.getName().equals("*")) {
            propDef = ((PropertyDefinitionList)propDef).getMemberDefinition();
            PropertyList pl = (PropertyList)conf.get("*");
            for (Property prop2 : pl.getList()) {
                this.updateHandlePropertyMapSpecial(cop, (PropertyMap)prop2, (PropertyDefinitionMap)propDef);
            }
        } else {
            Property prop = conf.get(propDef.getName());
            if (prop instanceof PropertySimple) {
                this.updateHandlePropertySimple(cop, (PropertySimple)prop, (PropertyDefinitionSimple)propDef);
            } else if (prop instanceof PropertyList) {
                this.updateHandlePropertyList(cop, (PropertyList)prop, (PropertyDefinitionList)propDef);
            } else {
                this.updateHandlePropertyMap(cop, (PropertyMap)prop, (PropertyDefinitionMap)propDef);
            }
        }
    }

    private void updateHandlePropertyMap(CompositeOperation cop, PropertyMap prop, PropertyDefinitionMap propDef) {
        Map<String, Object> results = this.updateHandleMap(prop, propDef);
        WriteAttribute writeAttribute = new WriteAttribute(this.address, prop.getName(), results);
        cop.addStep(writeAttribute);
    }

    private void updateHandlePropertyMapSpecial(CompositeOperation cop, PropertyMap prop, PropertyDefinitionMap propDef) {
        Map<String, Object> results = this.updateHandleMap(prop, propDef);
        if (prop.get(this.namePropLocator) == null) {
            throw new IllegalArgumentException("There is no element in the map with the name " + this.namePropLocator);
        }
        String addrVal = ((PropertySimple)prop.get(this.namePropLocator)).getStringValue();
        Address addr = new Address(this.address);
        addr.add(this.type, addrVal);
        for (Map.Entry<String, Object> entry : results.entrySet()) {
            WriteAttribute writeAttribute = new WriteAttribute(addr, entry.getKey(), entry.getValue());
            cop.addStep(writeAttribute);
        }
    }

    private void updateHandlePropertyList(CompositeOperation cop, PropertyList prop, PropertyDefinitionList propDef) {
        PropertyDefinition memberDef = propDef.getMemberDefinition();
        List embeddedProps = prop.getList();
        ArrayList<Object> values = new ArrayList<Object>();
        for (Property inner : embeddedProps) {
            PropertySimple ps;
            if (memberDef instanceof PropertyDefinitionSimple && (ps = (PropertySimple)inner).getStringValue() != null) {
                values.add(ps.getStringValue());
            }
            if (!(memberDef instanceof PropertyDefinitionMap)) continue;
            Map<String, Object> mapResult = this.updateHandleMap((PropertyMap)inner, (PropertyDefinitionMap)memberDef);
            values.add(mapResult);
        }
        WriteAttribute writeAttribute = new WriteAttribute(this.address, prop.getName(), values);
        cop.addStep(writeAttribute);
    }

    private void updateHandlePropertySimple(CompositeOperation cop, PropertySimple propertySimple, PropertyDefinitionSimple propDef) {
        if (propertySimple.getStringValue() == null && !propDef.isRequired()) {
            return;
        }
        WriteAttribute writeAttribute = new WriteAttribute(this.address, propertySimple.getName(), (Object)propertySimple.getStringValue());
        cop.addStep(writeAttribute);
    }

    private Map<String, Object> updateHandleMap(PropertyMap map, PropertyDefinitionMap mapDef) {
        Map memberDefinitions = mapDef.getPropertyDefinitions();
        HashMap<String, Object> results = new HashMap<String, Object>();
        for (String name : memberDefinitions.keySet()) {
            PropertyDefinition memberDefinition = (PropertyDefinition)memberDefinitions.get(name);
            if (memberDefinition.isReadOnly()) continue;
            if (memberDefinition instanceof PropertyDefinitionSimple) {
                PropertyDefinitionSimple pds = (PropertyDefinitionSimple)memberDefinition;
                PropertySimple ps = (PropertySimple)map.get(name);
                if ((ps == null || ps.getStringValue() == null) && !pds.isRequired() || ps == null) continue;
                results.put(name, ps.getStringValue());
                continue;
            }
            this.log.error((Object)(" *** not yet supported *** : " + memberDefinition.getName()));
        }
        return results;
    }
}

