/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionList;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.core.domain.resource.CreateResourceStatus;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;
import org.rhq.modules.plugins.jbossas7.BaseComponent;
import org.rhq.modules.plugins.jbossas7.json.Address;
import org.rhq.modules.plugins.jbossas7.json.ComplexResult;
import org.rhq.modules.plugins.jbossas7.json.Operation;

public class JmsComponent
extends BaseComponent {
    private final Log log = LogFactory.getLog(JmsComponent.class);

    @Override
    public CreateResourceReport createResource(CreateResourceReport report) {
        Configuration pConf = report.getPluginConfiguration();
        Configuration resConf = report.getResourceConfiguration();
        ConfigurationDefinition resConfDef = report.getResourceType().getResourceConfigurationDefinition();
        String type = pConf.getSimpleValue("path", "");
        Address theAddress = new Address(this.address);
        theAddress.add(type, report.getUserSpecifiedResourceName());
        Operation op = new Operation("add", theAddress);
        for (Map.Entry entry : resConf.getAllProperties().entrySet()) {
            Property value = (Property)entry.getValue();
            if (value == null) continue;
            String name = (String)entry.getKey();
            if (value instanceof PropertySimple) {
                PropertyDefinitionSimple propDef = (PropertyDefinitionSimple)resConfDef.get(name);
                PropertySimple ps = (PropertySimple)value;
                op.addAdditionalProperty(name, this.getObjectForProperty(ps, propDef));
                continue;
            }
            if (!(value instanceof PropertyList)) continue;
            PropertyList propertyList = (PropertyList)value;
            ArrayList<Object> list = new ArrayList<Object>();
            PropertyDefinitionList pd = resConfDef.getPropertyDefinitionList(name);
            PropertyDefinitionSimple propDef = (PropertyDefinitionSimple)pd.getMemberDefinition();
            for (Property p : propertyList.getList()) {
                Object o = this.getObjectForProperty((PropertySimple)p, propDef);
                list.add(o);
            }
            op.addAdditionalProperty(name, list);
        }
        ComplexResult res = (ComplexResult)this.getASConnection().execute(op, true);
        if (res == null || !res.isSuccess()) {
            report.setStatus(CreateResourceStatus.FAILURE);
        } else {
            report.setStatus(CreateResourceStatus.SUCCESS);
            report.setResourceKey(theAddress.toString());
            report.setResourceName(report.getUserSpecifiedResourceName());
        }
        System.out.println(report);
        return report;
    }
}

