/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.modules.plugins.jbossas7;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ProcessScanResult;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.core.system.ProcessInfo;
import org.rhq.modules.plugins.jbossas7.ASConnection;
import org.rhq.modules.plugins.jbossas7.AbstractBaseDiscovery;
import org.rhq.modules.plugins.jbossas7.json.Address;
import org.rhq.modules.plugins.jbossas7.json.ComplexResult;
import org.rhq.modules.plugins.jbossas7.json.ReadResource;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ManagedASDiscovery
extends AbstractBaseDiscovery {
    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext discoveryContext) throws Exception {
        HashSet<DiscoveredResourceDetails> discoveredResources = new HashSet<DiscoveredResourceDetails>();
        List scans = discoveryContext.getAutoDiscoveredProcesses();
        for (ProcessScanResult psr : scans) {
            String psName = psr.getProcessScan().getName();
            if (!psName.equals("HostController")) continue;
            ProcessInfo processInfo = psr.getProcessInfo();
            this.readStandaloneOrHostXml(processInfo, true);
            String hostName = this.findHostName();
            AbstractBaseDiscovery.HostPort managementHostPort = this.getManagementPortFromHostXml(processInfo.getCommandLine());
            List<ServerInfo> serverNames = this.getServersFromHostXml();
            for (ServerInfo serverInfo : serverNames) {
                Configuration config = discoveryContext.getDefaultPluginConfiguration();
                config.put((Property)new PropertySimple("domainHost", (Object)hostName));
                config.put((Property)new PropertySimple("group", (Object)serverInfo.group));
                config.put((Property)new PropertySimple("port", (Object)managementHostPort.port));
                config.put((Property)new PropertySimple("hostname", (Object)managementHostPort.host));
                if (serverInfo.bindingGroup != null) {
                    config.put((Property)new PropertySimple("socket-binding-group", (Object)serverInfo.bindingGroup));
                    config.put((Property)new PropertySimple("socket-binding-port-offset", (Object)serverInfo.portOffset));
                } else {
                    AbstractBaseDiscovery.HostPort dcHP = this.getDomainControllerFromHostXml();
                    if (dcHP.port == 9999) {
                        dcHP.port = 9990;
                    }
                    ServerInfo dcInfo = this.getBindingsFromDC(dcHP, serverInfo.group);
                    config.put((Property)new PropertySimple("socket-binding-group", (Object)dcInfo.bindingGroup));
                    config.put((Property)new PropertySimple("socket-binding-port-offset", (Object)dcInfo.portOffset));
                }
                config.put((Property)new PropertySimple("socket-binding-port-offset", (Object)serverInfo.portOffset));
                String path = "host=" + hostName + ",server-config=" + serverInfo.name;
                config.put((Property)new PropertySimple("path", (Object)path));
                String homeDir = this.getHomeDirFromCommandLine(processInfo.getCommandLine());
                this.initLogFile(scans, serverInfo.name, config, homeDir);
                String version = this.determineServerVersionFromHomeDir(homeDir);
                DiscoveredResourceDetails detail = new DiscoveredResourceDetails(discoveryContext.getResourceType(), hostName + "/" + serverInfo.name, serverInfo.name, version, "Managed AS 7 instance", config, null);
                discoveredResources.add(detail);
                this.log.info((Object)("Discovered new ...  " + discoveryContext.getResourceType() + ", " + serverInfo));
            }
        }
        return discoveredResources;
    }

    private ServerInfo getBindingsFromDC(AbstractBaseDiscovery.HostPort domainController, String serverGroup) {
        ASConnection dcConnection = new ASConnection(domainController.host, domainController.port);
        ArrayList address = new ArrayList();
        Address theAddress = new Address("server-group", serverGroup);
        ReadResource op = new ReadResource(theAddress);
        ComplexResult res = (ComplexResult)dcConnection.execute(op, true);
        if (res.isSuccess() && res.getResult().containsKey("socket-binding-group")) {
            String sbg = (String)res.getResult().get("socket-binding-group");
            ServerInfo serverInfo = new ServerInfo();
            serverInfo.bindingGroup = sbg;
            return serverInfo;
        }
        return new ServerInfo();
    }

    private void initLogFile(List<ProcessScanResult> scans, String name, Configuration config, String basePath) {
        for (ProcessScanResult psr : scans) {
            String[] commandLine;
            String bootLogFile;
            String logFile;
            if (!psr.getProcessScan().getName().equals("ManagedAS") || !(logFile = (bootLogFile = this.getLogFileFromCommandLine(commandLine = psr.getProcessInfo().getCommandLine())).substring(0, bootLogFile.lastIndexOf("/")) + File.separator + "server.log").contains(name)) continue;
            this.initLogEventSourcesConfigProp(logFile, config);
        }
    }

    private List<ServerInfo> getServersFromHostXml() {
        Element host = this.hostXml.getDocumentElement();
        NodeList serversElement = host.getElementsByTagName("servers");
        if (serversElement == null || serversElement.getLength() == 0) {
            this.log.warn((Object)"No <servers> found in host.xml");
            return Collections.emptyList();
        }
        NodeList servers = serversElement.item(0).getChildNodes();
        if (servers == null || servers.getLength() == 0) {
            this.log.warn((Object)"No <server> found in host.xml");
            return Collections.emptyList();
        }
        ArrayList<ServerInfo> result = new ArrayList<ServerInfo>();
        for (int i = 0; i < servers.getLength(); ++i) {
            if (!(servers.item(i) instanceof Element)) continue;
            ServerInfo info = new ServerInfo();
            Element server = (Element)servers.item(i);
            info.name = server.getAttribute("name");
            info.group = server.getAttribute("group");
            String autoStart = server.getAttribute("autoStart");
            if (autoStart == null || autoStart.isEmpty()) {
                autoStart = "false";
            }
            info.autoStart = Boolean.getBoolean(autoStart);
            NodeList sbgs = server.getChildNodes();
            if (sbgs != null) {
                for (int j = 0; j < sbgs.getLength(); ++j) {
                    Element sbg;
                    if (!(sbgs.item(j) instanceof Element) || !(sbg = (Element)sbgs.item(j)).getNodeName().equals("socket-binding-group")) continue;
                    info.bindingGroup = sbg.getAttribute("ref");
                    String portOffset = sbg.getAttribute("port-offset");
                    if (portOffset == null || portOffset.isEmpty()) continue;
                    info.portOffset = Integer.parseInt(portOffset);
                }
            }
            result.add(info);
        }
        return result;
    }

    private void initLogEventSourcesConfigProp(String fileName, Configuration pluginConfiguration) {
        PropertyList logEventSources = pluginConfiguration.getList("logEventSources");
        if (logEventSources == null) {
            return;
        }
        File serverLogFile = new File(fileName);
        if (serverLogFile.exists() && !serverLogFile.isDirectory()) {
            PropertyMap serverLogEventSource = new PropertyMap("logEventSource");
            serverLogEventSource.put((Property)new PropertySimple("logFilePath", (Object)serverLogFile));
            serverLogEventSource.put((Property)new PropertySimple("enabled", (Object)Boolean.FALSE));
            logEventSources.add((Property)serverLogEventSource);
        }
    }

    private static class ServerInfo {
        String name;
        String group;
        boolean autoStart;
        int portOffset;
        String bindingGroup;

        private ServerInfo() {
        }

        public String toString() {
            return "ServerInfo{name='" + this.name + '\'' + ", group='" + this.group + '\'' + '}';
        }
    }
}

