/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.oracle;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.Set;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.util.jdbc.JDBCUtil;
import org.rhq.plugins.database.AbstractDatabaseComponent;
import org.rhq.plugins.database.DatabaseComponent;
import org.rhq.plugins.database.DatabaseQueryUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleUserComponent
extends AbstractDatabaseComponent
implements MeasurementFacet {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public AvailabilityType getAvailability() {
        ResultSet resultSet;
        PreparedStatement statement;
        block4: {
            AvailabilityType availabilityType;
            statement = null;
            resultSet = null;
            try {
                statement = this.getConnection().prepareStatement("SELECT COUNT(*) FROM DBA_USERS WHERE username = ?");
                statement.setString(1, this.resourceContext.getResourceKey());
                resultSet = statement.executeQuery();
                if (!resultSet.next() || resultSet.getInt(1) != 1) break block4;
                availabilityType = AvailabilityType.UP;
            }
            catch (SQLException sQLException) {
                JDBCUtil.safeClose((Statement)statement, resultSet);
                catch (Throwable throwable) {
                    JDBCUtil.safeClose((Statement)statement, resultSet);
                    throw throwable;
                }
            }
            JDBCUtil.safeClose((Statement)statement, (ResultSet)resultSet);
            return availabilityType;
        }
        JDBCUtil.safeClose((Statement)statement, (ResultSet)resultSet);
        return AvailabilityType.DOWN;
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        for (MeasurementScheduleRequest request : metrics) {
            Map values;
            Double sessions;
            if (!request.getName().equals("sessions") || (sessions = (Double)(values = DatabaseQueryUtility.getNumericQueryValues((DatabaseComponent)this, (String)"SELECT COUNT(*) as activeConnections FROM V$SESSION WHERE username = ?", (Object[])new Object[]{this.resourceContext.getResourceKey()})).get("count")) == null) continue;
            report.addData(new MeasurementDataNumeric(request, sessions));
        }
    }
}

