/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.util.exec;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.rhq.core.util.UtilI18NResourceKeys;
import org.rhq.core.util.exec.ProcessExecutorResults;
import org.rhq.core.util.exec.ProcessToStart;
import org.rhq.core.util.exec.StreamRedirector;

public class ProcessExecutor {
    private static ExecutorService threadPool = Executors.newCachedThreadPool();

    public ProcessExecutorResults execute(ProcessToStart processToStart) {
        ProcessExecutorResults results = new ProcessExecutorResults();
        try {
            Integer exitCode = this.startProgram(processToStart);
            results.setExitCode(exitCode);
        }
        catch (Throwable t) {
            results.setError(t);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Integer startProgram(final ProcessToStart process) throws Exception {
        String[] cmdline = this.getCommandLine(process);
        File workingDir = this.getWorkingDirectory(process);
        String[] environment = process.getEnvironment();
        final Process childProcess = Runtime.getRuntime().exec(cmdline, environment, workingDir);
        final RedirectThreads redirect = this.redirectAllStreams(process, childProcess);
        Integer exitCode = null;
        if (process.getWaitForExit().intValue() > 0) {
            Callable<Integer> call = new Callable<Integer>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Integer call() throws Exception {
                    Thread.currentThread().setName("ExecuteProcess-" + process.getProgramTitle());
                    try {
                        Integer n = childProcess.waitFor();
                        return n;
                    }
                    finally {
                        redirect.join();
                    }
                }
            };
            Future<Integer> future = threadPool.submit(call);
            try {
                exitCode = future.get(process.getWaitForExit().intValue(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
            catch (TimeoutException e) {
            }
            finally {
                future.cancel(true);
            }
            if (exitCode == null) {
                if (process.isKillOnTimeout().booleanValue()) {
                    childProcess.destroy();
                }
                redirect.interrupt();
            }
        }
        return exitCode;
    }

    @Deprecated
    protected void redirectStreams(ProcessToStart process, Process childProcess) throws IOException {
        this.redirectAllStreams(process, childProcess);
    }

    protected RedirectThreads redirectAllStreams(ProcessToStart process, Process childProcess) throws IOException {
        File outputFile;
        InputStream stdout = childProcess.getInputStream();
        InputStream stderr = childProcess.getErrorStream();
        OutputStream stdin = childProcess.getOutputStream();
        String threadNamePrefix = process.getProgramTitle();
        OutputStream fileOutputStream = null;
        if (process.isCaptureOutput().booleanValue() && (fileOutputStream = process.getOutputStream()) == null && (outputFile = this.createOutputFile(process)) != null) {
            fileOutputStream = new BufferedOutputStream(new FileOutputStream(outputFile));
        }
        if (threadNamePrefix == null) {
            threadNamePrefix = process.getProgramExecutable();
        }
        StreamRedirector stdoutThread = new StreamRedirector(threadNamePrefix + "-stdout", stdout, fileOutputStream);
        StreamRedirector stderrThread = new StreamRedirector(threadNamePrefix + "-stderr", stderr, fileOutputStream);
        stdoutThread.start();
        stderrThread.start();
        File inputFile = this.getInputFile(process);
        if (inputFile != null) {
            BufferedInputStream fileInputStream = new BufferedInputStream(new FileInputStream(inputFile));
            byte[] fileBytes = new byte[4096];
            int fileBytesRead = 1;
            while (fileBytesRead > 0) {
                fileBytesRead = fileInputStream.read(fileBytes);
                if (fileBytesRead <= 0) continue;
                stdin.write(fileBytes, 0, fileBytesRead);
            }
            fileInputStream.close();
        }
        stdin.close();
        return new RedirectThreads(stdoutThread, stderrThread);
    }

    protected File createOutputFile(ProcessToStart process) throws IOException {
        File retOutputFile;
        File directoryFile;
        if (!process.isCaptureOutput().booleanValue()) {
            return null;
        }
        String directoryStr = process.getOutputDirectory();
        String filenameStr = process.getOutputFile();
        if (directoryStr == null || directoryStr.length() == 0) {
            directoryStr = System.getProperty("java.io.tmpdir");
        }
        if (!(directoryFile = new File(directoryStr)).exists()) {
            throw new FileNotFoundException(UtilI18NResourceKeys.MSG.getMsg("ProcessExec.output-dir-does-not-exist", new Object[]{directoryFile}));
        }
        if (!directoryFile.isDirectory()) {
            throw new IOException(UtilI18NResourceKeys.MSG.getMsg("ProcessExec.output-dir-invalid", new Object[]{directoryFile}));
        }
        if (filenameStr == null || filenameStr.length() == 0) {
            String prefix = process.getProgramTitle();
            if (prefix == null) {
                prefix = process.getProgramExecutable();
            }
            prefix = prefix + "__";
            retOutputFile = File.createTempFile(prefix, ".out", directoryFile);
        } else {
            retOutputFile = new File(directoryFile, filenameStr);
            if (retOutputFile.isDirectory()) {
                throw new IOException(UtilI18NResourceKeys.MSG.getMsg("ProcessExec.output-file-is-dir", new Object[]{retOutputFile}));
            }
            if (retOutputFile.exists()) {
                if (process.isBackupOutputFile() != null && process.isBackupOutputFile().booleanValue()) {
                    this.renameFile(retOutputFile);
                } else {
                    retOutputFile.delete();
                }
            }
            if (!retOutputFile.createNewFile()) {
                throw new IOException(UtilI18NResourceKeys.MSG.getMsg("ProcessExec.output-file-creation-failure", new Object[]{retOutputFile}));
            }
        }
        return retOutputFile;
    }

    protected File getInputFile(ProcessToStart process) throws IOException {
        boolean directorySpecified;
        String directoryStr = process.getInputDirectory();
        String filenameStr = process.getInputFile();
        boolean filenameSpecified = filenameStr != null && filenameStr.length() > 0;
        boolean bl = directorySpecified = directoryStr != null && directoryStr.length() > 0;
        if (directorySpecified ^ filenameSpecified) {
            throw new IOException(UtilI18NResourceKeys.MSG.getMsg("ProcessExec.input-params-invalid", new Object[]{process}));
        }
        if (!directorySpecified) {
            return null;
        }
        File directoryFile = new File(directoryStr);
        if (!directoryFile.exists()) {
            throw new FileNotFoundException(UtilI18NResourceKeys.MSG.getMsg("ProcessExec.input-dir-does-not-exist", new Object[]{directoryFile}));
        }
        if (!directoryFile.isDirectory()) {
            throw new IOException(UtilI18NResourceKeys.MSG.getMsg("ProcessExec.input-dir-invalid", new Object[]{directoryFile}));
        }
        File retInputFile = new File(directoryFile, filenameStr);
        if (!retInputFile.exists()) {
            throw new FileNotFoundException(UtilI18NResourceKeys.MSG.getMsg("ProcessExec.input-file-does-not-exist", new Object[]{retInputFile}));
        }
        if (!retInputFile.canRead()) {
            throw new IOException(UtilI18NResourceKeys.MSG.getMsg("ProcessExec.input-file-unreadable", new Object[]{retInputFile}));
        }
        if (retInputFile.isDirectory()) {
            throw new IOException(UtilI18NResourceKeys.MSG.getMsg("ProcessExec.input-file-is-dir", new Object[]{retInputFile}));
        }
        return retInputFile;
    }

    protected String getFullProgramExecutablePath(ProcessToStart process) throws FileNotFoundException {
        File progFile = new File(process.getProgramDirectory(), process.getProgramExecutable());
        String result = progFile.getPath();
        if (Boolean.TRUE.equals(process.isCheckExecutableExists())) {
            if (!progFile.exists()) {
                throw new FileNotFoundException(UtilI18NResourceKeys.MSG.getMsg("ProcessExec.program-does-not-exist", new Object[]{progFile}));
            }
            result = progFile.getAbsolutePath();
        }
        return result;
    }

    protected File getWorkingDirectory(ProcessToStart process) throws FileNotFoundException {
        File retWorkingDir = null;
        String workingDirString = process.getWorkingDirectory();
        if (workingDirString != null && !(retWorkingDir = new File(workingDirString)).exists()) {
            throw new FileNotFoundException(UtilI18NResourceKeys.MSG.getMsg("ProcessExec.working-dir-does-not-exist", new Object[]{retWorkingDir}));
        }
        return retWorkingDir;
    }

    protected String[] getCommandLine(ProcessToStart process) throws FileNotFoundException {
        String fullProgramPath = this.getFullProgramExecutablePath(process);
        String[] args = process.getArguments();
        int numArgs = args != null ? args.length : 0;
        String[] retCmdline = new String[numArgs + 1];
        retCmdline[0] = fullProgramPath;
        if (numArgs > 0) {
            System.arraycopy(args, 0, retCmdline, 1, numArgs);
        }
        return retCmdline;
    }

    private void renameFile(File file) throws IOException {
        SimpleDateFormat formatter = new SimpleDateFormat("-yyyy-MM-dd--HH-mm-ss");
        String timestamp = formatter.format(new Date());
        String newFileName = file.getCanonicalPath() + timestamp;
        file.renameTo(new File(newFileName));
    }

    protected static class RedirectThreads {
        private final StreamRedirector stdout;
        private final StreamRedirector stderr;

        private RedirectThreads(StreamRedirector stdout, StreamRedirector stderr) {
            this.stdout = stdout;
            this.stderr = stderr;
        }

        public void join() throws InterruptedException {
            this.stderr.join();
            this.stdout.join();
        }

        public void interrupt() {
            this.stderr.interrupt();
            this.stdout.interrupt();
        }
    }
}

