/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.util.updater;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.rhq.core.util.file.FileUtil;
import org.rhq.core.util.updater.DeploymentProperties;
import org.rhq.core.util.updater.FileHashcodeMap;

public class DeploymentsMetadata {
    public static final String METADATA_DIR = ".rhqdeployments";
    public static final String CURRENT_DEPLOYMENT_FILE = "current-deployment.properties";
    public static final String PREVIOUS_DEPLOYMENT_FILE = "previous-deployment.properties";
    public static final String DEPLOYMENT_FILE = "deployment.properties";
    public static final String HASHCODES_FILE = "file-hashcodes.dat";
    public static final String BACKUP_DIR = "backup";
    public static final String EXT_BACKUP_DIR = "ext-backup";
    private final File rootDirectory;

    public DeploymentsMetadata(File rootDirectory) {
        if (rootDirectory == null) {
            throw new NullPointerException("rootDirectory == null");
        }
        this.rootDirectory = rootDirectory.getAbsoluteFile();
    }

    public String toString() {
        return "DeploymentMetadata [" + this.getRootDirectory() + "]";
    }

    public File getRootDirectory() {
        return this.rootDirectory;
    }

    public boolean isManaged() {
        File metaDir = this.getMetadataDirectory();
        if (!metaDir.isDirectory()) {
            return false;
        }
        try {
            File currentMetaDir = this.getCurrentDeploymentMetadataDirectory();
            if (!currentMetaDir.isDirectory()) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public File getMetadataDirectory() {
        return new File(this.getRootDirectory(), METADATA_DIR);
    }

    public File getMetadataDirectoryOnlyIfExists() throws Exception {
        File metaDir = this.getMetadataDirectory();
        if (!metaDir.isDirectory()) {
            throw new IllegalStateException("Not a managed deployment location: " + this.getRootDirectory());
        }
        return metaDir;
    }

    public DeploymentProperties getCurrentDeploymentProperties() throws Exception {
        try {
            File metaDir = this.getMetadataDirectoryOnlyIfExists();
            File propertiesFile = new File(metaDir, CURRENT_DEPLOYMENT_FILE);
            DeploymentProperties props = DeploymentProperties.loadFromFile(propertiesFile);
            return props;
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot determine current deployment", e);
        }
    }

    public DeploymentProperties getDeploymentProperties(int deploymentId) throws Exception {
        try {
            File deploymentSubdir = this.getDeploymentMetadataDirectory(deploymentId);
            File propertiesFile = new File(deploymentSubdir, DEPLOYMENT_FILE);
            DeploymentProperties props = DeploymentProperties.loadFromFile(propertiesFile);
            return props;
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot get deployment info", e);
        }
    }

    public DeploymentProperties getPreviousDeploymentProperties(int deploymentId) throws Exception {
        try {
            File deploymentSubdir = this.getDeploymentMetadataDirectory(deploymentId);
            File propertiesFile = new File(deploymentSubdir, PREVIOUS_DEPLOYMENT_FILE);
            DeploymentProperties props = null;
            if (propertiesFile.exists()) {
                props = DeploymentProperties.loadFromFile(propertiesFile);
            }
            return props;
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot get deployment info", e);
        }
    }

    public FileHashcodeMap getCurrentDeploymentFileHashcodes() throws Exception {
        try {
            File dir = this.getCurrentDeploymentMetadataDirectory();
            File hashcodesFile = new File(dir, HASHCODES_FILE);
            FileHashcodeMap map = FileHashcodeMap.loadFromFile(hashcodesFile);
            return map;
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot determine current deployment", e);
        }
    }

    public FileHashcodeMap getDeploymentFileHashcodes(int deploymentId) throws Exception {
        try {
            File dir = this.getDeploymentMetadataDirectory(deploymentId);
            File hashcodesFile = new File(dir, HASHCODES_FILE);
            FileHashcodeMap map = FileHashcodeMap.loadFromFile(hashcodesFile);
            return map;
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot determine deployment file hashcodes for [" + deploymentId + "]", e);
        }
    }

    public File getDeploymentBackupDirectory(int deploymentId) throws Exception {
        try {
            File dir = this.getDeploymentMetadataDirectory(deploymentId);
            File backupDir = new File(dir, BACKUP_DIR);
            if (!backupDir.isDirectory()) {
                if (!backupDir.exists()) {
                    if (!backupDir.mkdirs()) {
                        throw new IllegalStateException("Failed to create backup directory: " + backupDir);
                    }
                } else {
                    throw new IllegalStateException("backup is a file but should be a directory: " + backupDir);
                }
            }
            return backupDir;
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot determine deployment backup dir for [" + deploymentId + "]", e);
        }
    }

    public File getDeploymentExternalBackupDirectory(int deploymentId) throws Exception {
        try {
            File dir = this.getDeploymentMetadataDirectory(deploymentId);
            File backupDir = new File(dir, EXT_BACKUP_DIR);
            if (!backupDir.isDirectory()) {
                if (!backupDir.exists()) {
                    if (!backupDir.mkdirs()) {
                        throw new IllegalStateException("Failed to create external backup directory: " + backupDir);
                    }
                } else {
                    throw new IllegalStateException("ext backup is a file but should be a directory: " + backupDir);
                }
            }
            return backupDir;
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot determine deployment external backup dir for [" + deploymentId + "]", e);
        }
    }

    public Map<String, File> getDeploymentExternalBackupDirectoriesForWindows(int deploymentId) throws Exception {
        boolean isWindows;
        boolean bl = isWindows = File.separatorChar == '\\';
        if (!isWindows) {
            return null;
        }
        try {
            HashMap<String, File> backupDirs = new HashMap<String, File>();
            Pattern driveLetterPattern = Pattern.compile("_([a-zA-Z])");
            File dir = this.getDeploymentExternalBackupDirectory(deploymentId);
            File[] children = dir.listFiles();
            if (children != null) {
                for (File child : children) {
                    String dirName;
                    Matcher m;
                    if (!child.isDirectory() || !(m = driveLetterPattern.matcher(dirName = child.getName())).matches()) continue;
                    String driveLetter = m.group(1).toUpperCase();
                    backupDirs.put(driveLetter + ":\\", child);
                }
            }
            return backupDirs;
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot determine deployment external backup dir for [" + deploymentId + "]", e);
        }
    }

    public String getExternalBackupDirectoryNameForWindows(String driveLetter) {
        return "_" + driveLetter.toUpperCase();
    }

    public void setCurrentDeployment(DeploymentProperties deploymentProps, FileHashcodeMap fileHashcodeMap, boolean rememberPrevious) throws Exception {
        this.getMetadataDirectory().mkdirs();
        File deploymentMetadataDir = this.getDeploymentMetadataDirectory(deploymentProps.getDeploymentId());
        deploymentMetadataDir.mkdirs();
        if (!deploymentMetadataDir.isDirectory()) {
            throw new Exception("Failed to create deployment metadata directory: " + deploymentMetadataDir);
        }
        deploymentProps.saveToFile(new File(deploymentMetadataDir, DEPLOYMENT_FILE));
        fileHashcodeMap.storeToFile(new File(deploymentMetadataDir, HASHCODES_FILE));
        File currentDeploymentPropertiesFile = new File(this.getMetadataDirectory(), CURRENT_DEPLOYMENT_FILE);
        if (rememberPrevious) {
            File previousDeploymentPropertiesFile = new File(deploymentMetadataDir, PREVIOUS_DEPLOYMENT_FILE);
            if (currentDeploymentPropertiesFile.exists()) {
                FileUtil.copyFile(currentDeploymentPropertiesFile, previousDeploymentPropertiesFile);
            }
        }
        deploymentProps.saveToFile(currentDeploymentPropertiesFile);
    }

    public FileHashcodeMap snapshotLiveDeployment(DeploymentProperties deploymentProps, Pattern ignoreRegex, Set<String> ignored) throws Exception {
        FileHashcodeMap map = FileHashcodeMap.generateFileHashcodeMap(this.getRootDirectory(), ignoreRegex, ignored);
        this.setCurrentDeployment(deploymentProps, map, true);
        return map;
    }

    private File getCurrentDeploymentMetadataDirectory() throws Exception {
        DeploymentProperties currentDeploymentProps = this.getCurrentDeploymentProperties();
        return this.getDeploymentMetadataDirectory(currentDeploymentProps.getDeploymentId());
    }

    private File getDeploymentMetadataDirectory(int deploymentId) throws Exception {
        File metaDir = this.getMetadataDirectoryOnlyIfExists();
        File deploymentSubdir = new File(metaDir, Integer.toString(deploymentId));
        return deploymentSubdir;
    }
}

