/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.bindings.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import javassist.bytecode.ParameterAnnotationsAttribute;
import javassist.bytecode.SignatureAttribute;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.AnnotationMemberValue;
import javassist.bytecode.annotation.ArrayMemberValue;
import javassist.bytecode.annotation.BooleanMemberValue;
import javassist.bytecode.annotation.ByteMemberValue;
import javassist.bytecode.annotation.CharMemberValue;
import javassist.bytecode.annotation.ClassMemberValue;
import javassist.bytecode.annotation.DoubleMemberValue;
import javassist.bytecode.annotation.EnumMemberValue;
import javassist.bytecode.annotation.FloatMemberValue;
import javassist.bytecode.annotation.IntegerMemberValue;
import javassist.bytecode.annotation.LongMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.MemberValueVisitor;
import javassist.bytecode.annotation.ShortMemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.bindings.util.ClassPoolFactory;
import org.rhq.bindings.util.SimplifiedClass;
import org.rhq.bindings.util.SimplifiedMethod;
import org.rhq.core.domain.auth.Subject;

public class InterfaceSimplifier {
    private static final Log LOG = LogFactory.getLog(InterfaceSimplifier.class);

    private InterfaceSimplifier() {
    }

    public static Method getOriginalMethod(Method method) {
        SimplifiedClass simplifiedClass = method.getDeclaringClass().getAnnotation(SimplifiedClass.class);
        if (simplifiedClass == null) {
            return null;
        }
        SimplifiedMethod simplifiedMethod = method.getAnnotation(SimplifiedMethod.class);
        Class<?> origClass = simplifiedClass.originalClass();
        if (simplifiedMethod == null) {
            try {
                return origClass.getMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Inconsisten interface simplification. The non-simplified method " + method + " should have had a counterpart with the exact signature on the interface " + origClass + " but it could not be found.", e);
            }
        }
        Class[] paramTypes = new Class[method.getParameterTypes().length + 1];
        paramTypes[0] = Subject.class;
        System.arraycopy(method.getParameterTypes(), 0, paramTypes, 1, paramTypes.length - 1);
        try {
            return origClass.getMethod(method.getName(), paramTypes);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Inconsistent interface simplification. The simplified method " + method + " should have had a counterpart on the interface " + origClass + " but it couldn't be found.", e);
        }
    }

    public static boolean isSimplified(Class<?> cls) {
        return cls.getAnnotation(SimplifiedClass.class) != null;
    }

    public static boolean isSimplified(Method method) {
        return method.getAnnotation(SimplifiedMethod.class) != null;
    }

    public static Class<?> simplify(Class<?> intf) {
        try {
            CtMethod[] methods;
            String simplifiedName;
            ClassPool classPool;
            block15: {
                classPool = ClassPoolFactory.getClassPoolForCurrentContextClassLoader();
                simplifiedName = InterfaceSimplifier.getSimplifiedName(intf);
                LOG.debug((Object)("Simplifying " + intf + " (simplified interface name: " + simplifiedName + ")..."));
                CtClass cached = null;
                try {
                    cached = classPool.get(simplifiedName);
                    return Class.forName(simplifiedName, false, classPool.getClassLoader());
                }
                catch (NotFoundException e) {
                }
                catch (ClassNotFoundException e) {
                    LOG.debug((Object)("Class [" + simplifiedName + "] not found - cause: " + e), (Throwable)e);
                    if (cached == null) break block15;
                    return cached.toClass();
                }
            }
            CtClass originalClass = classPool.get(intf.getName());
            ClassFile originalClassFile = originalClass.getClassFile();
            CtClass newClass = classPool.makeInterface(simplifiedName);
            newClass.defrost();
            ClassFile newClassFile = newClass.getClassFile();
            ConstPool constPool = newClassFile.getConstPool();
            AnnotationsAttribute annotations = (AnnotationsAttribute)originalClassFile.getAttribute("RuntimeVisibleAnnotations");
            AnnotationsAttribute newAnnotations = InterfaceSimplifier.copyAnnotations(annotations, constPool);
            newAnnotations = InterfaceSimplifier.addSimplifiedClassAnnotation(originalClass.getName(), newAnnotations, constPool);
            newClassFile.addAttribute((AttributeInfo)newAnnotations);
            SignatureAttribute signature = (SignatureAttribute)originalClassFile.getAttribute("Signature");
            if (signature != null) {
                newClassFile.addAttribute((AttributeInfo)new SignatureAttribute(constPool, signature.getSignature()));
            }
            for (CtMethod originalMethod : methods = originalClass.getMethods()) {
                boolean simplify;
                if (!Modifier.isAbstract((int)originalMethod.getModifiers())) continue;
                CtClass[] params = originalMethod.getParameterTypes();
                annotations = (AnnotationsAttribute)originalMethod.getMethodInfo().getAttribute("RuntimeVisibleAnnotations");
                ParameterAnnotationsAttribute parameterAnnotations = (ParameterAnnotationsAttribute)originalMethod.getMethodInfo().getAttribute("RuntimeVisibleParameterAnnotations");
                signature = (SignatureAttribute)originalMethod.getMethodInfo().getAttribute("Signature");
                boolean bl = simplify = params.length > 0 && params[0].getName().equals(Subject.class.getName());
                if (simplify) {
                    CtClass[] simpleParams = new CtClass[params.length - 1];
                    System.arraycopy(params, 1, simpleParams, 0, params.length - 1);
                    params = simpleParams;
                }
                CtMethod newMethod = CtNewMethod.abstractMethod((CtClass)originalMethod.getReturnType(), (String)originalMethod.getName(), (CtClass[])params, (CtClass[])originalMethod.getExceptionTypes(), (CtClass)newClass);
                annotations = InterfaceSimplifier.copyAnnotations(annotations, constPool);
                if (simplify) {
                    annotations = InterfaceSimplifier.addSimplifiedMethodAnnotation(annotations, constPool);
                    if (signature != null) {
                        MethodSignature sig = MethodSignature.parse(signature.getSignature());
                        sig.paramTypes.remove(0);
                        signature = new SignatureAttribute(constPool, sig.toString());
                    }
                    parameterAnnotations = InterfaceSimplifier.copyParameterAnnotations(parameterAnnotations, constPool, 1);
                } else {
                    if (signature != null) {
                        signature = new SignatureAttribute(constPool, signature.getSignature());
                    }
                    parameterAnnotations = InterfaceSimplifier.copyParameterAnnotations(parameterAnnotations, constPool, 0);
                }
                if (parameterAnnotations != null) {
                    newMethod.getMethodInfo().addAttribute((AttributeInfo)parameterAnnotations);
                }
                if (signature != null) {
                    newMethod.getMethodInfo().addAttribute((AttributeInfo)signature);
                }
                if (annotations != null) {
                    newMethod.getMethodInfo().addAttribute((AttributeInfo)annotations);
                }
                newClassFile.addMethod(newMethod.getMethodInfo());
            }
            return newClass.toClass();
        }
        catch (Exception e) {
            String msg = "Failed to simplify " + intf + ".";
            LOG.error((Object)msg, (Throwable)e);
            throw new IllegalStateException(msg, e);
        }
    }

    private static String getSimplifiedName(Class<?> interfaceClass) {
        String fullName = interfaceClass.getName();
        String simpleName = interfaceClass.getSimpleName();
        Package pkg = interfaceClass.getPackage();
        String packageName = pkg != null ? pkg.getName() : fullName.substring(0, fullName.length() - (simpleName.length() + 1));
        return packageName + ".wrapped." + simpleName + "Simple";
    }

    private static Annotation cloneAnnotation(Annotation annotation, ConstPool constPool) throws NotFoundException {
        Annotation ret = new Annotation(annotation.getTypeName(), constPool);
        if (annotation.getMemberNames() != null) {
            for (Object m : annotation.getMemberNames()) {
                String memberName = (String)m;
                MemberValue origValue = annotation.getMemberValue(memberName);
                MemberValue[] newValue = new MemberValue[1];
                origValue.accept((MemberValueVisitor)new ArrayIndexAssigningVisitor(newValue, 0, constPool));
                ret.addMemberValue(memberName, newValue[0]);
            }
        }
        return ret;
    }

    private static AnnotationsAttribute copyAnnotations(AnnotationsAttribute annotations, ConstPool constPool) throws NotFoundException {
        if (annotations != null) {
            Annotation[] origAnnotations = annotations.getAnnotations();
            Annotation[] newClassAnnotations = new Annotation[origAnnotations.length];
            for (int i = 0; i < newClassAnnotations.length; ++i) {
                newClassAnnotations[i] = InterfaceSimplifier.cloneAnnotation(origAnnotations[i], constPool);
            }
            AnnotationsAttribute newAnnotations = new AnnotationsAttribute(constPool, "RuntimeVisibleAnnotations");
            newAnnotations.setAnnotations(newClassAnnotations);
            return newAnnotations;
        }
        return null;
    }

    private static ParameterAnnotationsAttribute copyParameterAnnotations(ParameterAnnotationsAttribute parameterAnnotations, ConstPool constPool, int fromIndex) throws NotFoundException {
        if (parameterAnnotations != null) {
            Annotation[][] originalAnnotations = parameterAnnotations.getAnnotations();
            if (originalAnnotations.length - fromIndex <= 0) {
                return null;
            }
            Annotation[][] newParameterAnnotations = new Annotation[originalAnnotations.length - fromIndex][];
            for (int i = fromIndex; i < originalAnnotations.length; ++i) {
                newParameterAnnotations[i - fromIndex] = new Annotation[originalAnnotations[i].length];
                for (int j = 0; j < originalAnnotations[i].length; ++j) {
                    Annotation origAnnotation = originalAnnotations[i][j];
                    newParameterAnnotations[i - fromIndex][j] = InterfaceSimplifier.cloneAnnotation(origAnnotation, constPool);
                }
            }
            ParameterAnnotationsAttribute newAnnotationsAttribute = new ParameterAnnotationsAttribute(constPool, "RuntimeVisibleParameterAnnotations");
            newAnnotationsAttribute.setAnnotations((Annotation[][])newParameterAnnotations);
            return newAnnotationsAttribute;
        }
        return null;
    }

    private static AnnotationsAttribute addSimplifiedClassAnnotation(String originalClassName, AnnotationsAttribute annotations, ConstPool constPool) {
        if (annotations == null) {
            annotations = new AnnotationsAttribute(constPool, "RuntimeVisibleAnnotations");
        }
        Annotation simplified = new Annotation(SimplifiedClass.class.getName(), constPool);
        simplified.addMemberValue("originalClass", (MemberValue)new ClassMemberValue(originalClassName, constPool));
        annotations.addAnnotation(simplified);
        return annotations;
    }

    private static AnnotationsAttribute addSimplifiedMethodAnnotation(AnnotationsAttribute annotations, ConstPool constPool) {
        if (annotations == null) {
            annotations = new AnnotationsAttribute(constPool, "RuntimeVisibleAnnotations");
        }
        annotations.addAnnotation(new Annotation(SimplifiedMethod.class.getName(), constPool));
        return annotations;
    }

    private static class MethodSignature {
        public String returnType;
        public List<String> paramTypes = new ArrayList<String>();
        public String typeParameters;
        public String exceptionTypes;

        private MethodSignature() {
        }

        public static MethodSignature parse(String signature) {
            int startParams = signature.indexOf(40) + 1;
            int endParams = signature.indexOf(41);
            int startExceptions = signature.indexOf(94);
            MethodSignature sig = new MethodSignature();
            sig.typeParameters = signature.substring(0, startParams - 1);
            if (startExceptions == -1) {
                sig.returnType = signature.substring(endParams + 1);
                sig.exceptionTypes = "";
            } else {
                sig.returnType = signature.substring(endParams + 1, startExceptions);
                sig.exceptionTypes = signature.substring(startExceptions);
            }
            int idx = startParams;
            while (idx < endParams) {
                int end = MethodSignature.findEndOfTypeSignature(idx, signature);
                sig.paramTypes.add(signature.substring(idx, end));
                idx = end;
            }
            return sig;
        }

        private static int findEndOfTypeSignature(int idx, String signature) {
            char c = signature.charAt(idx);
            switch (c) {
                case 'L': {
                    return MethodSignature.findEndOfClassSignature(idx, signature);
                }
                case '[': {
                    return MethodSignature.findEndOfTypeSignature(idx + 1, signature);
                }
                case 'T': {
                    return signature.indexOf(59, idx + 1) + 1;
                }
            }
            return idx + 1;
        }

        private static int findEndOfClassSignature(int indexOfL, String signature) {
            int idx = indexOfL + 1;
            int genericDeclDepth = 0;
            while (idx < signature.length()) {
                boolean sigComplete = false;
                char c = signature.charAt(idx++);
                switch (c) {
                    case '<': {
                        ++genericDeclDepth;
                        break;
                    }
                    case '>': {
                        --genericDeclDepth;
                        break;
                    }
                    case ';': {
                        boolean bl = sigComplete = genericDeclDepth == 0;
                    }
                }
                if (!sigComplete) continue;
                break;
            }
            return idx;
        }

        public String toString() {
            StringBuilder bld = new StringBuilder(this.typeParameters);
            bld.append("(");
            for (String p : this.paramTypes) {
                bld.append(p);
            }
            bld.append(")");
            bld.append(this.returnType);
            bld.append(this.exceptionTypes);
            return bld.toString();
        }
    }

    private static class ArrayIndexAssigningVisitor
    implements MemberValueVisitor {
        private MemberValue[] array;
        private int index;
        private ConstPool constPool;

        public ArrayIndexAssigningVisitor(MemberValue[] array, int index, ConstPool constPool) {
            this.array = array;
            this.index = index;
            this.constPool = constPool;
        }

        public void visitStringMemberValue(StringMemberValue node) {
            this.array[this.index] = new StringMemberValue(node.getValue(), this.constPool);
        }

        public void visitShortMemberValue(ShortMemberValue node) {
            this.array[this.index] = new ShortMemberValue(node.getValue(), this.constPool);
        }

        public void visitLongMemberValue(LongMemberValue node) {
            this.array[this.index] = new LongMemberValue(node.getValue(), this.constPool);
        }

        public void visitIntegerMemberValue(IntegerMemberValue node) {
            this.array[this.index] = new IntegerMemberValue(this.constPool, node.getValue());
        }

        public void visitFloatMemberValue(FloatMemberValue node) {
            this.array[this.index] = new FloatMemberValue(node.getValue(), this.constPool);
        }

        public void visitEnumMemberValue(EnumMemberValue node) {
            EnumMemberValue val = new EnumMemberValue(this.constPool);
            val.setType(node.getType());
            val.setValue(node.getValue());
            this.array[this.index] = val;
        }

        public void visitDoubleMemberValue(DoubleMemberValue node) {
            this.array[this.index] = new DoubleMemberValue(node.getValue(), this.constPool);
        }

        public void visitClassMemberValue(ClassMemberValue node) {
            this.array[this.index] = new ClassMemberValue(node.getValue(), this.constPool);
        }

        public void visitCharMemberValue(CharMemberValue node) {
            this.array[this.index] = new CharMemberValue(node.getValue(), this.constPool);
        }

        public void visitByteMemberValue(ByteMemberValue node) {
            this.array[this.index] = new ByteMemberValue(node.getValue(), this.constPool);
        }

        public void visitBooleanMemberValue(BooleanMemberValue node) {
            this.array[this.index] = new BooleanMemberValue(node.getValue(), this.constPool);
        }

        public void visitArrayMemberValue(ArrayMemberValue node) {
            ArrayMemberValue val = new ArrayMemberValue(node.getType(), this.constPool);
            MemberValue[] newVals = new MemberValue[node.getValue().length];
            for (int i = 0; i < node.getValue().length; ++i) {
                node.getValue()[i].accept((MemberValueVisitor)new ArrayIndexAssigningVisitor(newVals, i, this.constPool));
            }
            val.setValue(newVals);
            this.array[this.index] = val;
        }

        public void visitAnnotationMemberValue(AnnotationMemberValue node) {
            this.array[this.index] = new AnnotationMemberValue(node.getValue(), this.constPool);
        }
    }
}

