/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.naming;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.event.EventContext;
import javax.naming.event.EventDirContext;
import javax.naming.ldap.LdapContext;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.InitialContextFactoryBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.enterprise.server.naming.DecoratingInitialContextFactory;
import org.rhq.enterprise.server.naming.context.AccessCheckingContextDecoratorSetContext;
import org.rhq.enterprise.server.naming.context.ContextDecorator;
import org.rhq.enterprise.server.naming.context.URLPreferringContextDecoratorSetContext;
import org.rhq.enterprise.server.naming.util.DecoratorPicker;

public class AccessCheckingInitialContextFactoryBuilder
implements InitialContextFactoryBuilder {
    private static final Log LOG = LogFactory.getLog(AccessCheckingInitialContextFactoryBuilder.class);
    private static final String[] CHECKED_SCHEMES = new String[]{"java"};
    private static final Set<Class<? extends Context>> SUPPORTED_CONTEXT_INTERFACES = new HashSet<Class<? extends Context>>();
    private static final Set<InetAddress> SERVER_BIND_IPS;
    private static final int JNP_PORT;
    private final EnumMap<FactoryType, InitialContextFactory> typeDefaults = new EnumMap(FactoryType.class);
    private final String defaultFactoryClassName;
    private final boolean pretendNoFactoryBuilder;
    private final InitialContextFactory defaultFactory;

    private static InitialContextFactory getJbossDefaultInitialContextFactory() throws NamingException {
        try {
            Class<?> cls = Class.forName("org.jboss.as.naming.InitialContextFactory");
            return (InitialContextFactory)cls.newInstance();
        }
        catch (Exception e) {
            NamingException ne = new NamingException("Failed to obtain the default initial context factory from JBoss AS.");
            ne.initCause(e);
            throw ne;
        }
    }

    public AccessCheckingInitialContextFactoryBuilder(InitialContextFactory defaultFactory, final boolean pretendNoFactoryBuilder) throws NamingException {
        if (defaultFactory == null) {
            defaultFactory = AccessCheckingInitialContextFactoryBuilder.getJbossDefaultInitialContextFactory();
        }
        this.defaultFactoryClassName = defaultFactory.getClass().getName();
        for (FactoryType ft : FactoryType.values()) {
            this.typeDefaults.put(ft, ft.wrap(defaultFactory));
        }
        this.pretendNoFactoryBuilder = pretendNoFactoryBuilder;
        this.defaultFactory = new InitialContextFactory(){

            @Override
            public Context getInitialContext(Hashtable<?, ?> environment) throws NamingException {
                return ((InitialContextFactory)AccessCheckingInitialContextFactoryBuilder.this.typeDefaults.get((Object)FactoryType.detect(environment, pretendNoFactoryBuilder))).getInitialContext(environment);
            }
        };
    }

    @Override
    public InitialContextFactory createInitialContextFactory(Hashtable<?, ?> environment) throws NamingException {
        String factoryClassName = (String)environment.get("java.naming.factory.initial");
        if (factoryClassName == null || factoryClassName.equals(this.defaultFactoryClassName)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"No java.naming.factory.initial set. Using the default factory.");
            }
            return this.defaultFactory;
        }
        ClassLoader classLoader = this.getContextClassLoader();
        try {
            Class<?> factoryClass = Class.forName(factoryClassName, true, classLoader);
            InitialContextFactory configuredFactory = (InitialContextFactory)factoryClass.newInstance();
            return FactoryType.detect(environment, this.pretendNoFactoryBuilder).wrap(configuredFactory);
        }
        catch (Exception e) {
            NamingException ne = new NamingException("Failed instantiate InitialContextFactory " + factoryClassName + " from classloader " + classLoader);
            ne.initCause(e);
            throw ne;
        }
    }

    private ClassLoader getContextClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    static {
        SUPPORTED_CONTEXT_INTERFACES.add(Context.class);
        SUPPORTED_CONTEXT_INTERFACES.add(DirContext.class);
        SUPPORTED_CONTEXT_INTERFACES.add(EventContext.class);
        SUPPORTED_CONTEXT_INTERFACES.add(EventDirContext.class);
        SUPPORTED_CONTEXT_INTERFACES.add(LdapContext.class);
        SERVER_BIND_IPS = new HashSet<InetAddress>();
        try {
            String bindingAddressString = System.getProperty("jboss.bind.address");
            InetAddress bindingAddress = InetAddress.getByName(bindingAddressString);
            if (bindingAddress.isAnyLocalAddress()) {
                Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
                while (ifaces.hasMoreElements()) {
                    NetworkInterface iface = ifaces.nextElement();
                    SERVER_BIND_IPS.addAll(Collections.list(iface.getInetAddresses()));
                }
            } else {
                SERVER_BIND_IPS.add(bindingAddress);
            }
        }
        catch (SocketException e) {
            LOG.error((Object)"Could not obtain the list of local IPs", (Throwable)e);
        }
        catch (UnknownHostException e) {
            LOG.error((Object)"Failed to get the binding address of the RHQ server.", (Throwable)e);
        }
        JNP_PORT = Integer.parseInt(System.getProperty("rhq.server.startup.namingservice.port", "2099"));
    }

    private static enum FactoryType {
        ACCESS_CHECKING_URL_PREFERRING{

            @Override
            public InitialContextFactory wrap(InitialContextFactory factory) {
                ArrayList<DecoratorPicker<Context, ContextDecorator>> pickers = new ArrayList<DecoratorPicker<Context, ContextDecorator>>();
                pickers.add(FactoryType.getURLPreferringDecoratorPicker());
                pickers.add(FactoryType.getAccessCheckingDecoratorPicker());
                return new DecoratingInitialContextFactory(factory, pickers);
            }
        }
        ,
        URL_PREFERRING{

            @Override
            public InitialContextFactory wrap(InitialContextFactory factory) {
                ArrayList<DecoratorPicker<Context, ContextDecorator>> pickers = new ArrayList<DecoratorPicker<Context, ContextDecorator>>();
                pickers.add(FactoryType.getURLPreferringDecoratorPicker());
                return new DecoratingInitialContextFactory(factory, pickers);
            }
        }
        ,
        ACCESS_CHECKING{

            @Override
            public InitialContextFactory wrap(InitialContextFactory factory) {
                ArrayList<DecoratorPicker<Context, ContextDecorator>> pickers = new ArrayList<DecoratorPicker<Context, ContextDecorator>>();
                pickers.add(FactoryType.getAccessCheckingDecoratorPicker());
                return new DecoratingInitialContextFactory(factory, pickers);
            }
        }
        ,
        PASS_THROUGH{

            @Override
            public InitialContextFactory wrap(InitialContextFactory factory) {
                return factory;
            }
        };


        public abstract InitialContextFactory wrap(InitialContextFactory var1);

        public static FactoryType detect(Hashtable<?, ?> environment, boolean pretendNoFactoryBuilder) {
            String providerUrl = (String)environment.get("java.naming.provider.url");
            if (providerUrl == null) {
                return pretendNoFactoryBuilder ? ACCESS_CHECKING_URL_PREFERRING : ACCESS_CHECKING;
            }
            try {
                URI uri = new URI(providerUrl);
                InetAddress providerHost = InetAddress.getByName(uri.getHost());
                if (uri.getPort() == JNP_PORT && SERVER_BIND_IPS.contains(providerHost)) {
                    return pretendNoFactoryBuilder ? ACCESS_CHECKING_URL_PREFERRING : ACCESS_CHECKING;
                }
                return pretendNoFactoryBuilder ? URL_PREFERRING : PASS_THROUGH;
            }
            catch (URISyntaxException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"The java.naming.provider.url is not a valid URI. Falling back to using the access checking wrapper.", (Throwable)e);
                }
                return pretendNoFactoryBuilder ? ACCESS_CHECKING_URL_PREFERRING : ACCESS_CHECKING;
            }
            catch (UnknownHostException e) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"The java.naming.provider.url is not resolvable. Falling back to using the URL preferring wrapper.", (Throwable)e);
                }
                return pretendNoFactoryBuilder ? URL_PREFERRING : PASS_THROUGH;
            }
        }

        private static DecoratorPicker<Context, ContextDecorator> getAccessCheckingDecoratorPicker() {
            DecoratorPicker<Context, ContextDecorator> ret = new DecoratorPicker<Context, ContextDecorator>();
            ret.setContext(new AccessCheckingContextDecoratorSetContext(SUPPORTED_CONTEXT_INTERFACES, CHECKED_SCHEMES));
            return ret;
        }

        private static DecoratorPicker<Context, ContextDecorator> getURLPreferringDecoratorPicker() {
            DecoratorPicker<Context, ContextDecorator> ret = new DecoratorPicker<Context, ContextDecorator>();
            ret.setContext(new URLPreferringContextDecoratorSetContext(SUPPORTED_CONTEXT_INTERFACES));
            return ret;
        }
    }
}

