/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugin.pc.content;

import java.util.HashMap;
import java.util.Map;
import org.rhq.core.clientapi.agent.metadata.ConfigurationMetadataParser;
import org.rhq.core.clientapi.agent.metadata.InvalidPluginDescriptorException;
import org.rhq.core.clientapi.descriptor.configuration.ConfigurationDescriptor;
import org.rhq.core.domain.content.PackageType;
import org.rhq.enterprise.server.auth.SubjectManagerLocal;
import org.rhq.enterprise.server.content.ContentManagerLocal;
import org.rhq.enterprise.server.plugin.pc.AbstractTypeServerPluginContainer;
import org.rhq.enterprise.server.plugin.pc.ServerPluginComponent;
import org.rhq.enterprise.server.plugin.pc.ServerPluginEnvironment;
import org.rhq.enterprise.server.plugin.pc.ServerPluginManager;
import org.rhq.enterprise.server.plugin.pc.content.AbstractPackageTypeBehavior;
import org.rhq.enterprise.server.util.LookupUtil;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.packagetype.PackageTypeDefinitionType;
import org.rhq.enterprise.server.xmlschema.generated.serverplugin.packagetype.PackageTypePluginDescriptorType;

public class PackageTypePluginManager
extends ServerPluginManager {
    private Map<PackageType, ServerPluginEnvironment> pluginsByPackageTypeId = new HashMap<PackageType, ServerPluginEnvironment>();

    public PackageTypePluginManager(AbstractTypeServerPluginContainer pc) {
        super(pc);
    }

    @Override
    protected void loadPlugin(ServerPluginEnvironment env, boolean enabled) throws Exception {
        super.loadPlugin(env, enabled);
        PackageTypePluginDescriptorType descriptor = (PackageTypePluginDescriptorType)env.getPluginDescriptor();
        try {
            String behaviorClassName = descriptor.getBehaviorClass();
            Class<?> behaviorClass = this.loadPluginClass(env, behaviorClassName, false);
            if (!AbstractPackageTypeBehavior.class.isAssignableFrom(behaviorClass)) {
                throw new Exception("The behavior class '" + behaviorClassName + "' of the plugin '" + env.getPluginKey().getPluginName() + "' does not inherit from AbstractPackageTypeBehavior class.");
            }
            for (PackageTypeDefinitionType def : descriptor.getPackageType()) {
                PackageType pt = this.ensurePackageTypeExists(def);
                this.pluginsByPackageTypeId.put(pt, env);
            }
        }
        catch (Exception e) {
            try {
                this.unloadPlugin(env.getPluginKey().getPluginName());
            }
            catch (Exception ignore) {
                // empty catch block
            }
            throw e;
        }
    }

    private PackageType ensurePackageTypeExists(PackageTypeDefinitionType def) throws InvalidPluginDescriptorException {
        SubjectManagerLocal subjectManager = LookupUtil.getSubjectManager();
        ContentManagerLocal cm = LookupUtil.getContentManager();
        PackageType packageType = cm.findPackageType(subjectManager.getOverlord(), null, def.getName());
        if (packageType == null) {
            packageType = new PackageType(def.getName(), null);
            packageType.setDescription(def.getDescription());
            packageType.setDisplayName(def.getDisplayName());
            packageType.setSupportsArchitecture(def.isSupportsArchitecture());
            packageType.setCreationData(false);
            packageType.setDeploymentConfigurationDefinition(ConfigurationMetadataParser.parse((String)def.getName(), (ConfigurationDescriptor)def.getConfiguration()));
            packageType.setDiscoveryInterval(-1L);
            packageType.setPackageExtraPropertiesDefinition(null);
            packageType = cm.persistServersidePackageType(packageType);
        }
        return packageType;
    }

    public AbstractPackageTypeBehavior<? extends ServerPluginComponent> getBehavior(int packageTypeId) throws Exception {
        return this.getBehavior(this.findByPackageTypeId(packageTypeId));
    }

    public AbstractPackageTypeBehavior<? extends ServerPluginComponent> getBehavior(String packageTypeName) throws Exception {
        return this.getBehavior(this.findByPackageTypeName(packageTypeName));
    }

    private AbstractPackageTypeBehavior<? extends ServerPluginComponent> getBehavior(ServerPluginEnvironment env) throws Exception {
        if (env == null) {
            return null;
        }
        PackageTypePluginDescriptorType descriptor = (PackageTypePluginDescriptorType)env.getPluginDescriptor();
        String behaviorClassName = descriptor.getBehaviorClass();
        AbstractPackageTypeBehavior ret = (AbstractPackageTypeBehavior)this.instantiatePluginClass(env, behaviorClassName);
        ret.pluginComponent = this.getServerPluginComponent(env.getPluginKey().getPluginName());
        return ret;
    }

    private ServerPluginEnvironment findByPackageTypeId(int id) {
        for (Map.Entry<PackageType, ServerPluginEnvironment> entry : this.pluginsByPackageTypeId.entrySet()) {
            if (entry.getKey().getId() != id) continue;
            return entry.getValue();
        }
        return null;
    }

    private ServerPluginEnvironment findByPackageTypeName(String name) {
        for (Map.Entry<PackageType, ServerPluginEnvironment> entry : this.pluginsByPackageTypeId.entrySet()) {
            if (!entry.getKey().getName().equals(name)) continue;
            return entry.getValue();
        }
        return null;
    }
}

