/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.enterprise.server.plugin.pc.content;

import org.rhq.core.domain.content.ContentSyncStatus;
import org.rhq.core.domain.content.RepoSyncResults;
import org.rhq.core.util.progresswatch.ProgressWatcher;
import org.rhq.enterprise.server.plugin.pc.content.ContentProvider;
import org.rhq.enterprise.server.plugin.pc.content.SyncProgressWeight;

public class SyncTracker {
    private int repoId;
    private RepoSyncResults repoSyncResults;
    private ProgressWatcher progressWatcher;
    private int packageSyncCount;

    public SyncTracker(RepoSyncResults repoSyncResultsIn, ProgressWatcher progressWatcherIn) {
        this.repoId = repoSyncResultsIn.getRepo().getId();
        this.repoSyncResults = repoSyncResultsIn;
        this.progressWatcher = progressWatcherIn;
        this.progressWatcher.start();
    }

    public void addAdvisoryMetadataWork(ContentProvider provider) {
        SyncProgressWeight sw = provider.getSyncProgressWeight();
        if (this.getPackageSyncCount() == 0) {
            this.getProgressWatcher().addWork(sw.getAdvisoryWeight() * 10);
        } else {
            this.getProgressWatcher().addWork(sw.getAdvisoryWeight() * this.getPackageSyncCount());
        }
    }

    public void finishAdvisoryMetadataWork(ContentProvider provider) {
        if (this.getPackageSyncCount() == 0) {
            this.getProgressWatcher().finishWork(provider.getSyncProgressWeight().getAdvisoryWeight() * 10);
        } else {
            this.getProgressWatcher().finishWork(provider.getSyncProgressWeight().getAdvisoryWeight() * this.getPackageSyncCount());
        }
    }

    public void addPackageBitsWork(ContentProvider provider) {
        SyncProgressWeight sw = provider.getSyncProgressWeight();
        this.getProgressWatcher().addWork(sw.getPackageBitsWeight() * this.getPackageSyncCount());
    }

    public RepoSyncResults getRepoSyncResults() {
        return this.repoSyncResults;
    }

    public ProgressWatcher getProgressWatcher() {
        return this.progressWatcher;
    }

    public void setRepoSyncResults(RepoSyncResults syncResultsIn) {
        this.repoSyncResults = syncResultsIn;
    }

    public void setResults(String resultsIn) {
        this.repoSyncResults.setResults(resultsIn);
    }

    public void setStatus(ContentSyncStatus statusIn) {
        this.repoSyncResults.setStatus(statusIn);
    }

    public int getPackageSyncCount() {
        return this.packageSyncCount;
    }

    public void setPackageSyncCount(int packageSyncCount) {
        this.packageSyncCount = packageSyncCount;
    }

    public int getRepoId() {
        return this.repoId;
    }
}

